/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs;

import java.net.http.HttpRequest;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import org.neo4j.annotations.service.Service;
import org.neo4j.genai.dbs.RequestConfig;
import org.neo4j.genai.dbs.VectorDatabaseRequest;
import org.neo4j.genai.util.GenAIProcedureException;

@Service
public interface VectorDatabaseProvider {
    default public String getName() {
        return this.getClass().getSimpleName().toLowerCase(Locale.ROOT);
    }

    default public boolean supportsMultipleGet() {
        return true;
    }

    default public boolean supportsMultipleUpserts() {
        return true;
    }

    public <T> VectorDatabaseRequest<T> createRequestFor(Command var1, String var2, String var3, Map<String, Object> var4, Map<String, Object> var5);

    default public <T> VectorDatabaseRequest<T> handleFailedUpsertRequest(GenAIProcedureException exception, String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments) {
        throw new UnsupportedOperationException();
    }

    default public Optional<VectorDatabaseRequest<String>> getCollectionSpecificHost(Command command, String defaultHost, String collection, Map<String, Object> configuration) {
        return Optional.empty();
    }

    default public BiFunction<Integer, String, Optional<GenAIProcedureException>> getProviderSpecificStatusHandler(String collection) {
        return (statusCode, message) -> Optional.empty();
    }

    default public HttpRequest.Builder addAuthorizationHeader(Map<String, Object> configuration, HttpRequest.Builder httpRequestBuilder) {
        Map headerConfig = RequestConfig.Keys.HEADERS.get(Map.class, configuration);
        if (headerConfig != null && headerConfig.containsKey(RequestConfig.Keys.AUTHORIZATION.key())) {
            httpRequestBuilder = httpRequestBuilder.header(RequestConfig.Keys.AUTHORIZATION.key(), (String)headerConfig.get(RequestConfig.Keys.AUTHORIZATION.key()));
        } else if (configuration.containsKey(RequestConfig.Keys.TOKEN.key())) {
            httpRequestBuilder = httpRequestBuilder.header(RequestConfig.Keys.AUTHORIZATION.key(), "Bearer " + String.valueOf(configuration.get(RequestConfig.Keys.TOKEN.key())));
        }
        return httpRequestBuilder;
    }

    public static enum Command {
        GET_COLLECTION_METADATA,
        CREATE_COLLECTION,
        DELETE_COLLECTION,
        UPSERT,
        DELETE,
        GET,
        GET_AND_UPDATE,
        QUERY,
        QUERY_AND_UPDATE;

    }
}

