/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.neo4j.genai.dbs.RequestConfig;
import org.neo4j.genai.dbs.RowMappingConfig;
import org.neo4j.genai.dbs.VectorDatabaseProvider;
import org.neo4j.genai.dbs.VectorDatabaseRequest;
import org.neo4j.genai.dbs.VectorDatabases;
import org.neo4j.genai.util.GenAIProcedureException;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;

public final class Pinecone
implements VectorDatabaseProvider {
    private static final EnumSet<VectorDatabaseProvider.Command> DATA_PLANE_COMMANDS = EnumSet.of(VectorDatabaseProvider.Command.QUERY, VectorDatabaseProvider.Command.GET, VectorDatabaseProvider.Command.UPSERT, VectorDatabaseProvider.Command.DELETE);

    @Override
    public <T> VectorDatabaseRequest<T> createRequestFor(VectorDatabaseProvider.Command command, String baseUrl, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments) {
        VectorDatabases.ProcedureArguments procedureArguments = (VectorDatabases.ProcedureArguments)additionalArguments.get("procedureArguments");
        Function<HttpRequest.Builder, HttpRequest.Builder> prep = httpRequestBuilder -> this.addAuthorizationHeader(configuration, (HttpRequest.Builder)httpRequestBuilder);
        if (command == VectorDatabaseProvider.Command.CREATE_COLLECTION) {
            return Pinecone.createCreateCollectionRequest(baseUrl, collection, prep, configuration, additionalArguments);
        }
        if (command == VectorDatabaseProvider.Command.GET_COLLECTION_METADATA) {
            return Pinecone.createGetCollectionMetadataRequest(baseUrl, collection, prep);
        }
        if (command == VectorDatabaseProvider.Command.GET) {
            return Pinecone.createGetRequest(baseUrl, prep, additionalArguments);
        }
        if (command == VectorDatabaseProvider.Command.QUERY) {
            return Pinecone.createQueryRequest(baseUrl, prep, additionalArguments, procedureArguments);
        }
        if (command == VectorDatabaseProvider.Command.DELETE_COLLECTION) {
            return Pinecone.createDeleteCollectionRequest(baseUrl, collection, prep);
        }
        if (command == VectorDatabaseProvider.Command.DELETE) {
            return Pinecone.createDeleteRequest(baseUrl, prep, additionalArguments);
        }
        if (command == VectorDatabaseProvider.Command.UPSERT) {
            return Pinecone.createCreateRequest(baseUrl, prep, additionalArguments);
        }
        throw new UnsupportedOperationException();
    }

    private static <T> VectorDatabaseRequest<T> createCreateCollectionRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> prep, Map<String, Object> configuration, Map<String, Object> additionalArguments) {
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = prep.andThen(httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of("name", collection, "dimension", additionalArguments.get("size"), "metric", ((String)additionalArguments.get("similarity")).toLowerCase(Locale.ROOT), "spec", configuration.getOrDefault("spec", Map.of())));
                return httpRequestBuilder.header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        return new VectorDatabaseRequest<Object>(URI.create(baseUrl + "/indexes"), requestCustomizer, in -> VectorDatabases.StatusDTO.ok(null));
    }

    @Override
    public HttpRequest.Builder addAuthorizationHeader(Map<String, Object> configuration, HttpRequest.Builder httpRequestBuilder) {
        Map headerConfig = RequestConfig.Keys.HEADERS.get(Map.class, configuration);
        if (headerConfig != null && headerConfig.containsKey(RequestConfig.Keys.AUTHORIZATION.key())) {
            httpRequestBuilder.header("Api-Key", (String)headerConfig.get(RequestConfig.Keys.AUTHORIZATION.key()));
        } else if (configuration.containsKey(RequestConfig.Keys.TOKEN.key())) {
            httpRequestBuilder = httpRequestBuilder.header("Api-Key", (String)configuration.get(RequestConfig.Keys.TOKEN.key()));
        }
        return httpRequestBuilder;
    }

    private static <T> VectorDatabaseRequest<T> createGetCollectionMetadataRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> prep) {
        Function<InputStream, VectorDatabases.InfoDTO> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(VectorDatabases.InfoDTO::of);
        return new VectorDatabaseRequest<VectorDatabases.InfoDTO>(URI.create(baseUrl + "/indexes/" + collection), prep.andThen(HttpRequest.Builder::build), responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createGetRequest(String baseUrl, Function<HttpRequest.Builder, HttpRequest.Builder> preparingRequestCustomizer, Map<String, Object> additionalArguments) {
        List ids = (List)additionalArguments.get("ids");
        URI target = URI.create(baseUrl + "/vectors/fetch?ids=" + ids.stream().map(Object::toString).collect(Collectors.joining("&ids=")));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = preparingRequestCustomizer.andThen(HttpRequest.Builder::GET).andThen(HttpRequest.Builder::build);
        RowMappingConfig rowMappingConfig = (RowMappingConfig)additionalArguments.get("rowMappingConfig");
        Function<InputStream, Object> responseTransformer = inputStream -> {
            try {
                Map result = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                Map vectors = (Map)result.get("vectors");
                return vectors.values().stream().map(vector -> {
                    HashMap row = new HashMap();
                    row.put(rowMappingConfig.idKey(), vector.get("id"));
                    row.put(rowMappingConfig.metadataKey(), vector.get("metadata"));
                    row.put(rowMappingConfig.vectorKey(), vector.get("values"));
                    return row;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, requestCustomizer, responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createQueryRequest(String baseUrl, Function<HttpRequest.Builder, HttpRequest.Builder> preparingRequestCustomizer, Map<String, Object> additionalArguments, VectorDatabases.ProcedureArguments procedureArguments) {
        RowMappingConfig rowMappingConfig = (RowMappingConfig)additionalArguments.get("rowMappingConfig");
        List vector = (List)additionalArguments.get("vector");
        long limit = (Long)additionalArguments.get("limit");
        HashMap<String, Object> body = new HashMap<String, Object>();
        body.put("includeMetadata", true);
        body.put("vector", vector);
        body.put("topK", limit);
        body.put("includeValues", procedureArguments.hasVector());
        ((Optional)additionalArguments.get("filter")).ifPresent(filter -> body.put("filter", filter));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = preparingRequestCustomizer.andThen(httpRequestBuilder -> {
            httpRequestBuilder.header("Content-Type", "application/json");
            try {
                httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(JsonUtils.getObjectMapper().writeValueAsString((Object)body)));
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            return httpRequestBuilder.build();
        });
        Function<InputStream, Object> responseTransformer = inputStream -> {
            try {
                Map result = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                List data = (List)result.get("matches");
                return data.stream().map(i -> {
                    HashMap row = new HashMap();
                    row.put(rowMappingConfig.metadataKey(), i.get("metadata"));
                    row.put(rowMappingConfig.scoreKey(), i.get("score"));
                    row.put(rowMappingConfig.idKey(), i.get("id"));
                    row.put(rowMappingConfig.vectorKey(), i.get("values"));
                    return row;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(URI.create(baseUrl + "/query"), requestCustomizer, responseTransformer);
    }

    @Override
    public Optional<VectorDatabaseRequest<String>> getCollectionSpecificHost(VectorDatabaseProvider.Command command, String defaultHost, String collection, Map<String, Object> configuration) {
        if (DATA_PLANE_COMMANDS.contains((Object)command)) {
            Function<HttpRequest.Builder, HttpRequest.Builder> prep = httpRequestBuilder -> this.addAuthorizationHeader(configuration, (HttpRequest.Builder)httpRequestBuilder);
            Function<InputStream, String> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(m -> "https://" + String.valueOf(m.get("host")));
            return Optional.of(new VectorDatabaseRequest<String>(URI.create(defaultHost + "/indexes/" + collection), prep.andThen(HttpRequest.Builder::build), responseTransformer));
        }
        return VectorDatabaseProvider.super.getCollectionSpecificHost(command, defaultHost, collection, configuration);
    }

    private static <T> VectorDatabaseRequest<T> createCreateRequest(String baseUrl, Function<HttpRequest.Builder, HttpRequest.Builder> prep, Map<String, Object> additionalArguments) {
        Set<String> predefinedProperties = Set.of("id", "vector", "metadata");
        URI target = URI.create(baseUrl + "/vectors/upsert");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = prep.andThen(httpRequestBuilder -> {
            try {
                ArrayList vectors = new ArrayList();
                for (Map vector : (List)additionalArguments.get("vectors")) {
                    HashMap hlp = new HashMap();
                    hlp.put("id", vector.get("id"));
                    hlp.put("metadata", vector.get("metadata"));
                    hlp.put("values", vector.get("vector"));
                    vector.forEach((k, v) -> {
                        if (predefinedProperties.contains(k)) {
                            hlp.put((String)k, v);
                        }
                    });
                    vectors.add(hlp);
                }
                return httpRequestBuilder.header("Content-Type", "application/json").POST(HttpRequest.BodyPublishers.ofString(JsonUtils.getObjectMapper().writeValueAsString(Map.of("vectors", vectors)))).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        });
        return new VectorDatabaseRequest<Object>(target, requestCustomizer, in -> VectorDatabases.StatusDTO.ok(null));
    }

    private static <T> VectorDatabaseRequest<T> createDeleteCollectionRequest(String baseUrl, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> prep) {
        return new VectorDatabaseRequest<Object>(URI.create(baseUrl + "/indexes/" + collection), prep.andThen(HttpRequest.Builder::DELETE).andThen(HttpRequest.Builder::build), in -> VectorDatabases.StatusDTO.ok(null));
    }

    private static <T> VectorDatabaseRequest<T> createDeleteRequest(String baseUrl, Function<HttpRequest.Builder, HttpRequest.Builder> prep, Map<String, Object> additionalArguments) {
        String body;
        try {
            body = JsonUtils.getObjectMapper().writeValueAsString(Map.of("ids", additionalArguments.get("ids")));
        }
        catch (JsonProcessingException e) {
            throw new GenAIProcedureException("Failed to create body for batch deletion of vectors");
        }
        return new VectorDatabaseRequest<Object>(URI.create(baseUrl + "/vectors/delete"), prep.andThen(b -> b.POST(HttpRequest.BodyPublishers.ofString(body))).andThen(HttpRequest.Builder::build), in -> VectorDatabases.StatusDTO.ok(null));
    }
}

