/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.dbs.providers;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.net.http.HttpRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Stream;
import org.neo4j.genai.dbs.RequestConfig;
import org.neo4j.genai.dbs.RowMappingConfig;
import org.neo4j.genai.dbs.VectorDatabaseProvider;
import org.neo4j.genai.dbs.VectorDatabaseRequest;
import org.neo4j.genai.dbs.VectorDatabases;
import org.neo4j.genai.util.GenAIProcedureException;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;

public final class Qdrant
implements VectorDatabaseProvider {
    private static final BiFunction<String, String, String> CREATE_COLLECTION_BASE_URI = (host, collection) -> host + "/collections/" + collection;
    private static final BiFunction<String, String, String> CREATE_POINTS_BASE_URI = (host, collection) -> CREATE_COLLECTION_BASE_URI.apply((String)host, (String)collection) + "/points";
    private static final String POINTS_KEY = "points";
    private static final String IDS_KEY = "ids";

    @Override
    public <T> VectorDatabaseRequest<T> createRequestFor(VectorDatabaseProvider.Command command, String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments) {
        RowMappingConfig rowMappingConfig = (RowMappingConfig)additionalArguments.get("rowMappingConfig");
        VectorDatabases.ProcedureArguments procedureArguments = (VectorDatabases.ProcedureArguments)additionalArguments.get("procedureArguments");
        Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder = httpRequestBuilder -> this.addAuthorizationHeader(configuration, (HttpRequest.Builder)httpRequestBuilder);
        if (command == VectorDatabaseProvider.Command.GET_COLLECTION_METADATA) {
            return Qdrant.createGetCollectionMetadataRequest(host, collection, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.GET) {
            return Qdrant.createGetRequest(host, collection, additionalArguments, procedureArguments, rowMappingConfig, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.DELETE_COLLECTION) {
            return Qdrant.createDeleteCollectionRequest(host, collection, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.CREATE_COLLECTION) {
            return Qdrant.createCreateCollectionRequest(host, collection, additionalArguments, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.UPSERT) {
            return Qdrant.createUpsertRequest(host, collection, configuration, additionalArguments, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.QUERY) {
            return Qdrant.createQueryRequest(host, collection, additionalArguments, procedureArguments, rowMappingConfig, commonRequestBuilder);
        }
        if (command == VectorDatabaseProvider.Command.DELETE) {
            return Qdrant.createDeleteRequest(host, collection, configuration, additionalArguments, commonRequestBuilder);
        }
        throw new UnsupportedOperationException();
    }

    private static <T> VectorDatabaseRequest<T> createDeleteRequest(String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create(CREATE_POINTS_BASE_URI.apply(host, collection) + "/delete?wait=" + String.valueOf(RequestConfig.Keys.WAIT.get(Boolean.class, configuration)));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of(POINTS_KEY, additionalArguments.get(IDS_KEY)));
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        Function<InputStream, VectorDatabases.StatusDTO> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(response -> {
            Map result = (Map)response.get("result");
            String status = (String)response.get("status");
            if (!"ok".equals(status)) {
                return VectorDatabases.StatusDTO.failure(result);
            }
            return VectorDatabases.StatusDTO.ok(result);
        });
        return new VectorDatabaseRequest<VectorDatabases.StatusDTO>(target, commonRequestBuilder.andThen(requestCustomizer), responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createQueryRequest(String host, String collection, Map<String, Object> additionalArguments, VectorDatabases.ProcedureArguments procedureArguments, RowMappingConfig rowMappingConfig, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create(CREATE_POINTS_BASE_URI.apply(host, collection) + "/search");
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                HashMap<String, Boolean> requestParameters = new HashMap<String, Boolean>(Map.of("vector", additionalArguments.get("vector"), "limit", additionalArguments.get("limit"), "with_payload", true, "with_vector", procedureArguments.allResults()));
                if (((Optional)additionalArguments.get("filter")).isPresent()) {
                    requestParameters.put("filter", (Boolean)((Optional)additionalArguments.get("filter")).get());
                }
                String body = JsonUtils.getObjectMapper().writeValueAsString(requestParameters);
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        Function<InputStream, Object> responseTransformer = inputStream -> {
            try {
                Map result = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                List data = (List)result.get("result");
                return data.stream().map(i -> {
                    HashMap row = new HashMap();
                    row.put(rowMappingConfig.metadataKey(), i.get("payload"));
                    row.put(rowMappingConfig.scoreKey(), i.get("score"));
                    row.put(rowMappingConfig.idKey(), i.get("id"));
                    row.put(rowMappingConfig.vectorKey(), i.get("vector"));
                    return row;
                });
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createUpsertRequest(String host, String collection, Map<String, Object> configuration, Map<String, Object> additionalArguments, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create(CREATE_POINTS_BASE_URI.apply(host, collection) + "?wait=" + String.valueOf(RequestConfig.Keys.WAIT.get(Boolean.class, configuration)));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                ArrayList points = new ArrayList();
                for (Map vector : (List)additionalArguments.get("vectors")) {
                    HashMap point = new HashMap(3);
                    point.put("id", vector.get("id"));
                    point.put("payload", vector.get("metadata"));
                    point.put("vector", vector.get("vector"));
                    points.add(point);
                }
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of(POINTS_KEY, points));
                return httpRequestBuilder.PUT(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), in -> VectorDatabases.StatusDTO.ok(null));
    }

    private static <T> VectorDatabaseRequest<T> createCreateCollectionRequest(String host, String collection, Map<String, Object> additionalArguments, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create(CREATE_COLLECTION_BASE_URI.apply(host, collection));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of("vectors", Map.of("size", additionalArguments.get("size"), "distance", additionalArguments.get("similarity"))));
                return httpRequestBuilder.PUT(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Object>(target, commonRequestBuilder.andThen(requestCustomizer), in -> VectorDatabases.StatusDTO.ok(null));
    }

    private static <T> VectorDatabaseRequest<T> createDeleteCollectionRequest(String host, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create(CREATE_COLLECTION_BASE_URI.apply(host, collection));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> httpRequestBuilder.DELETE().build();
        Function<InputStream, VectorDatabases.StatusDTO> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(qdrantStatus -> {
            if (!"ok".equalsIgnoreCase(qdrantStatus.getOrDefault("status", "ok"))) {
                return VectorDatabases.StatusDTO.unknown(null);
            }
            return VectorDatabases.StatusDTO.ok(null);
        });
        return new VectorDatabaseRequest<VectorDatabases.StatusDTO>(target, commonRequestBuilder.andThen(requestCustomizer), responseTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createGetRequest(String host, String collection, Map<String, Object> additionalArguments, VectorDatabases.ProcedureArguments procedureArguments, RowMappingConfig rowMappingConfig, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create(CREATE_POINTS_BASE_URI.apply(host, collection));
        Function<HttpRequest.Builder, HttpRequest> requestCustomizer = httpRequestBuilder -> {
            try {
                String body = JsonUtils.getObjectMapper().writeValueAsString(Map.of(IDS_KEY, additionalArguments.get(IDS_KEY), "with_vector", procedureArguments.allResults(), "with_payload", true));
                return httpRequestBuilder.POST(HttpRequest.BodyPublishers.ofString(body)).build();
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
        };
        Result result = new Result(target, commonRequestBuilder.andThen(requestCustomizer));
        Function<InputStream, Stream> resultTransformer = inputStream -> {
            try {
                Map map = (Map)JsonUtils.getObjectMapper().readValue(inputStream, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                List resultList = (List)map.get("result");
                return resultList.stream().map(resultEntry -> {
                    HashMap row = new HashMap();
                    resultEntry.forEach((k, v) -> {
                        if ("payload".equals(k)) {
                            row.put(rowMappingConfig.metadataKey(), v);
                        } else if (!"id".equals(k) || procedureArguments.allResults()) {
                            row.put(k, v);
                        }
                    });
                    return row;
                });
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        };
        return new VectorDatabaseRequest<Stream>(result.target(), result.requestCustomizer(), resultTransformer);
    }

    private static <T> VectorDatabaseRequest<T> createGetCollectionMetadataRequest(String host, String collection, Function<HttpRequest.Builder, HttpRequest.Builder> commonRequestBuilder) {
        URI target = URI.create(CREATE_COLLECTION_BASE_URI.apply(host, collection));
        Function<InputStream, VectorDatabases.InfoDTO> responseTransformer = HttpService.DEFAULT_RESPONSE_TO_MAP_TRANSFORMER.andThen(response -> VectorDatabases.InfoDTO.of((Map)response.get("result")));
        return new VectorDatabaseRequest<VectorDatabases.InfoDTO>(target, commonRequestBuilder.andThen(HttpRequest.Builder::build), responseTransformer);
    }

    @Override
    public BiFunction<Integer, String, Optional<GenAIProcedureException>> getProviderSpecificStatusHandler(String collection) {
        return (statusCode, message) -> {
            if (statusCode == 400) {
                try {
                    Map m;
                    Map response = (Map)JsonUtils.getObjectMapper().readValue(message, JsonUtils.TYPE_REF_MAP_STRING_OBJECT);
                    Object status = response.get("status");
                    if (status instanceof Map && (m = (Map)status).containsKey("error")) {
                        return Optional.of(new GenAIProcedureException((String)m.get("error")));
                    }
                }
                catch (JsonProcessingException e) {
                    throw new RuntimeException(e);
                }
                return Optional.of(new GenAIProcedureException((String)message));
            }
            return Optional.empty();
        };
    }

    private record Result(URI target, Function<HttpRequest.Builder, HttpRequest> requestCustomizer) {
    }
}

