/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.util.aws;

import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.util.VisibleForTesting;

public class URLUtils {
    private static final Pattern QUERY_SEPARATOR = Pattern.compile("&");
    private static final Pattern QUERY_PARAM_VALUE_SEPARATOR = Pattern.compile("=");

    private URLUtils() {
    }

    private static String reencodedPathFrom(URI uri) {
        String path = uri.normalize().getPath();
        return path != null && !path.isEmpty() ? URLEncoder.encodePath(path) : "/";
    }

    private static String reencodedQueryFrom(URI uri) {
        String rawQuery = uri.getRawQuery();
        if (rawQuery == null || rawQuery.isEmpty()) {
            return "";
        }
        TreeMap<String, List> queries = new TreeMap<String, List>(String.CASE_INSENSITIVE_ORDER);
        for (String query : QUERY_SEPARATOR.split(rawQuery)) {
            String[] pv = QUERY_PARAM_VALUE_SEPARATOR.split(query);
            String param = pv[0];
            String value = pv.length > 1 ? pv[1] : "";
            queries.computeIfAbsent(URLUtils.reencode(param), k -> new ArrayList()).add(URLUtils.reencode(value));
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry entry : queries.entrySet()) {
            String param = (String)entry.getKey();
            List values = (List)entry.getValue();
            Collections.sort(values);
            for (String value : values) {
                if (first) {
                    first = false;
                } else {
                    sb.append(QUERY_SEPARATOR);
                }
                sb.append(param).append(QUERY_PARAM_VALUE_SEPARATOR).append(value);
            }
        }
        return sb.toString();
    }

    static String reencode(String param) {
        return URLEncoder.encode(URLDecoder.decode(param));
    }

    static class URLEncoder {
        private static final Pattern ENCODED_CHARACTERS = Pattern.compile(Stream.of("+", "*", "%7E", "%2F").map(Pattern::quote).collect(Collectors.joining("|")));

        private URLEncoder() {
        }

        static String encode(String value) {
            return URLEncoder.encode(value, false);
        }

        static String encodePath(String value) {
            return URLEncoder.encode(value, true);
        }

        private static String encode(String value, boolean path) {
            if (value == null) {
                return null;
            }
            if (value.isEmpty()) {
                return "";
            }
            String encoded = java.net.URLEncoder.encode(value, StandardCharsets.UTF_8);
            Matcher matcher = ENCODED_CHARACTERS.matcher(encoded);
            StringBuilder sb = new StringBuilder(value.length());
            while (matcher.find()) {
                matcher.appendReplacement(sb, URLEncoder.replacement(matcher, path));
            }
            matcher.appendTail(sb);
            return sb.toString();
        }

        private static String replacement(Matcher matcher, boolean path) {
            String match;
            return switch (match = matcher.group()) {
                case "+" -> "%20";
                case "*" -> "%2A";
                case "%7E" -> "~";
                case "%2F" -> {
                    if (path) {
                        yield "/";
                    }
                    yield "%2F";
                }
                default -> throw new IllegalStateException("Unexpected value: '%s'".formatted(match));
            };
        }
    }

    @VisibleForTesting
    static class URLDecoder {
        private URLDecoder() {
        }

        static String decode(String value) {
            if (value == null) {
                return null;
            }
            if (value.isEmpty()) {
                return "";
            }
            return java.net.URLDecoder.decode(value, StandardCharsets.UTF_8);
        }
    }

    record CanonicalURIComponents(String scheme, String userInfo, String host, int port, String path, String query, String fragment) {
        CanonicalURIComponents(URI uri) {
            this(uri.getScheme(), URLEncoder.encode(uri.getUserInfo()), uri.getHost(), uri.getPort(), URLUtils.reencodedPathFrom(uri), URLUtils.reencodedQueryFrom(uri), URLEncoder.encode(uri.getFragment()));
        }
    }
}

