/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.genai.vector.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.text.StringSubstitutor;
import org.eclipse.collections.api.factory.Maps;
import org.eclipse.collections.api.list.MutableList;
import org.eclipse.collections.api.map.MutableMap;
import org.eclipse.collections.impl.list.mutable.ListAdapter;
import org.neo4j.genai.util.HttpService;
import org.neo4j.genai.util.JsonUtils;
import org.neo4j.genai.util.MalformedGenAIResponseException;
import org.neo4j.genai.vector.VectorEncoding;

public final class VertexAI
implements VectorEncoding.Provider<Parameters> {
    public static final String NAME = "VertexAI";
    private static final String ENDPOINT_TEMPLATE = "https://${region}-aiplatform.googleapis.com/v1/projects/${projectId}/locations/${region}/publishers/google/models/${model}:predict";
    static final String DEFAULT_REGION = "us-central1";
    static final Set<String> SUPPORTED_REGIONS = Set.of("africa-south1", "asia-east1", "asia-east2", "asia-northeast1", "asia-northeast2", "asia-northeast3", "asia-south1", "asia-southeast1", "asia-southeast2", "australia-southeast1", "australia-southeast2", "europe-central2", "europe-north1", "europe-southwest1", "europe-west1", "europe-west2", "europe-west3", "europe-west4", "europe-west6", "europe-west8", "europe-west9", "europe-west12", "me-central1", "me-central2", "me-west1", "northamerica-northeast1", "northamerica-northeast2", "southamerica-east1", "southamerica-west1", "us-central1", "us-east1", "us-east4", "us-south1", "us-west1", "us-west2", "us-west3", "us-west4", "us-east5");
    private static final String STRINGIFIED_SUPPORTED_REGIONS = SUPPORTED_REGIONS.stream().map(s -> "'" + s + "'").collect(Collectors.joining(", ", "[", "]"));
    static final Set<String> KNOWN_BATCH_SUPPORTED_MODELS = Set.of("text-embedding-005", "text-multilingual-embedding-002");
    static final String DEFAULT_BUT_RETIRED_MODEL = "textembedding-gecko@001";

    @Override
    public Class<Parameters> parameterDeclarations() {
        return Parameters.class;
    }

    @Override
    public String name() {
        return NAME;
    }

    @Override
    public VectorEncoding.Provider.Encoder configure(Parameters configuration) {
        if (configuration.model.equals(DEFAULT_BUT_RETIRED_MODEL)) {
            throw new IllegalArgumentException("Provided (default) model '%s' has been deprecated by VertexAI.".formatted(DEFAULT_BUT_RETIRED_MODEL));
        }
        if (!SUPPORTED_REGIONS.contains(configuration.region)) {
            throw new IllegalArgumentException("Provided region '%s' is not supported. Supported regions: %s".formatted(configuration.region, STRINGIFIED_SUPPORTED_REGIONS));
        }
        URI endpoint = URI.create(StringSubstitutor.replace((Object)ENDPOINT_TEMPLATE, Map.of("region", configuration.region, "projectId", configuration.projectId, "model", configuration.model)));
        if (KNOWN_BATCH_SUPPORTED_MODELS.contains(configuration.model)) {
            return new BatchEncoder(endpoint, configuration);
        }
        return new SingleEncoder(endpoint, configuration);
    }

    public static class Parameters {
        public String token;
        public String projectId;
        public String model = "textembedding-gecko@001";
        public String region = "us-central1";
        public Optional<String> taskType;
        public Optional<String> title;
        public Optional<Boolean> autoTruncate;
        public OptionalLong dimensions;
    }

    private static class BatchEncoder
    extends SingleEncoder {
        private BatchEncoder(URI endpoint, Parameters configuration) {
            super(endpoint, configuration);
        }

        @Override
        public Stream<VectorEncoding.BatchRow> encode(HttpService httpService, List<String> resources, int[] nullIndexes) {
            return this.encodeInternal(httpService, resources, nullIndexes);
        }
    }

    private static class SingleEncoder
    extends Encoder {
        private SingleEncoder(URI endpoint, Parameters configuration) {
            super(endpoint, configuration);
        }

        @Override
        public float[] encode(HttpService httpService, String resource) {
            return this.encodeInternal(httpService, List.of(resource), ArrayUtils.EMPTY_INT_ARRAY).findFirst().orElseThrow().vector();
        }
    }

    static abstract class Encoder
    implements VectorEncoding.Provider.Encoder {
        private final URI endpoint;
        private final Parameters configuration;
        private final Map<String, ?> parameters;

        protected Encoder(URI endpoint, Parameters configuration) {
            this.endpoint = endpoint;
            this.configuration = configuration;
            this.parameters = this.parameters();
        }

        protected Stream<VectorEncoding.BatchRow> encodeInternal(HttpService httpService, List<String> resources, int[] nullIndexes) {
            return httpService.request(this.endpoint, builder -> builder.headers("Authorization", "Bearer " + this.configuration.token, "Content-Type", "application/json; charset=" + String.valueOf(StandardCharsets.UTF_8), "Accept", "application/json").POST(HttpService.pipe(outputStream -> this.writeRequestPayload((OutputStream)outputStream, resources))).build(), inputStream -> Encoder.parseResponse(resources, inputStream, nullIndexes));
        }

        static Stream<VectorEncoding.BatchRow> parseResponse(List<String> resources, InputStream inputStream, int[] nullIndexes) throws MalformedGenAIResponseException {
            String[] properties = new String[]{"embeddings", "values"};
            return JsonUtils.parseResponse(VertexAI.NAME, "predictions", properties, resources, inputStream, nullIndexes);
        }

        private Object buildPayload(List<String> resources) {
            MutableList instances = ListAdapter.adapt(resources).collect(this::instance);
            return Maps.mutable.of((Object)"instances", (Object)instances, (Object)"parameters", this.parameters);
        }

        private Map<String, ?> instance(String resource) {
            MutableMap instance = Maps.mutable.of((Object)"content", (Object)resource);
            this.configuration.title.ifPresent(arg_0 -> Encoder.lambda$instance$3((Map)instance, arg_0));
            this.configuration.taskType.ifPresent(arg_0 -> Encoder.lambda$instance$4((Map)instance, arg_0));
            return instance;
        }

        private Map<String, ?> parameters() {
            MutableMap parameters = Maps.mutable.empty();
            this.configuration.autoTruncate.ifPresent(arg_0 -> Encoder.lambda$parameters$5((Map)parameters, arg_0));
            this.configuration.dimensions.ifPresent(arg_0 -> Encoder.lambda$parameters$6((Map)parameters, arg_0));
            return parameters;
        }

        private void writeRequestPayload(OutputStream out, List<String> resources) {
            try {
                JsonUtils.getObjectMapper().writeValue(out, this.buildPayload(resources));
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }

        private static /* synthetic */ void lambda$parameters$6(Map parameters, long dimensions) {
            parameters.put("outputDimensionality", dimensions);
        }

        private static /* synthetic */ void lambda$parameters$5(Map parameters, Boolean autoTruncate) {
            parameters.put("autoTruncate", autoTruncate);
        }

        private static /* synthetic */ void lambda$instance$4(Map instance, String taskType) {
            instance.put("task_type", taskType);
        }

        private static /* synthetic */ void lambda$instance$3(Map instance, String title) {
            instance.put("title", title);
        }
    }
}

