/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.connectors;

import java.nio.file.Path;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Duration;
import java.util.Objects;
import java.util.Set;
import org.neo4j.annotations.api.PublicApi;
import org.neo4j.configuration.Description;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingConstraints;
import org.neo4j.configuration.SettingImpl;
import org.neo4j.configuration.SettingValueParser;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.configuration.SettingsDeclaration;
import org.neo4j.configuration.connectors.ConnectorDefaults;
import org.neo4j.configuration.helpers.SocketAddress;
import org.neo4j.graphdb.config.Setting;

@PublicApi
public final class BoltConnector
implements SettingsDeclaration {
    public static final int DEFAULT_PORT = 7687;
    public static final String NAME = "bolt";
    public static final String INTERNAL_NAME = "bolt-internal";
    private static final SettingValueParser<FilePermission> FILE_PERMISSIONS = new SettingValueParser<FilePermission>(){

        @Override
        public FilePermission parse(String value) {
            try {
                return new FilePermission(value);
            }
            catch (IllegalArgumentException e) {
                throw new IllegalArgumentException(String.format("'%s' is not a valid file permission value", value), e);
            }
        }

        @Override
        public Class<FilePermission> getType() {
            return FilePermission.class;
        }

        @Override
        public String getDescription() {
            return "a set of file permissions";
        }
    };
    @Description(value="Enable the Bolt connector.")
    public static final Setting<Boolean> enabled = ConnectorDefaults.bolt_enabled;
    @Description(value="Enable the collection of driver telemetry.")
    public static final Setting<Boolean> server_bolt_telemetry_enabled = SettingImpl.newBuilder("server.bolt.telemetry.enabled", SettingValueParsers.BOOL, false).build();
    @Description(value="The encryption level to be used to secure communications with this connector.")
    public static final Setting<EncryptionLevel> encryption_level = SettingImpl.newBuilder("server.bolt.tls_level", SettingValueParsers.ofEnum(EncryptionLevel.class), EncryptionLevel.DISABLED).build();
    @Description(value="Address the connector should bind to.")
    public static final Setting<SocketAddress> listen_address = SettingImpl.newBuilder("server.bolt.listen_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7687)).setDependency(GraphDatabaseSettings.default_listen_address).build();
    @Description(value="Additional addresses the connector should bind to.")
    public static final Setting<Set<SocketAddress>> additional_listen_addresses = SettingImpl.newBuilder("server.bolt.additional_listen_addresses", SettingValueParsers.setOf(SettingValueParsers.SOCKET_ADDRESS), Set.of()).build();
    @Description(value="Advertised address for this connector.")
    public static final Setting<SocketAddress> advertised_address = SettingImpl.newBuilder("server.bolt.advertised_address", SettingValueParsers.SOCKET_ADDRESS, new SocketAddress(7687)).addConstraint(SettingConstraints.NO_ALL_INTERFACES_ADDRESS).setDependency(GraphDatabaseSettings.default_advertised_address).build();
    @Description(value="The type of messages to enable keep-alive messages for `ALL`, `STREAMING`, or `OFF`.")
    public static final Setting<KeepAliveRequestType> connection_keep_alive_type = SettingImpl.newBuilder("server.bolt.connection_keep_alive_for_requests", SettingValueParsers.ofEnum(KeepAliveRequestType.class), KeepAliveRequestType.ALL).build();
    @Description(value="The maximum time to wait before sending a NOOP on connections waiting for responses from active ongoing queries. The minimum value is 1 millisecond.")
    public static final Setting<Duration> connection_keep_alive = SettingImpl.newBuilder("server.bolt.connection_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).addConstraint(SettingConstraints.min(Duration.ofMillis(1L))).build();
    @Description(value="The interval between every scheduled keep-alive check on all connections with active queries. Zero duration turns off keep-alive service.")
    public static final Setting<Duration> connection_keep_alive_streaming_scheduling_interval = SettingImpl.newBuilder("server.bolt.connection_keep_alive_streaming_scheduling_interval", SettingValueParsers.DURATION, Duration.ofMinutes(1L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(0L))).build();
    @Description(value="The total number of probes to be missed before a connection is considered stale. The minimum value is 1.")
    public static final Setting<Integer> connection_keep_alive_probes = SettingImpl.newBuilder("server.bolt.connection_keep_alive_probes", SettingValueParsers.INT, 2).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="The number of threads, including idle, to keep in the thread pool bound to this connector.")
    public static final Setting<Integer> thread_pool_min_size = SettingImpl.newBuilder("server.bolt.thread_pool_min_size", SettingValueParsers.INT, 5).build();
    @Description(value="The maximum number of threads allowed in the thread pool bound to this connector.")
    public static final Setting<Integer> thread_pool_max_size = SettingImpl.newBuilder("server.bolt.thread_pool_max_size", SettingValueParsers.INT, 400).build();
    @Description(value="The maximum time an idle thread in the thread pool bound to this connector waits for new tasks.")
    public static final Setting<Duration> thread_pool_keep_alive = SettingImpl.newBuilder("server.bolt.thread_pool_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).build();
    @Description(value="Enables accounting-based reporting of benign errors within the Bolt stack. When enabled, benign errors are reported only when such events occur with unusual frequency. When disabled, all benign network errors are reported.")
    public static final Setting<Boolean> enable_error_accounting = SettingImpl.newBuilder("server.bolt.enable_network_error_accounting", SettingValueParsers.BOOL, true).build();
    @Description(value="The maximum number of network-related connection aborts allowed within a specified time window before emitting log messages. A value of zero reverts to legacy warning behavior.")
    public static final Setting<Long> network_abort_warn_threshold = SettingImpl.newBuilder("server.bolt.network_abort_warn_threshold", SettingValueParsers.LONG, 2L).addConstraint(SettingConstraints.min(0L)).build();
    @Description(value="The duration of the window in which network-related connection aborts are sampled.")
    public static final Setting<Duration> network_abort_warn_window_duration = SettingImpl.newBuilder("server.bolt.network_abort_warn_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="The duration for which network-related connection aborts need to remain at a reasonable level before the error is cleared.")
    public static final Setting<Duration> network_abort_clear_window_duration = SettingImpl.newBuilder("server.bolt.network_abort_clear_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="The maximum number of unscheduled requests allowed during thread starvation events within a specified time window before emitting log messages. A value of zero reverts to legacy error behavior.")
    public static final Setting<Long> thread_starvation_warn_threshold = SettingImpl.newBuilder("server.bolt.thread_starvation_warn_threshold", SettingValueParsers.LONG, 2L).addConstraint(SettingConstraints.min(0L)).build();
    @Description(value="The duration of the window in which unscheduled requests are sampled.")
    public static final Setting<Duration> thread_starvation_warn_window_duration = SettingImpl.newBuilder("server.bolt.thread_starvation_warn_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="The duration for which unscheduled requests need to remain at a reasonable level before the error is cleared.")
    public static final Setting<Duration> thread_starvation_clear_window_duration = SettingImpl.newBuilder("server.bolt.thread_starvation_clear_window_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofSeconds(1L))).build();
    @Description(value="Amount of time spent between samples of current traffic usage. Lower values result in more accurate reporting while incurring a higher performance penalty. A value of zero disables traffic accounting.")
    public static final Setting<Duration> traffic_accounting_check_period = SettingImpl.newBuilder("server.bolt.traffic_accounting_check_period", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).addConstraint(SettingConstraints.any(SettingConstraints.is(Duration.ZERO), SettingConstraints.min(Duration.ofMinutes(1L)))).build();
    @Description(value="Time to be spent below the configured traffic threshold to clear traffic warnings.")
    public static final Setting<Duration> traffic_accounting_clear_duration = SettingImpl.newBuilder("server.bolt.traffic_accounting_clear_duration", SettingValueParsers.DURATION, Duration.ofMinutes(10L)).addConstraint(SettingConstraints.min(Duration.ofMinutes(1L))).build();
    @Description(value="Maximum permitted incoming traffic within a configured accounting check window before emitting a warning (in Mbps).")
    public static final Setting<Long> traffic_accounting_incoming_threshold_mbps = SettingImpl.newBuilder("server.bolt.traffic_accounting_incoming_threshold_mbps", SettingValueParsers.LONG, 950L).addConstraint(SettingConstraints.min(1L)).build();
    @Description(value="Maximum permitted outgoing traffic within a configured accounting check window before emitting a warning (in Mbps).")
    public static final Setting<Long> traffic_accounting_outgoing_threshold_mbps = SettingImpl.newBuilder("server.bolt.traffic_accounting_outgoing_threshold_mbps", SettingValueParsers.LONG, 950L).addConstraint(SettingConstraints.min(1L)).build();
    @Description(value="Enable or disable the Bolt Unix Domain Socket connector.Requests submitted via this connector will be placed within a dedicated thread pool which is isolated from all other Bolt connections.")
    public static final Setting<Boolean> enable_unix_socket = SettingImpl.newBuilder("server.bolt.unix_socket_enabled", SettingValueParsers.BOOL, false).build();
    @Description(value="The absolute path of the file for use with the Unix Domain Socket interface. This file must be specified and will be created at runtime and deleted on shutdown.")
    public static final Setting<Path> unix_socket_path = SettingImpl.newBuilder("server.bolt.unix_socket_path", SettingValueParsers.PATH, null).build();
    @Description(value="Enable or disable authentication via the Bolt Unix Domain Socket connector. If disabled, connected clients gain all permissions so long as they are able to access the Unix Domain Socket file.")
    public static final Setting<Boolean> enable_unix_socket_auth = SettingImpl.newBuilder("server.bolt.unix_socket_auth", SettingValueParsers.BOOL, true).build();
    @Description(value="Sets the default permission mask applied to the Unix Domain Socket file. This mask should be set as restrictive as possible (especially when authentication is disabled on this connector).Note, however, that this permission may not be honored by Posix systems other than Linux.")
    public static final Setting<FilePermission> unix_socket_permission_mask = SettingImpl.newBuilder("server.bolt.unix_socket_permission_mask", FILE_PERMISSIONS, new FilePermission(PosixFilePermission.OWNER_READ, PosixFilePermission.OWNER_WRITE, PosixFilePermission.OWNER_EXECUTE, PosixFilePermission.GROUP_EXECUTE, PosixFilePermission.OTHERS_EXECUTE)).build();
    @Description(value="Whether or not to delete an existing file for use with the Unix Domain Socket based interface. This improves the handling of the case where a previous hard shutdown was unable to delete the file.")
    public static final Setting<Boolean> unix_socket_delete = SettingImpl.newBuilder("server.bolt.unix_socket_delete", SettingValueParsers.BOOL, false).build();
    @Description(value="Whether or not to allocate a dedicated thread pool for use with the Unix Domain Socket based interface. This permits the use of the Unix Domain Socket connector as an emergency access connector when the server is over capacity.")
    public static final Setting<Boolean> unix_socket_use_dedicated_thread_pool = SettingImpl.newBuilder("server.bolt.unix_socket_use_dedicated_thread_pool", SettingValueParsers.BOOL, true).build();
    @Description(value="The number of threads, including idle, to keep in the thread pool bound to the Unix Domain Socket connector.")
    public static final Setting<Integer> unix_socket_dedicated_thread_pool_min_size = SettingImpl.newBuilder("server.bolt.unix_socket_thread_pool_min_size", SettingValueParsers.INT, 0).addConstraint(SettingConstraints.min(0)).build();
    @Description(value="The maximum number of threads allowed in the thread pool bound to the Unix Domain Socket connector.")
    public static final Setting<Integer> unix_socket_dedicated_thread_pool_max_size = SettingImpl.newBuilder("server.bolt.unix_socket_thread_pool_max_size", SettingValueParsers.INT, 20).addConstraint(SettingConstraints.min(1)).build();
    @Description(value="The maximum time an idle thread in the thread pool bound to the Unix Domain Socket connector waits for new tasks.")
    public static final Setting<Duration> unix_socket_dedicated_thread_pool_keep_alive = SettingImpl.newBuilder("server.bolt.unix_socket_thread_pool_keep_alive", SettingValueParsers.DURATION, Duration.ofMinutes(5L)).build();

    public static enum EncryptionLevel {
        REQUIRED,
        OPTIONAL,
        DISABLED;

    }

    public static enum KeepAliveRequestType {
        ALL,
        STREAMING,
        OFF;

    }

    public static class FilePermission {
        private final Set<PosixFilePermission> posixPermissions;

        public FilePermission(Set<PosixFilePermission> permissions) {
            this.posixPermissions = permissions;
        }

        public FilePermission(PosixFilePermission ... permissions) {
            this(Set.of(permissions));
        }

        public FilePermission(String mask) {
            this(PosixFilePermissions.fromString(mask));
        }

        public Set<PosixFilePermission> getPosixPermissions() {
            return this.posixPermissions;
        }

        public String toString() {
            return PosixFilePermissions.toString(this.posixPermissions);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof FilePermission)) {
                return false;
            }
            FilePermission that = (FilePermission)o;
            return Objects.equals(this.posixPermissions, that.posixPermissions);
        }

        public int hashCode() {
            return Objects.hashCode(this.posixPermissions);
        }
    }
}

