/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.configuration.helpers;

import java.util.Arrays;
import java.util.List;
import org.neo4j.configuration.GraphDatabaseSettings;

public class CypherVersionClassification {
    public static boolean isExperimental(GraphDatabaseSettings.CypherVersion version) {
        switch (version) {
            default: {
                throw new MatchException(null, null);
            }
            case Cypher5: 
            case Cypher25: 
        }
        return false;
    }

    public static List<GraphDatabaseSettings.CypherVersion> experimentalVersions() {
        return Arrays.stream(GraphDatabaseSettings.CypherVersion.values()).filter(CypherVersionClassification::isExperimental).toList();
    }

    public static String shortName(GraphDatabaseSettings.CypherVersion version) {
        return switch (version) {
            default -> throw new MatchException(null, null);
            case GraphDatabaseSettings.CypherVersion.Cypher5 -> "5";
            case GraphDatabaseSettings.CypherVersion.Cypher25 -> "25";
        };
    }
}

