/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.completions;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.driver.Value;
import org.neo4j.shell.completions.CompletionEngine;
import org.neo4j.shell.parameter.ParameterService;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public abstract class DbInfo
implements AutoCloseable {
    ParameterService parameterService;
    public volatile List<String> labels = List.of();
    public volatile List<String> relationshipTypes = List.of();
    public volatile List<String> databaseNames = List.of();
    public volatile List<String> userNames = List.of();
    public volatile List<String> aliasNames = List.of();
    public volatile List<String> roleNames = List.of();
    public volatile List<String> propertyKeys = List.of();
    public volatile Map<CypherVersion, Map<String, Neo4jProcedure>> procedures = new ConcurrentHashMap<CypherVersion, Map<String, Neo4jProcedure>>();
    public volatile Map<CypherVersion, List<String>> functions = new ConcurrentHashMap<CypherVersion, List<String>>();
    public volatile CypherVersion defaultLanguage = null;
    Optional<Boolean> versionCompatibleWithCompletions = Optional.empty();

    public Map<String, CompletionEngine.ParameterType> parameters() {
        HashMap<String, CompletionEngine.ParameterType> parameters = new HashMap<String, CompletionEngine.ParameterType>();
        this.parameterService.parameters().forEach((key, value) -> parameters.put((String)key, this.parameterType((Value)value)));
        return parameters;
    }

    public DbInfo(ParameterService parameterService) {
        this.parameterService = parameterService;
    }

    public void cleanDbInfo() {
        this.labels = List.of();
        this.relationshipTypes = List.of();
        this.databaseNames = List.of();
        this.userNames = List.of();
        this.aliasNames = List.of();
        this.roleNames = List.of();
        this.propertyKeys = List.of();
        this.procedures = new ConcurrentHashMap<CypherVersion, Map<String, Neo4jProcedure>>();
        this.procedures.put(CypherVersion.Cypher5, new ConcurrentHashMap());
        this.procedures.put(CypherVersion.Cypher25, new ConcurrentHashMap());
        this.functions = new ConcurrentHashMap<CypherVersion, List<String>>();
        this.functions.put(CypherVersion.Cypher5, List.of());
        this.functions.put(CypherVersion.Cypher25, List.of());
        this.versionCompatibleWithCompletions = Optional.empty();
    }

    private CompletionEngine.ParameterType parameterType(Value value) {
        if (value.type().name().equals("STRING")) {
            return CompletionEngine.ParameterType.STRING;
        }
        if (value.type().name().equals("MAP")) {
            return CompletionEngine.ParameterType.MAP;
        }
        return CompletionEngine.ParameterType.ANY;
    }

    public abstract boolean completionsEnabled();

    public abstract void resumePolling();

    public abstract void stopPolling();

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record ReturnDescription(String name) {
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    public record Neo4jProcedure(List<ReturnDescription> returnDescription) {
    }
}

