/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.shell.prettyprint;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.neo4j.driver.summary.Plan;
import org.neo4j.shell.prettyprint.OutputFormatter;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
abstract class AbstractTablePlanFormatter {
    AbstractTablePlanFormatter() {
    }

    protected abstract String operatorHeader();

    protected abstract List<String> headers();

    private static void pad(int width, char chr, StringBuilder result) {
        result.append(OutputFormatter.repeat(chr, width));
    }

    private static int width(String header, Map<String, Integer> columns) {
        return 2 + Math.max(header.length(), columns.get(header));
    }

    private void divider(List<String> headers, TableRow tableRow, StringBuilder result, Map<String, Integer> columns) {
        for (String header : headers) {
            if (tableRow != null && header.equals(this.operatorHeader()) && tableRow.connection.isPresent()) {
                result.append("|");
                String connection = tableRow.connection.get();
                result.append(" ").append(connection);
                AbstractTablePlanFormatter.pad(AbstractTablePlanFormatter.width(header, columns) - connection.length() - 1, ' ', result);
                continue;
            }
            result.append("+");
            AbstractTablePlanFormatter.pad(AbstractTablePlanFormatter.width(header, columns), '-', result);
        }
        result.append("+").append(OutputFormatter.NEWLINE);
    }

    protected abstract Level rootLevel();

    String formatPlan(Plan plan) {
        HashMap<String, Integer> columns = new HashMap<String, Integer>();
        List<TableRow> tableRows = this.accumulate(plan, this.rootLevel(), columns);
        List<String> headers = this.headers().stream().filter(columns::containsKey).collect(Collectors.toList());
        StringBuilder result = new StringBuilder((2 + OutputFormatter.NEWLINE.length() + headers.stream().mapToInt(h -> AbstractTablePlanFormatter.width(h, columns)).sum()) * (tableRows.size() * 2 + 3));
        ArrayList<TableRow> allTableRows = new ArrayList<TableRow>();
        Map<String, Cell> headerMap = headers.stream().map(header -> Pair.of(header, new LeftJustifiedCell((String)header))).collect(Collectors.toMap(p -> (String)p._1, p -> (Cell)p._2));
        allTableRows.add(new TableRow(this.operatorHeader(), headerMap, Optional.empty()));
        allTableRows.addAll(tableRows);
        for (int rowIndex = 0; rowIndex < allTableRows.size(); ++rowIndex) {
            TableRow tableRow = (TableRow)allTableRows.get(rowIndex);
            this.divider(headers, tableRow, result, columns);
            for (int rowLineIndex = 0; rowLineIndex < tableRow.height; ++rowLineIndex) {
                for (String header2 : headers) {
                    Cell cell = tableRow.get(header2);
                    String defaultText = "";
                    if (header2.equals(this.operatorHeader()) && rowIndex + 1 < allTableRows.size()) {
                        defaultText = ((TableRow)allTableRows.get((int)(rowIndex + 1))).connection.orElse("").replace('\\', ' ');
                    }
                    result.append("| ");
                    int columnWidth = AbstractTablePlanFormatter.width(header2, columns);
                    cell.writePaddedLine(rowLineIndex, defaultText, columnWidth, result);
                    result.append(" ");
                }
                result.append("|").append(OutputFormatter.NEWLINE);
            }
        }
        this.divider(headers, null, result, columns);
        return result.toString();
    }

    protected abstract Stream<List<TableRow>> children(Plan var1, Level var2, Map<String, Integer> var3);

    protected abstract String operatorType(Plan var1, Level var2);

    protected List<TableRow> accumulate(Plan plan, Level level, Map<String, Integer> columns) {
        String line = level.line() + this.operatorType(plan, level);
        AbstractTablePlanFormatter.mapping(this.operatorHeader(), new LeftJustifiedCell(line), columns);
        return Stream.concat(Stream.of(new TableRow(line, this.details(plan, columns), level.connector())), this.children(plan, level, columns).flatMap(Collection::stream)).collect(Collectors.toList());
    }

    protected abstract Map<String, Cell> details(Plan var1, Map<String, Integer> var2);

    private static Optional<Pair<String, Cell>> mapping(String key, Cell value, Map<String, Integer> columns) {
        AbstractTablePlanFormatter.update(columns, key, value.length);
        return Optional.of(Pair.of(key, value));
    }

    private static void update(Map<String, Integer> columns, String key, int length) {
        columns.put(key, Math.max(columns.getOrDefault(key, 0), length));
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected class TableRow {
        private final String tree;
        private final Map<String, Cell> cells;
        private final Optional<String> connection;
        private final int height;

        TableRow(String tree, Map<String, Cell> cells, Optional<String> connection) {
            this.tree = tree;
            this.cells = cells;
            this.connection = connection == null ? Optional.empty() : connection;
            this.height = cells.values().stream().mapToInt(v -> v.lines.length).max().orElse(0);
        }

        Cell get(String key) {
            if (key.equals(AbstractTablePlanFormatter.this.operatorHeader())) {
                return new LeftJustifiedCell(this.tree);
            }
            return this.cells.getOrDefault(key, new LeftJustifiedCell(""));
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    protected static abstract class Level {
        protected Level() {
        }

        abstract Level sibling();

        abstract Level lastSibling();

        abstract Level firstChild();

        abstract Level onlyChild();

        abstract String line();

        abstract Optional<String> connector();
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static abstract class Cell {
        final int length;
        final String[] lines;

        Cell(String[] lines) {
            this.length = Stream.of(lines).mapToInt(String::length).max().orElse(0);
            this.lines = lines;
        }

        abstract void writePaddedLine(int var1, String var2, int var3, StringBuilder var4);

        protected static int paddingWidth(int columnWidth, String line) {
            return columnWidth - line.length() - 2;
        }

        protected String getLineOrElse(int lineIndex, String orElseValue) {
            if (lineIndex < this.lines.length) {
                return this.lines[lineIndex];
            }
            return orElseValue;
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class LeftJustifiedCell
    extends Cell {
        LeftJustifiedCell(String ... lines) {
            super(lines);
        }

        @Override
        void writePaddedLine(int lineIndex, String orElseValue, int columnWidth, StringBuilder result) {
            String line = this.getLineOrElse(lineIndex, orElseValue);
            result.append(line);
            AbstractTablePlanFormatter.pad(LeftJustifiedCell.paddingWidth(columnWidth, line), ' ', result);
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static final class Pair<T1, T2> {
        final T1 _1;
        final T2 _2;

        private Pair(T1 _1, T2 _2) {
            this._1 = _1;
            this._2 = _2;
        }

        public static <T1, T2> Pair<T1, T2> of(T1 _1, T2 _2) {
            return new Pair<T1, T2>(_1, _2);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Pair pair = (Pair)o;
            return this._1.equals(pair._1) && this._2.equals(pair._2);
        }

        public int hashCode() {
            return 31 * this._1.hashCode() + this._2.hashCode();
        }
    }

    /*
     * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
     */
    static class RightJustifiedCell
    extends Cell {
        RightJustifiedCell(String ... lines) {
            super(lines);
        }

        @Override
        void writePaddedLine(int lineIndex, String orElseValue, int columnWidth, StringBuilder result) {
            String line = this.getLineOrElse(lineIndex, orElseValue);
            AbstractTablePlanFormatter.pad(RightJustifiedCell.paddingWidth(columnWidth, line), ' ', result);
            result.append(line);
        }
    }
}

