/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.export.providers;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.nio.file.Path;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.utils.IOUtils;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.export.UploadCommand;
import org.neo4j.export.providers.SignedUpload;
import org.neo4j.export.util.IOCommon;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

public class SignedUploadAWS
implements SignedUpload {
    private static final int RETRIES_COUNT = 5;
    private static final long DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS = TimeUnit.SECONDS.toMillis(64L);
    private final String[] signedLinks;
    private final String uploadID;
    private final String boltURI;
    private final int totalParts;
    private final IOCommon.Sleeper sleeper;
    private final ExecutionContext ctx;

    public SignedUploadAWS(String[] signedLinks, String uploadID, int totalParts, ExecutionContext ctx, String boltURI) {
        this.signedLinks = signedLinks;
        this.uploadID = uploadID;
        this.totalParts = totalParts;
        this.ctx = ctx;
        this.boltURI = boltURI;
        this.sleeper = Thread::sleep;
    }

    public SignedUploadAWS(String[] signedLinks, String uploadID, int totalParts, ExecutionContext ctx, String boltURI, IOCommon.Sleeper sleeper) {
        this.signedLinks = signedLinks;
        this.uploadID = uploadID;
        this.totalParts = totalParts;
        this.ctx = ctx;
        this.boltURI = boltURI;
        this.sleeper = sleeper;
    }

    @Override
    public void copy(boolean verbose, UploadCommand.Source src) {
        try {
            this.upload(src);
        }
        catch (IOException e) {
            throw new CommandFailedException(e.getMessage(), (Throwable)e);
        }
    }

    public void upload(UploadCommand.Source src) throws IOException {
        long fileSize = IOCommon.getFileSize(src, this.ctx);
        ProgressListener progressListener = ProgressMonitorFactory.textual((OutputStream)this.ctx.out()).singlePart("Uploading to AWS (This may take a some time depending on file size and connection speed)", (long)this.signedLinks.length);
        long totalBytesCopied = this.copyToUrls(src, progressListener, fileSize);
        progressListener.close();
        this.ctx.out().println("Total bytes copied: " + totalBytesCopied);
    }

    private long copyToUrls(UploadCommand.Source src, ProgressListener progressListener, long fileSize) throws IOException {
        Path source = src.path();
        long totalBytesCopied = 0L;
        int uploadPartPosition = this.getUploadPartPosition();
        for (int i = 0; i < this.signedLinks.length; ++i) {
            totalBytesCopied += this.copyToUrl(i, uploadPartPosition, this.signedLinks[i], source, progressListener, fileSize);
            ++uploadPartPosition;
        }
        return totalBytesCopied;
    }

    /*
     * Exception decompiling
     */
    private long copyToUrl(int currentPositionInArray, int uploadPartPosition, String link, Path source, ProgressListener progressListener, long filesize) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void waitBeforeNextAttempt(int attemptNumber) {
        try {
            ThreadLocalRandom random = ThreadLocalRandom.current();
            long backoffFromRetryCount = TimeUnit.SECONDS.toMillis(1L << attemptNumber) + (long)random.nextInt(1000);
            this.sleeper.sleep(Long.min(backoffFromRetryCount, DEFAULT_MAXIMUM_RETRY_BACKOFF_MILLIS));
        }
        catch (InterruptedException e) {
            this.ctx.err().println("Interrupted waiting to retry connection to upload URL");
            throw new CommandFailedException(e.getMessage());
        }
    }

    private void checkResponseOk(HttpURLConnection connection, Path dumpDir) throws RetryableHttpException {
        int responseCode = 0;
        try {
            responseCode = connection.getResponseCode();
            switch (responseCode) {
                case 200: {
                    return;
                }
                case 500: 
                case 502: 
                case 503: 
                case 504: {
                    throw new RetryableHttpException(new IOException("Received error response from server"));
                }
            }
            this.ctx.err().println(String.format("Received HTTP error: %d uploading to AWS", responseCode));
            throw this.resumePossibleErrorResponse(dumpDir);
        }
        catch (IOException e) {
            this.ctx.out().println("Response code: " + responseCode);
            throw new RetryableHttpException(e);
        }
    }

    private CommandFailedException resumePossibleErrorResponse(Path dump) throws IOException {
        return new CommandFailedException("We encountered a problem while communicating to the Neo4j Aura system. \nYou can re-try using the existing dump by running this command: \n" + String.format("neo4j-admin push-to-cloud --%s=%s --%s=%s", "dump", dump.toAbsolutePath(), "bolt-uri", this.boltURI));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private long copyToMultiPartURL(int currentPosition, InputStream sourceStream, long chunkSize, HttpURLConnection connection, long fileSize) throws RetryableHttpException {
        try (OutputStream outputStream = connection.getOutputStream();){
            if (currentPosition == this.signedLinks.length - 1) {
                long l2 = IOUtils.copy((InputStream)sourceStream, (OutputStream)connection.getOutputStream());
                return l2;
            }
            long l = IOUtils.copyRange((InputStream)sourceStream, (long)chunkSize, (OutputStream)outputStream);
            return l;
        }
        catch (IOException e) {
            this.ctx.err().println(e.getMessage());
            throw new RetryableHttpException(e);
        }
    }

    public long getChunkSize(long fileSize) {
        if (this.totalParts <= 1) {
            return fileSize;
        }
        return (long)Math.ceil((double)fileSize / (double)this.totalParts);
    }

    private int getUploadPartPosition() {
        return this.totalParts - this.signedLinks.length;
    }

    static class RetryableHttpException
    extends RuntimeException {
        RetryableHttpException(IOException e) {
            super(e);
        }
    }
}

