/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.values.storable;

import java.lang.reflect.Array;
import java.lang.runtime.SwitchBootstraps;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZonedDateTime;
import java.time.temporal.Temporal;
import java.time.temporal.TemporalAmount;
import java.time.temporal.TemporalUnit;
import java.util.Arrays;
import java.util.Objects;
import org.apache.commons.lang3.ArrayUtils;
import org.neo4j.graphdb.spatial.CRS;
import org.neo4j.graphdb.spatial.Point;
import org.neo4j.values.storable.ArrayValue;
import org.neo4j.values.storable.BooleanArray;
import org.neo4j.values.storable.BooleanValue;
import org.neo4j.values.storable.ByteArray;
import org.neo4j.values.storable.ByteValue;
import org.neo4j.values.storable.CharArray;
import org.neo4j.values.storable.CharValue;
import org.neo4j.values.storable.CoordinateReferenceSystem;
import org.neo4j.values.storable.DateArray;
import org.neo4j.values.storable.DateTimeArray;
import org.neo4j.values.storable.DateTimeValue;
import org.neo4j.values.storable.DateValue;
import org.neo4j.values.storable.DoubleArray;
import org.neo4j.values.storable.DoubleValue;
import org.neo4j.values.storable.DurationArray;
import org.neo4j.values.storable.DurationValue;
import org.neo4j.values.storable.Float32Vector;
import org.neo4j.values.storable.Float64Vector;
import org.neo4j.values.storable.FloatArray;
import org.neo4j.values.storable.FloatValue;
import org.neo4j.values.storable.FloatingPointValue;
import org.neo4j.values.storable.Int16Vector;
import org.neo4j.values.storable.Int32Vector;
import org.neo4j.values.storable.Int64Vector;
import org.neo4j.values.storable.Int8Vector;
import org.neo4j.values.storable.IntArray;
import org.neo4j.values.storable.IntValue;
import org.neo4j.values.storable.IntegralValue;
import org.neo4j.values.storable.LocalDateTimeArray;
import org.neo4j.values.storable.LocalDateTimeValue;
import org.neo4j.values.storable.LocalTimeArray;
import org.neo4j.values.storable.LocalTimeValue;
import org.neo4j.values.storable.LongArray;
import org.neo4j.values.storable.LongValue;
import org.neo4j.values.storable.NoValue;
import org.neo4j.values.storable.NumberValue;
import org.neo4j.values.storable.PointArray;
import org.neo4j.values.storable.PointValue;
import org.neo4j.values.storable.ShortArray;
import org.neo4j.values.storable.ShortValue;
import org.neo4j.values.storable.StringArray;
import org.neo4j.values.storable.StringValue;
import org.neo4j.values.storable.StringWrappingStringValue;
import org.neo4j.values.storable.TemporalArray;
import org.neo4j.values.storable.TemporalValue;
import org.neo4j.values.storable.TextArray;
import org.neo4j.values.storable.TextValue;
import org.neo4j.values.storable.TimeArray;
import org.neo4j.values.storable.TimeValue;
import org.neo4j.values.storable.UTF8StringValue;
import org.neo4j.values.storable.Value;
import org.neo4j.values.storable.ValueComparator;
import org.neo4j.values.storable.ValueGroup;
import org.neo4j.values.storable.Vector;
import org.neo4j.values.storable.VectorValue;

public final class Values {
    public static final Value NO_VALUE = NoValue.NO_VALUE;
    public static final Value MIN_GLOBAL = DateTimeValue.MIN_VALUE;
    public static final Value MAX_GLOBAL = NO_VALUE;
    public static final Value MIN_NUMBER = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final Value MAX_NUMBER = Values.doubleValue(Double.NaN);
    public static final Value ZERO_FLOAT = Values.doubleValue(0.0);
    public static final IntegralValue ZERO_INT = Values.longValue(0L);
    public static final Value MIN_STRING = StringValue.EMPTY;
    public static final Value MAX_STRING = Values.booleanValue(false);
    public static final BooleanValue TRUE = Values.booleanValue(true);
    public static final BooleanValue FALSE = Values.booleanValue(false);
    public static final TextValue EMPTY_STRING = StringValue.EMPTY;
    public static final DoubleValue E = Values.doubleValue(Math.E);
    public static final DoubleValue PI = Values.doubleValue(Math.PI);
    public static final DoubleValue NaN = Values.doubleValue(Double.NaN);
    public static final DoubleValue Infinity = Values.doubleValue(Double.POSITIVE_INFINITY);
    public static final DoubleValue NegInfinity = Values.doubleValue(Double.NEGATIVE_INFINITY);
    public static final ArrayValue EMPTY_SHORT_ARRAY = Values.shortArray(ArrayUtils.EMPTY_SHORT_ARRAY);
    public static final ArrayValue EMPTY_BOOLEAN_ARRAY = Values.booleanArray(ArrayUtils.EMPTY_BOOLEAN_ARRAY);
    public static final ArrayValue EMPTY_BYTE_ARRAY = Values.byteArray(ArrayUtils.EMPTY_BYTE_ARRAY);
    public static final ArrayValue EMPTY_CHAR_ARRAY = Values.charArray(ArrayUtils.EMPTY_CHAR_ARRAY);
    public static final ArrayValue EMPTY_INT_ARRAY = Values.intArray(ArrayUtils.EMPTY_INT_ARRAY);
    public static final ArrayValue EMPTY_LONG_ARRAY = Values.longArray(ArrayUtils.EMPTY_LONG_ARRAY);
    public static final ArrayValue EMPTY_FLOAT_ARRAY = Values.floatArray(ArrayUtils.EMPTY_FLOAT_ARRAY);
    public static final ArrayValue EMPTY_DOUBLE_ARRAY = Values.doubleArray(ArrayUtils.EMPTY_DOUBLE_ARRAY);
    public static final TextArray EMPTY_TEXT_ARRAY = Values.stringArray(new String[0]);
    public static final ValueComparator COMPARATOR = new ValueComparator(Enum::compareTo);

    private Values() {
    }

    public static boolean isNumberValue(Object value) {
        return value instanceof NumberValue;
    }

    public static boolean isBooleanValue(Object value) {
        return value instanceof BooleanValue;
    }

    public static boolean isTextValue(Object value) {
        return value instanceof TextValue;
    }

    public static boolean isArrayValue(Value value) {
        return value instanceof ArrayValue;
    }

    public static boolean isGeometryValue(Value value) {
        return value instanceof PointValue;
    }

    public static boolean isGeometryArray(Value value) {
        return value instanceof PointArray;
    }

    public static boolean isTemporalValue(Value value) {
        return value instanceof TemporalValue || value instanceof DurationValue;
    }

    public static boolean isTemporalArray(Value value) {
        return value instanceof TemporalArray || value instanceof DurationArray;
    }

    public static double coerceToDouble(Value value) {
        Value value2 = value;
        Objects.requireNonNull(value2);
        Value value3 = value2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IntegralValue.class, FloatingPointValue.class}, (Object)value3, n)) {
            case 0 -> {
                IntegralValue integralValue = (IntegralValue)value3;
                yield integralValue.longValue();
            }
            case 1 -> {
                FloatingPointValue floatingPointValue = (FloatingPointValue)value3;
                yield floatingPointValue.doubleValue();
            }
            default -> throw new UnsupportedOperationException(String.format("Cannot coerce %s to double", value));
        };
    }

    public static TextValue utf8Value(String value) {
        return Values.utf8Value(value.getBytes(StandardCharsets.UTF_8));
    }

    public static Value ut8fOrNoValue(String value) {
        return value == null ? NO_VALUE : Values.utf8Value(value);
    }

    public static TextValue utf8Value(byte[] bytes) {
        return bytes.length == 0 ? EMPTY_STRING : Values.utf8Value(bytes, 0, bytes.length);
    }

    public static TextValue utf8Value(byte[] bytes, int offset, int length) {
        return length == 0 ? EMPTY_STRING : new UTF8StringValue(bytes, offset, length);
    }

    public static TextValue stringValue(String value) {
        return value.isEmpty() ? EMPTY_STRING : new StringWrappingStringValue(value);
    }

    public static Value stringOrNoValue(String value) {
        return value == null ? NO_VALUE : Values.stringValue(value);
    }

    public static NumberValue numberValue(Number number) {
        Number number2 = number;
        Objects.requireNonNull(number2);
        Number number3 = number2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Long.class, Integer.class, Double.class, Byte.class, Float.class, Short.class}, (Object)number3, n)) {
            case 0 -> {
                Long longNumber = (Long)number3;
                yield Values.longValue(longNumber);
            }
            case 1 -> {
                Integer intNumber = (Integer)number3;
                yield Values.intValue(intNumber);
            }
            case 2 -> {
                Double doubleNumber = (Double)number3;
                yield Values.doubleValue(doubleNumber);
            }
            case 3 -> {
                Byte byteNumber = (Byte)number3;
                yield Values.byteValue(byteNumber);
            }
            case 4 -> {
                Float floatNumber = (Float)number3;
                yield Values.floatValue(floatNumber.floatValue());
            }
            case 5 -> {
                Short shortNumber = (Short)number3;
                yield Values.shortValue(shortNumber);
            }
            default -> throw new UnsupportedOperationException("Unsupported type of Number " + String.valueOf(number));
        };
    }

    public static LongValue longValue(long value) {
        return new LongValue(value);
    }

    public static IntValue intValue(int value) {
        return new IntValue(value);
    }

    public static ShortValue shortValue(short value) {
        return new ShortValue(value);
    }

    public static ByteValue byteValue(byte value) {
        return new ByteValue(value);
    }

    public static BooleanValue booleanValue(boolean value) {
        return value ? BooleanValue.TRUE : BooleanValue.FALSE;
    }

    public static CharValue charValue(char value) {
        return new CharValue(value);
    }

    public static DoubleValue doubleValue(double value) {
        return new DoubleValue(value);
    }

    public static FloatValue floatValue(float value) {
        return new FloatValue(value);
    }

    public static TextArray stringArray(String ... value) {
        return new StringArray(value);
    }

    public static ByteArray byteArray(byte[] value) {
        return new ByteArray(value);
    }

    public static LongArray longArray(long[] value) {
        return new LongArray(value);
    }

    public static IntArray intArray(int[] value) {
        return new IntArray(value);
    }

    public static DoubleArray doubleArray(double[] value) {
        return new DoubleArray(value);
    }

    public static FloatArray floatArray(float[] value) {
        return new FloatArray(value);
    }

    public static BooleanArray booleanArray(boolean[] value) {
        return new BooleanArray(value);
    }

    public static CharArray charArray(char[] value) {
        return new CharArray(value);
    }

    public static ShortArray shortArray(short[] value) {
        return new ShortArray(value);
    }

    public static PointValue pointValue(CoordinateReferenceSystem crs, double ... coordinate) {
        return new PointValue(crs, coordinate);
    }

    public static PointValue point(Point point) {
        double[] coords = point.getCoordinate().getCoordinateCopy();
        return new PointValue(Values.crs(point.getCRS()), coords);
    }

    public static PointValue minPointValue(PointValue reference) {
        return PointValue.minPointValueOf(reference.getCoordinateReferenceSystem());
    }

    public static PointValue maxPointValue(PointValue reference) {
        return PointValue.maxPointValueOf(reference.getCoordinateReferenceSystem());
    }

    public static PointArray pointArray(Point[] points) {
        PointValue[] values = new PointValue[points.length];
        for (int i = 0; i < points.length; ++i) {
            values[i] = Values.point(points[i]);
        }
        return new PointArray(values);
    }

    public static PointArray pointArray(Value[] maybePoints) {
        PointValue[] values = new PointValue[maybePoints.length];
        for (int i = 0; i < maybePoints.length; ++i) {
            Value maybePoint = maybePoints[i];
            if (!(maybePoint instanceof PointValue)) {
                throw new IllegalArgumentException(String.format("[%s:%s] is not a supported point value", maybePoint, maybePoint.getClass().getName()));
            }
            values[i] = Values.point((PointValue)maybePoint);
        }
        return Values.pointArray(values);
    }

    public static PointArray pointArray(PointValue[] points) {
        return new PointArray(points);
    }

    public static CoordinateReferenceSystem crs(CRS crs) {
        return CoordinateReferenceSystem.get(crs);
    }

    public static Value temporalValue(Temporal value) {
        Temporal temporal = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ZonedDateTime.class, OffsetDateTime.class, LocalDateTime.class, OffsetTime.class, LocalDate.class, LocalTime.class, TemporalValue.class}, (Object)temporal, n)) {
            case 0 -> {
                ZonedDateTime zonedDateTime = (ZonedDateTime)temporal;
                yield DateTimeValue.datetime(zonedDateTime);
            }
            case 1 -> {
                OffsetDateTime offsetDateTime = (OffsetDateTime)temporal;
                yield DateTimeValue.datetime(offsetDateTime);
            }
            case 2 -> {
                LocalDateTime localDateTime = (LocalDateTime)temporal;
                yield LocalDateTimeValue.localDateTime(localDateTime);
            }
            case 3 -> {
                OffsetTime offsetTime = (OffsetTime)temporal;
                yield TimeValue.time(offsetTime);
            }
            case 4 -> {
                LocalDate localDate = (LocalDate)temporal;
                yield DateValue.date(localDate);
            }
            case 5 -> {
                LocalTime localTime = (LocalTime)temporal;
                yield LocalTimeValue.localTime(localTime);
            }
            case 6 -> {
                TemporalValue temporalValue = (TemporalValue)temporal;
                yield temporalValue;
            }
            case -1 -> NO_VALUE;
            default -> throw new UnsupportedOperationException("Unsupported type of Temporal " + String.valueOf(value));
        };
    }

    public static DurationValue durationValue(TemporalAmount value) {
        TemporalAmount temporalAmount = value;
        Objects.requireNonNull(temporalAmount);
        TemporalAmount temporalAmount2 = temporalAmount;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{Duration.class, Period.class, DurationValue.class}, (Object)temporalAmount2, n)) {
            case 0 -> {
                Duration duration = (Duration)temporalAmount2;
                yield DurationValue.duration(duration);
            }
            case 1 -> {
                Period period = (Period)temporalAmount2;
                yield DurationValue.duration(period);
            }
            case 2 -> {
                DurationValue durationValue;
                yield durationValue = (DurationValue)temporalAmount2;
            }
            default -> {
                DurationValue duration = DurationValue.duration(0L, 0L, 0L, 0L);
                for (TemporalUnit unit : value.getUnits()) {
                    duration = duration.plus(value.get(unit), unit);
                }
                yield duration;
            }
        };
    }

    public static DateTimeArray dateTimeArray(ZonedDateTime[] values) {
        return new DateTimeArray(values);
    }

    public static LocalDateTimeArray localDateTimeArray(LocalDateTime[] values) {
        return new LocalDateTimeArray(values);
    }

    public static LocalTimeArray localTimeArray(LocalTime[] values) {
        return new LocalTimeArray(values);
    }

    public static TimeArray timeArray(OffsetTime[] values) {
        return new TimeArray(values);
    }

    public static DateArray dateArray(LocalDate[] values) {
        return new DateArray(values);
    }

    public static DurationArray durationArray(DurationValue[] values) {
        return new DurationArray(values);
    }

    public static DurationArray durationArray(TemporalAmount[] values) {
        DurationValue[] durations = new DurationValue[values.length];
        for (int i = 0; i < values.length; ++i) {
            durations[i] = Values.durationValue(values[i]);
        }
        return new DurationArray(durations);
    }

    public static Value vectorValue(Vector vector) {
        Vector vector2 = vector;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VectorValue.class}, (Object)vector2, n)) {
            case 0 -> {
                VectorValue value = (VectorValue)vector2;
                yield value;
            }
            case -1 -> NO_VALUE;
            default -> throw new UnsupportedOperationException("Unsupported type of Vector " + String.valueOf(vector));
        };
    }

    public static Int64Vector int64Vector(long ... coordinates) {
        VectorValue.ensureValidDimensions(coordinates.length);
        return new Int64Vector(coordinates);
    }

    public static Int32Vector int32Vector(int ... coordinates) {
        VectorValue.ensureValidDimensions(coordinates.length);
        return new Int32Vector(coordinates);
    }

    public static Int16Vector int16Vector(short ... coordinates) {
        VectorValue.ensureValidDimensions(coordinates.length);
        return new Int16Vector(coordinates);
    }

    public static Int8Vector int8Vector(byte ... coordinates) {
        VectorValue.ensureValidDimensions(coordinates.length);
        return new Int8Vector(coordinates);
    }

    public static Float64Vector float64Vector(double ... coordinates) {
        VectorValue.ensureValidDimensions(coordinates.length);
        return new Float64Vector(coordinates);
    }

    public static Float32Vector float32Vector(float ... coordinates) {
        VectorValue.ensureValidDimensions(coordinates.length);
        return new Float32Vector(coordinates);
    }

    public static Value of(Object value) {
        return Values.of(value, true);
    }

    public static Value of(Object value, boolean allowNull) {
        Value of = Values.unsafeOf(value, allowNull);
        if (of != null) {
            return of;
        }
        Objects.requireNonNull(value);
        throw new IllegalArgumentException(String.format("[%s:%s] is not a supported property value", value, value.getClass().getName()));
    }

    public static Value unsafeOf(Object value, boolean allowNull) {
        Object object = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String.class, Object[].class, Boolean.class, Number.class, Character.class, Temporal.class, TemporalAmount.class, byte[].class, long[].class, int[].class, double[].class, float[].class, boolean[].class, char[].class, short[].class, Point.class, Vector.class, Value.class}, (Object)object, n)) {
            case -1 -> {
                if (allowNull) {
                    yield NO_VALUE;
                }
                throw new IllegalArgumentException("[null] is not a supported property value");
            }
            case 0 -> {
                String string = (String)object;
                yield Values.utf8Value(string.getBytes(StandardCharsets.UTF_8));
            }
            case 1 -> {
                Object[] array = (Object[])object;
                yield Values.arrayValue(array, true);
            }
            case 2 -> {
                Boolean bool = (Boolean)object;
                yield Values.booleanValue(bool);
            }
            case 3 -> {
                Number number = (Number)object;
                yield Values.numberValue(number);
            }
            case 4 -> {
                Character character = (Character)object;
                yield Values.charValue(character.charValue());
            }
            case 5 -> {
                Temporal temporal = (Temporal)object;
                yield Values.temporalValue(temporal);
            }
            case 6 -> {
                TemporalAmount temporalAmount = (TemporalAmount)object;
                yield Values.durationValue(temporalAmount);
            }
            case 7 -> {
                byte[] byteArray = (byte[])object;
                yield Values.byteArray(Arrays.copyOf(byteArray, byteArray.length));
            }
            case 8 -> {
                long[] longArray = (long[])object;
                yield Values.longArray(Arrays.copyOf(longArray, longArray.length));
            }
            case 9 -> {
                int[] intArray = (int[])object;
                yield Values.intArray(Arrays.copyOf(intArray, intArray.length));
            }
            case 10 -> {
                double[] doubleArray = (double[])object;
                yield Values.doubleArray(Arrays.copyOf(doubleArray, doubleArray.length));
            }
            case 11 -> {
                float[] floatArray = (float[])object;
                yield Values.floatArray(Arrays.copyOf(floatArray, floatArray.length));
            }
            case 12 -> {
                boolean[] boolArray = (boolean[])object;
                yield Values.booleanArray(Arrays.copyOf(boolArray, boolArray.length));
            }
            case 13 -> {
                char[] charArray = (char[])object;
                yield Values.charArray(Arrays.copyOf(charArray, charArray.length));
            }
            case 14 -> {
                short[] shortArray = (short[])object;
                yield Values.shortArray(Arrays.copyOf(shortArray, shortArray.length));
            }
            case 15 -> {
                Point point = (Point)object;
                yield Values.point(point);
            }
            case 16 -> {
                Vector vector = (Vector)object;
                yield Values.vectorValue(vector);
            }
            case 17 -> {
                Value ignored = (Value)object;
                throw new UnsupportedOperationException("Converting a Value to a Value using Values.of() is not supported.");
            }
            default -> null;
        };
    }

    public static Value[] values(Object ... objects) {
        return (Value[])Arrays.stream(objects).map(Values::of).toArray(Value[]::new);
    }

    public static Object[] asObjects(Value[] propertyValues) {
        Object[] legacy = new Object[propertyValues.length];
        for (int i = 0; i < propertyValues.length; ++i) {
            legacy[i] = propertyValues[i].asObjectCopy();
        }
        return legacy;
    }

    public static ArrayValue arrayValue(Object[] value, boolean copyDefensively) {
        Objects.requireNonNull(value);
        Object[] objectArray = value;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{String[].class, Byte[].class, Long[].class, Integer[].class, Double[].class, Float[].class, Boolean[].class, Character[].class, Short[].class, PointValue[].class, Point[].class, ZonedDateTime[].class, LocalDateTime[].class, OffsetTime[].class, LocalTime[].class, LocalDate[].class, TemporalAmount[].class}, (Object)objectArray, n)) {
            case 0 -> {
                Object[] array = (String[])objectArray;
                yield Values.stringArray((String[])(copyDefensively ? Values.copy(array, new String[array.length]) : array));
            }
            case 1 -> {
                Object[] array = (Byte[])objectArray;
                yield Values.byteArray(Values.copy(array, new byte[array.length]));
            }
            case 2 -> {
                Object[] array = (Long[])objectArray;
                yield Values.longArray(Values.copy(array, new long[array.length]));
            }
            case 3 -> {
                Object[] array = (Integer[])objectArray;
                yield Values.intArray(Values.copy(array, new int[array.length]));
            }
            case 4 -> {
                Object[] array = (Double[])objectArray;
                yield Values.doubleArray(Values.copy(array, new double[array.length]));
            }
            case 5 -> {
                Object[] array = (Float[])objectArray;
                yield Values.floatArray(Values.copy(array, new float[array.length]));
            }
            case 6 -> {
                Object[] array = (Boolean[])objectArray;
                yield Values.booleanArray(Values.copy(array, new boolean[array.length]));
            }
            case 7 -> {
                Object[] array = (Character[])objectArray;
                yield Values.charArray(Values.copy(array, new char[array.length]));
            }
            case 8 -> {
                Object[] array = (Short[])objectArray;
                yield Values.shortArray(Values.copy(array, new short[array.length]));
            }
            case 9 -> {
                Object[] array = (PointValue[])objectArray;
                yield Values.pointArray((PointValue[])(copyDefensively ? Values.copy(array, new PointValue[value.length]) : array));
            }
            case 10 -> {
                Point[] array = (Point[])objectArray;
                yield Values.pointArray(array);
            }
            case 11 -> {
                Object[] array = (ZonedDateTime[])objectArray;
                yield Values.dateTimeArray((ZonedDateTime[])(copyDefensively ? Values.copy(array, new ZonedDateTime[array.length]) : array));
            }
            case 12 -> {
                Object[] array = (LocalDateTime[])objectArray;
                yield Values.localDateTimeArray((LocalDateTime[])(copyDefensively ? Values.copy(array, new LocalDateTime[array.length]) : array));
            }
            case 13 -> {
                Object[] array = (OffsetTime[])objectArray;
                yield Values.timeArray((OffsetTime[])(copyDefensively ? Values.copy(array, new OffsetTime[array.length]) : array));
            }
            case 14 -> {
                Object[] array = (LocalTime[])objectArray;
                yield Values.localTimeArray((LocalTime[])(copyDefensively ? Values.copy(array, new LocalTime[array.length]) : array));
            }
            case 15 -> {
                Object[] array = (LocalDate[])objectArray;
                yield Values.dateArray((LocalDate[])(copyDefensively ? Values.copy(array, new LocalDate[array.length]) : array));
            }
            case 16 -> {
                TemporalAmount[] array = (TemporalAmount[])objectArray;
                yield Values.durationArray(array);
            }
            default -> null;
        };
    }

    private static <T> T copy(Object[] value, T target) {
        for (int i = 0; i < value.length; ++i) {
            if (value[i] == null) {
                throw new IllegalArgumentException("Property array value elements may not be null.");
            }
            Array.set(target, i, value[i]);
        }
        return target;
    }

    public static Value minValue(ValueGroup valueGroup, Value value) {
        return switch (valueGroup) {
            case ValueGroup.TEXT -> MIN_STRING;
            case ValueGroup.NUMBER -> MIN_NUMBER;
            case ValueGroup.GEOMETRY -> Values.minPointValue((PointValue)value);
            case ValueGroup.DATE -> DateValue.MIN_VALUE;
            case ValueGroup.LOCAL_DATE_TIME -> LocalDateTimeValue.MIN_VALUE;
            case ValueGroup.ZONED_DATE_TIME -> DateTimeValue.MIN_VALUE;
            case ValueGroup.LOCAL_TIME -> LocalTimeValue.MIN_VALUE;
            case ValueGroup.ZONED_TIME -> TimeValue.MIN_VALUE;
            default -> throw new IllegalStateException(String.format("The minValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
        };
    }

    public static Value maxValue(ValueGroup valueGroup, Value value) {
        return switch (valueGroup) {
            case ValueGroup.TEXT -> MAX_STRING;
            case ValueGroup.NUMBER -> MAX_NUMBER;
            case ValueGroup.GEOMETRY -> Values.maxPointValue((PointValue)value);
            case ValueGroup.DATE -> DateValue.MAX_VALUE;
            case ValueGroup.LOCAL_DATE_TIME -> LocalDateTimeValue.MAX_VALUE;
            case ValueGroup.ZONED_DATE_TIME -> DateTimeValue.MAX_VALUE;
            case ValueGroup.LOCAL_TIME -> LocalTimeValue.MAX_VALUE;
            case ValueGroup.ZONED_TIME -> TimeValue.MAX_VALUE;
            default -> throw new IllegalStateException(String.format("The maxValue for valueGroup %s is not defined yet", new Object[]{valueGroup}));
        };
    }
}

