/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking;

import java.util.concurrent.TimeUnit;
import org.neo4j.gqlstatus.ErrorGqlStatusObject;
import org.neo4j.gqlstatus.ErrorGqlStatusObjectImplementation;
import org.neo4j.gqlstatus.GqlParams;
import org.neo4j.gqlstatus.GqlStatusInfoCodes;
import org.neo4j.graphdb.TransactionTerminatedException;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.lock.ResourceType;

public class LockAcquisitionTimeoutException
extends TransactionTerminatedException {
    private LockAcquisitionTimeoutException(ErrorGqlStatusObject gqlStatusObject, ResourceType resourceType, long resourceId, long timeoutNano) {
        super(gqlStatusObject, (Status)Status.Transaction.LockAcquisitionTimeout, String.format("Unable to acquire lock for resource: %s with id: %d within %d millis.", new Object[]{resourceType, resourceId, TimeUnit.NANOSECONDS.toMillis(timeoutNano)}));
    }

    private LockAcquisitionTimeoutException(ErrorGqlStatusObject gqlStatusObject, Status status, String message) {
        super(gqlStatusObject, status, message);
    }

    public static LockAcquisitionTimeoutException interrupted() {
        String reason = Status.Transaction.Interrupted.code().description() + " Interrupted while waiting";
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N16).withParam(GqlParams.StringParam.msg, reason).build();
        return new LockAcquisitionTimeoutException(gql, (Status)Status.Transaction.Interrupted, "Interrupted while waiting.");
    }

    public static LockAcquisitionTimeoutException lockAcquisitionTimeout(ResourceType resourceType, long resourceId, long timeoutNano) {
        String reason = Status.Transaction.LockAcquisitionTimeout.code().description() + String.format(" Unable to acquire lock for resource: %s with id: %d within %d millis.", new Object[]{resourceType, resourceId, TimeUnit.NANOSECONDS.toMillis(timeoutNano)});
        ErrorGqlStatusObject gql = ErrorGqlStatusObjectImplementation.from((GqlStatusInfoCodes)GqlStatusInfoCodes.STATUS_25N16).withParam(GqlParams.StringParam.msg, reason).build();
        return new LockAcquisitionTimeoutException(gql, resourceType, resourceId, timeoutNano);
    }
}

