/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.kernel.impl.locking.multiversion;

import java.util.Collection;
import org.neo4j.configuration.Config;
import org.neo4j.kernel.impl.api.LeaseClient;
import org.neo4j.kernel.impl.locking.LockManager;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceType;
import org.neo4j.memory.MemoryTracker;

public class MultiVersionLockManager
implements LockManager {
    private final LockManager storageLockManager;

    public MultiVersionLockManager(LockManager storageLockManager) {
        this.storageLockManager = storageLockManager;
    }

    @Override
    public LockManager.Client newClient() {
        return new MultiversionLockClient(this.storageLockManager.newClient());
    }

    @Override
    public void accept(LockManager.Visitor visitor) {
        this.storageLockManager.accept(visitor);
    }

    @Override
    public void close() {
        this.storageLockManager.close();
    }

    private static class MultiversionLockClient
    implements LockManager.Client {
        private final LockManager.Client delegate;

        public MultiversionLockClient(LockManager.Client delegate) {
            this.delegate = delegate;
        }

        @Override
        public void initialize(LeaseClient leaseClient, long transactionId, MemoryTracker memoryTracker, Config config) {
            this.delegate.initialize(leaseClient, transactionId, memoryTracker, config);
        }

        @Override
        public boolean trySharedLock(ResourceType resourceType, long resourceId) {
            if (resourceType != ResourceType.PAGE) {
                return false;
            }
            return this.delegate.trySharedLock(resourceType, resourceId);
        }

        @Override
        public void prepareForCommit() {
            this.delegate.prepareForCommit();
        }

        @Override
        public void stop() {
            this.delegate.stop();
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public long getTransactionId() {
            return this.delegate.getTransactionId();
        }

        @Override
        public long activeLockCount() {
            return this.delegate.activeLockCount();
        }

        @Override
        public void reset() {
            this.delegate.reset();
        }

        @Override
        public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
            if (resourceType != ResourceType.PAGE && resourceType != ResourceType.DENSE_VALIDATION) {
                return false;
            }
            return this.delegate.tryExclusiveLock(resourceType, resourceId);
        }

        @Override
        public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
            switch (resourceType) {
                case PAGE: 
                case RELATIONSHIP_TYPE: 
                case LABEL: 
                case SCHEMA_NAME: 
                case INDEX_ENTRY: 
                case DENSE_VALIDATION: {
                    this.delegate.acquireExclusive(tracer, resourceType, resourceIds);
                }
            }
        }

        @Override
        public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
            switch (resourceType) {
                case PAGE: 
                case RELATIONSHIP_TYPE: 
                case LABEL: 
                case SCHEMA_NAME: 
                case INDEX_ENTRY: 
                case DENSE_VALIDATION: {
                    this.delegate.releaseExclusive(resourceType, resourceIds);
                }
            }
        }

        @Override
        public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
            if (resourceType != ResourceType.PAGE) {
                return;
            }
            this.delegate.acquireShared(tracer, resourceType, resourceIds);
        }

        @Override
        public void releaseShared(ResourceType resourceType, long ... resourceIds) {
            if (resourceType != ResourceType.PAGE) {
                return;
            }
            this.delegate.releaseShared(resourceType, resourceIds);
        }

        @Override
        public Collection<ActiveLock> activeLocks() {
            return this.delegate.activeLocks();
        }

        @Override
        public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
            return this.delegate.holdsLock(id, resource, lockType);
        }
    }
}

