/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.collection.trackable;

import java.util.Objects;
import org.eclipse.collections.impl.map.mutable.primitive.AbstractMutableIntValuesMap;
import org.eclipse.collections.impl.map.mutable.primitive.IntIntHashMap;
import org.neo4j.memory.HeapEstimator;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.util.VisibleForTesting;

public class HeapTrackingIntIntHashMap
extends IntIntHashMap
implements AutoCloseable {
    private static final long SHALLOW_SIZE = HeapEstimator.shallowSizeOfInstance(HeapTrackingIntIntHashMap.class);
    static final int DEFAULT_INITIAL_CAPACITY = 8;
    final MemoryTracker memoryTracker;
    private int trackedCapacity;

    public static HeapTrackingIntIntHashMap createIntIntHashMap(MemoryTracker memoryTracker) {
        memoryTracker.allocateHeap(SHALLOW_SIZE + HeapTrackingIntIntHashMap.arraysHeapSize(32));
        return new HeapTrackingIntIntHashMap(memoryTracker, 16);
    }

    private HeapTrackingIntIntHashMap(MemoryTracker memoryTracker, int trackedCapacity) {
        this.memoryTracker = Objects.requireNonNull(memoryTracker);
        this.trackedCapacity = trackedCapacity;
    }

    protected void allocateTable(int sizeToAllocate) {
        if (this.memoryTracker != null) {
            this.memoryTracker.allocateHeap(HeapTrackingIntIntHashMap.arraysHeapSize(sizeToAllocate << 1));
            this.memoryTracker.releaseHeap(HeapTrackingIntIntHashMap.arraysHeapSize(this.trackedCapacity << 1));
            this.trackedCapacity = sizeToAllocate;
        }
        super.allocateTable(sizeToAllocate);
    }

    @Override
    public void close() {
        this.memoryTracker.releaseHeap(HeapTrackingIntIntHashMap.arraysHeapSize(this.trackedCapacity << 1) + SHALLOW_SIZE);
    }

    public int size() {
        AbstractMutableIntValuesMap.SentinelValues sentinelValues = this.getSentinelValues();
        return this.getOccupiedWithData() + (sentinelValues == null ? 0 : sentinelValues.size());
    }

    @VisibleForTesting
    public static long arraysHeapSize(int arrayLength) {
        return HeapEstimator.alignObjectSize((long)((long)HeapEstimator.ARRAY_HEADER_BYTES + (long)arrayLength * 4L));
    }
}

