/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.io.Serializable;
import org.neo4j.cypher.internal.ast.EdgeType;
import org.neo4j.cypher.internal.ast.EdgeTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.ast.EdgeTypeReferenceByLabel;
import org.neo4j.cypher.internal.ast.EmptyNodeTypeReference;
import org.neo4j.cypher.internal.ast.GraphType;
import org.neo4j.cypher.internal.ast.GraphTypeConstraint;
import org.neo4j.cypher.internal.ast.GraphTypeConstraintDefinition;
import org.neo4j.cypher.internal.ast.GraphTypeElementReference;
import org.neo4j.cypher.internal.ast.NoOptions$;
import org.neo4j.cypher.internal.ast.NodeType;
import org.neo4j.cypher.internal.ast.NodeTypeReference;
import org.neo4j.cypher.internal.ast.NodeTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.ast.NodeTypeReferenceByIdentifyingLabel$;
import org.neo4j.cypher.internal.ast.NodeTypeReferenceByLabel;
import org.neo4j.cypher.internal.ast.NodeTypeReferenceByLabel$;
import org.neo4j.cypher.internal.ast.Options;
import org.neo4j.cypher.internal.ast.OptionsMap;
import org.neo4j.cypher.internal.ast.OptionsParam;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier;
import org.neo4j.cypher.internal.ast.prettifier.ExpressionStringifier$;
import org.neo4j.cypher.internal.ast.prettifier.GraphTypeStringifier$;
import org.neo4j.cypher.internal.expressions.Expression;
import org.neo4j.cypher.internal.expressions.LabelName;
import org.neo4j.cypher.internal.expressions.Parameter;
import org.neo4j.cypher.internal.expressions.Property;
import org.neo4j.cypher.internal.expressions.PropertyKeyName;
import org.neo4j.cypher.internal.expressions.RelTypeName;
import org.neo4j.cypher.internal.expressions.SymbolicName;
import org.neo4j.cypher.internal.expressions.Variable;
import org.neo4j.cypher.internal.expressions.Variable$;
import org.neo4j.cypher.internal.logical.plans.EmptyNodeElementTypeReference$;
import org.neo4j.cypher.internal.logical.plans.ExistenceConstraint$;
import org.neo4j.cypher.internal.logical.plans.GraphElementTypeReferenceForConstraint;
import org.neo4j.cypher.internal.logical.plans.GraphType$GraphTypeCreateConstraintOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphType$GraphTypeDropConstraintOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphType$GraphTypeEntryOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphType$PropertyTypeOrdering$;
import org.neo4j.cypher.internal.logical.plans.GraphTypeConstraintType;
import org.neo4j.cypher.internal.logical.plans.GraphTypeCreateConstraint;
import org.neo4j.cypher.internal.logical.plans.GraphTypeDropConstraint;
import org.neo4j.cypher.internal.logical.plans.GraphTypeEntry;
import org.neo4j.cypher.internal.logical.plans.KeyConstraint$;
import org.neo4j.cypher.internal.logical.plans.NodeElementType;
import org.neo4j.cypher.internal.logical.plans.NodeElementTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.logical.plans.NodeElementTypeReferenceByLabel;
import org.neo4j.cypher.internal.logical.plans.NodeElementTypeReferenceForRelationshipElementType;
import org.neo4j.cypher.internal.logical.plans.PropertyType;
import org.neo4j.cypher.internal.logical.plans.PropertyTypeConstraint;
import org.neo4j.cypher.internal.logical.plans.RelationshipElementType;
import org.neo4j.cypher.internal.logical.plans.RelationshipElementTypeReferenceByIdentifyingLabel;
import org.neo4j.cypher.internal.logical.plans.RelationshipElementTypeReferenceByLabel;
import org.neo4j.cypher.internal.logical.plans.UniquenessConstraint$;
import org.neo4j.cypher.internal.util.InputPosition;
import org.neo4j.cypher.internal.util.InputPosition$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.immutable.ArraySeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Set;
import scala.math.Ordering;

public final class GraphType$ {
    public static final GraphType$ MODULE$ = new GraphType$();
    private static final ExpressionStringifier stringifier = ExpressionStringifier$.MODULE$.pretty((Function1 & Serializable)e -> e.asCanonicalStringVal());

    private ExpressionStringifier stringifier() {
        return stringifier;
    }

    public String graphTypeInfoForShow(Set<GraphTypeEntry> elementTypes, Set<GraphTypeCreateConstraint> constraints) {
        if (elementTypes.isEmpty() && constraints.isEmpty()) {
            return "{}";
        }
        Variable nodeVariable = new Variable("n", (InputPosition)InputPosition$.MODULE$.NONE(), false);
        Variable relVariable = new Variable("r", (InputPosition)InputPosition$.MODULE$.NONE(), false);
        Set astElemTypes = (Set)elementTypes.map((Function1 & Serializable)x0$1 -> {
            GraphTypeEntry graphTypeEntry = x0$1;
            if (graphTypeEntry instanceof NodeElementType) {
                NodeElementType nodeElementType = (NodeElementType)graphTypeEntry;
                LabelName identifyingLabel = nodeElementType.identifyingLabel();
                Set<LabelName> additionalLabels = nodeElementType.additionalLabels();
                Set<PropertyType> propertyTypes = nodeElementType.propertyTypes();
                return new NodeType((Option)None$.MODULE$, identifyingLabel, additionalLabels, (Set)propertyTypes.map((Function1 & Serializable)pt -> new org.neo4j.cypher.internal.ast.PropertyType(pt.name(), pt.propertyType(), (Option)None$.MODULE$, (InputPosition)InputPosition$.MODULE$.NONE())), Predef$.MODULE$.Set().empty(), (InputPosition)InputPosition$.MODULE$.NONE());
            }
            if (graphTypeEntry instanceof RelationshipElementType) {
                RelationshipElementType relationshipElementType = (RelationshipElementType)graphTypeEntry;
                RelTypeName identifyingLabel = relationshipElementType.identifyingLabel();
                NodeElementTypeReferenceForRelationshipElementType sourceNode = relationshipElementType.sourceNode();
                NodeElementTypeReferenceForRelationshipElementType targetNode = relationshipElementType.targetNode();
                Set<PropertyType> propertyTypes = relationshipElementType.propertyTypes();
                return new EdgeType(GraphType$.getEndNodeRef$1(sourceNode), (Option)None$.MODULE$, identifyingLabel, (Set)propertyTypes.map((Function1 & Serializable)pt -> new org.neo4j.cypher.internal.ast.PropertyType(pt.name(), pt.propertyType(), (Option)None$.MODULE$, (InputPosition)InputPosition$.MODULE$.NONE())), GraphType$.getEndNodeRef$1(targetNode), Predef$.MODULE$.Set().empty(), (InputPosition)InputPosition$.MODULE$.NONE());
            }
            throw new MatchError((Object)graphTypeEntry);
        });
        Set astConstraints = (Set)constraints.map((Function1 & Serializable)constraint -> {
            GraphTypeConstraint.ExistenceConstraint existenceConstraint;
            Tuple2 tuple2 = GraphType$.getConstraintRef$1(constraint.reference(), nodeVariable, relVariable);
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            GraphTypeElementReference reference = (GraphTypeElementReference)tuple2._1();
            Variable variable = (Variable)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)reference, (Object)variable);
            GraphTypeElementReference reference2 = (GraphTypeElementReference)tuple22._1();
            Variable variable2 = (Variable)tuple22._2();
            ArraySeq astProperties = constraint.properties().map((Function1 & Serializable)x$6 -> new Property((Expression)variable2, x$6, (InputPosition)InputPosition$.MODULE$.NONE()));
            GraphTypeConstraintType graphTypeConstraintType = constraint.constraintType();
            if (ExistenceConstraint$.MODULE$.equals(graphTypeConstraintType)) {
                existenceConstraint = new GraphTypeConstraint.ExistenceConstraint(astProperties, (InputPosition)InputPosition$.MODULE$.NONE());
            } else if (graphTypeConstraintType instanceof PropertyTypeConstraint) {
                PropertyTypeConstraint propertyTypeConstraint = (PropertyTypeConstraint)graphTypeConstraintType;
                existenceConstraint = new GraphTypeConstraint.PropertyTypeConstraint(astProperties, propertyTypeConstraint.propertyType(), (InputPosition)InputPosition$.MODULE$.NONE());
            } else if (KeyConstraint$.MODULE$.equals(graphTypeConstraintType)) {
                existenceConstraint = new GraphTypeConstraint.KeyConstraint(astProperties, (InputPosition)InputPosition$.MODULE$.NONE());
            } else if (UniquenessConstraint$.MODULE$.equals(graphTypeConstraintType)) {
                existenceConstraint = new GraphTypeConstraint.UniquenessConstraint(astProperties, (InputPosition)InputPosition$.MODULE$.NONE());
            } else {
                throw new MatchError((Object)graphTypeConstraintType);
            }
            GraphTypeConstraint.ExistenceConstraint constraintBody = existenceConstraint;
            return new GraphTypeConstraintDefinition(constraint.name(), reference2, (GraphTypeConstraint.GraphTypeConstraintBody)constraintBody, constraint.options(), (InputPosition)InputPosition$.MODULE$.NONE());
        });
        GraphType astGraphType = new GraphType(astElemTypes, astConstraints, (InputPosition)InputPosition$.MODULE$.NONE());
        return GraphTypeStringifier$.MODULE$.apply(astGraphType);
    }

    public String graphTypeInfoForPlan(Set<GraphTypeEntry> elementTypes, Set<GraphTypeCreateConstraint> constraints) {
        if (elementTypes.isEmpty() && constraints.isEmpty()) {
            return "{}";
        }
        List<String> elementTypeStrings = this.getElementTypesStrings(elementTypes);
        List constraintStrings = ((List)constraints.toList().sorted((Ordering)GraphType$GraphTypeCreateConstraintOrdering$.MODULE$)).map((Function1 & Serializable)c -> {
            Object object;
            Tuple2 tuple2;
            String name = (String)c.name().map((Function1 & Serializable)n -> " " + MODULE$.stringifier().apply((Expression)new Variable(n, (InputPosition)InputPosition$.MODULE$.NONE(), Variable$.MODULE$.isIsolatedDefault()))).getOrElse((Function0 & Serializable)() -> "");
            GraphElementTypeReferenceForConstraint graphElementTypeReferenceForConstraint = c.reference();
            if (graphElementTypeReferenceForConstraint instanceof NodeElementTypeReferenceByLabel) {
                NodeElementTypeReferenceByLabel nodeElementTypeReferenceByLabel = (NodeElementTypeReferenceByLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("(n:" + MODULE$.stringifier().apply((SymbolicName)nodeElementTypeReferenceByLabel.labelName()) + ")"), (Object)"n");
            } else if (graphElementTypeReferenceForConstraint instanceof NodeElementTypeReferenceByIdentifyingLabel) {
                NodeElementTypeReferenceByIdentifyingLabel nodeElementTypeReferenceByIdentifyingLabel = (NodeElementTypeReferenceByIdentifyingLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("(n:" + MODULE$.stringifier().apply((SymbolicName)nodeElementTypeReferenceByIdentifyingLabel.labelName()) + " =>)"), (Object)"n");
            } else if (graphElementTypeReferenceForConstraint instanceof RelationshipElementTypeReferenceByLabel) {
                RelationshipElementTypeReferenceByLabel relationshipElementTypeReferenceByLabel = (RelationshipElementTypeReferenceByLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("()-[r:" + MODULE$.stringifier().apply((SymbolicName)relationshipElementTypeReferenceByLabel.relTypeName()) + "]->()"), (Object)"r");
            } else if (graphElementTypeReferenceForConstraint instanceof RelationshipElementTypeReferenceByIdentifyingLabel) {
                RelationshipElementTypeReferenceByIdentifyingLabel relationshipElementTypeReferenceByIdentifyingLabel = (RelationshipElementTypeReferenceByIdentifyingLabel)graphElementTypeReferenceForConstraint;
                tuple2 = new Tuple2((Object)("()-[r:" + MODULE$.stringifier().apply((SymbolicName)relationshipElementTypeReferenceByIdentifyingLabel.relTypeName()) + " =>]->()"), (Object)"r");
            } else {
                throw new MatchError((Object)graphElementTypeReferenceForConstraint);
            }
            Tuple2 tuple22 = tuple2;
            if (tuple22 == null) {
                throw new MatchError((Object)tuple22);
            }
            String elemType = (String)tuple22._1();
            String variable = (String)tuple22._2();
            Tuple2 tuple23 = new Tuple2((Object)elemType, (Object)variable);
            String elemType2 = (String)tuple23._1();
            String variable2 = (String)tuple23._2();
            ArraySeq props = c.properties().map((Function1 & Serializable)p -> variable2 + "." + MODULE$.stringifier().apply((SymbolicName)p));
            String propertiesString = props.size() == 1 ? (String)props.head() : props.mkString("(", ", ", ")");
            String assertion = c.constraintType().predicate();
            Options options = c.options();
            if (NoOptions$.MODULE$.equals(options)) {
                object = "";
            } else if (options instanceof OptionsParam) {
                OptionsParam optionsParam = (OptionsParam)options;
                Parameter parameter = optionsParam.parameter();
                object = " OPTIONS " + MODULE$.stringifier().apply((Expression)parameter);
            } else if (options instanceof OptionsMap) {
                OptionsMap optionsMap = (OptionsMap)options;
                Map innerMap = optionsMap.map();
                String mapString = ((IterableOnceOps)innerMap.map((Function1 & Serializable)x0$1 -> {
                    Tuple2 tuple2 = x0$1;
                    if (tuple2 != null) {
                        String s = (String)tuple2._1();
                        Expression e = (Expression)tuple2._2();
                        return MODULE$.stringifier().apply((SymbolicName)new PropertyKeyName(s, (InputPosition)InputPosition$.MODULE$.NONE())) + ": " + MODULE$.stringifier().apply(e);
                    }
                    throw new MatchError((Object)tuple2);
                })).mkString("{", ", ", "}");
                object = " OPTIONS " + mapString;
            } else {
                throw new MatchError((Object)options);
            }
            String options2 = object;
            return "CONSTRAINT" + name + " FOR " + elemType2 + " REQUIRE " + propertiesString + " " + assertion + options2;
        });
        return "{ " + ((IterableOnceOps)elementTypeStrings.$plus$plus((IterableOnce)constraintStrings)).mkString(", ") + " }";
    }

    public String graphTypeDropInfo(Set<GraphTypeEntry> elementTypes, Set<GraphTypeDropConstraint> constraints) {
        if (elementTypes.isEmpty() && constraints.isEmpty()) {
            return "{}";
        }
        List<String> elementTypeStrings = this.getElementTypesStrings(elementTypes);
        List constraintStrings = ((List)constraints.toList().sorted((Ordering)GraphType$GraphTypeDropConstraintOrdering$.MODULE$)).map((Function1 & Serializable)c -> "CONSTRAINT " + MODULE$.stringifier().apply((Expression)new Variable(c.name(), (InputPosition)InputPosition$.MODULE$.NONE(), Variable$.MODULE$.isIsolatedDefault())));
        return "{ " + ((IterableOnceOps)elementTypeStrings.$plus$plus((IterableOnce)constraintStrings)).mkString(", ") + " }";
    }

    private List<String> getElementTypesStrings(Set<GraphTypeEntry> elementTypes) {
        return ((List)elementTypes.toList().sorted((Ordering)GraphType$GraphTypeEntryOrdering$.MODULE$)).map((Function1 & Serializable)x0$1 -> {
            GraphTypeEntry graphTypeEntry = x0$1;
            if (graphTypeEntry instanceof NodeElementType) {
                NodeElementType nodeElementType = (NodeElementType)graphTypeEntry;
                String identifyingLabel = MODULE$.stringifier().apply((SymbolicName)nodeElementType.identifyingLabel());
                List impliedLabels = ((List)nodeElementType.additionalLabels().toList().sortBy((Function1 & Serializable)x$8 -> x$8.name(), (Ordering)Ordering.String$.MODULE$)).map((Function1 & Serializable)x$9 -> MODULE$.stringifier().apply((SymbolicName)x$9));
                String impliedLabelsString = impliedLabels.mkString(":", "&", "");
                List properties = GraphType$.getProperties$1(nodeElementType.propertyTypes());
                String propertiesString = properties.mkString("{", ", ", "}");
                if (impliedLabels.isEmpty() && properties.isEmpty()) {
                    return "(:" + identifyingLabel + " =>)";
                }
                if (impliedLabels.isEmpty()) {
                    return "(:" + identifyingLabel + " => " + propertiesString + ")";
                }
                if (properties.isEmpty()) {
                    return "(:" + identifyingLabel + " => " + impliedLabelsString + ")";
                }
                return "(:" + identifyingLabel + " => " + impliedLabelsString + " " + propertiesString + ")";
            }
            if (graphTypeEntry instanceof RelationshipElementType) {
                RelationshipElementType relationshipElementType = (RelationshipElementType)graphTypeEntry;
                String identifyingLabel = MODULE$.stringifier().apply((SymbolicName)relationshipElementType.identifyingLabel());
                String sourceNode = this.getEndpointRefNode$1(relationshipElementType.sourceNode());
                String targetNode = this.getEndpointRefNode$1(relationshipElementType.targetNode());
                List properties = GraphType$.getProperties$1(relationshipElementType.propertyTypes());
                String propertiesString = properties.mkString("{", ", ", "}");
                if (properties.isEmpty()) {
                    return sourceNode + "-[:" + identifyingLabel + " =>]->" + targetNode;
                }
                return sourceNode + "-[:" + identifyingLabel + " => " + propertiesString + "]->" + targetNode;
            }
            throw new MatchError((Object)graphTypeEntry);
        });
    }

    private static final NodeTypeReference getEndNodeRef$1(NodeElementTypeReferenceForRelationshipElementType endNode) {
        NodeElementTypeReferenceForRelationshipElementType nodeElementTypeReferenceForRelationshipElementType = endNode;
        if (EmptyNodeElementTypeReference$.MODULE$.equals(nodeElementTypeReferenceForRelationshipElementType)) {
            return new EmptyNodeTypeReference((InputPosition)InputPosition$.MODULE$.NONE());
        }
        if (nodeElementTypeReferenceForRelationshipElementType instanceof NodeElementTypeReferenceByLabel) {
            NodeElementTypeReferenceByLabel nodeElementTypeReferenceByLabel = (NodeElementTypeReferenceByLabel)nodeElementTypeReferenceForRelationshipElementType;
            return new NodeTypeReferenceByLabel(nodeElementTypeReferenceByLabel.labelName(), NodeTypeReferenceByLabel$.MODULE$.apply$default$2(), (InputPosition)InputPosition$.MODULE$.NONE());
        }
        if (nodeElementTypeReferenceForRelationshipElementType instanceof NodeElementTypeReferenceByIdentifyingLabel) {
            NodeElementTypeReferenceByIdentifyingLabel nodeElementTypeReferenceByIdentifyingLabel = (NodeElementTypeReferenceByIdentifyingLabel)nodeElementTypeReferenceForRelationshipElementType;
            return new NodeTypeReferenceByIdentifyingLabel(nodeElementTypeReferenceByIdentifyingLabel.labelName(), NodeTypeReferenceByIdentifyingLabel$.MODULE$.apply$default$2(), (InputPosition)InputPosition$.MODULE$.NONE());
        }
        throw new MatchError((Object)nodeElementTypeReferenceForRelationshipElementType);
    }

    private static final Tuple2 getConstraintRef$1(GraphElementTypeReferenceForConstraint ref, Variable nodeVariable$1, Variable relVariable$1) {
        GraphElementTypeReferenceForConstraint graphElementTypeReferenceForConstraint = ref;
        if (graphElementTypeReferenceForConstraint instanceof NodeElementTypeReferenceByLabel) {
            NodeElementTypeReferenceByLabel nodeElementTypeReferenceByLabel = (NodeElementTypeReferenceByLabel)graphElementTypeReferenceForConstraint;
            return new Tuple2((Object)new NodeTypeReferenceByLabel(nodeElementTypeReferenceByLabel.labelName(), (Option)new Some((Object)nodeVariable$1), (InputPosition)InputPosition$.MODULE$.NONE()), (Object)nodeVariable$1);
        }
        if (graphElementTypeReferenceForConstraint instanceof NodeElementTypeReferenceByIdentifyingLabel) {
            NodeElementTypeReferenceByIdentifyingLabel nodeElementTypeReferenceByIdentifyingLabel = (NodeElementTypeReferenceByIdentifyingLabel)graphElementTypeReferenceForConstraint;
            return new Tuple2((Object)new NodeTypeReferenceByIdentifyingLabel(nodeElementTypeReferenceByIdentifyingLabel.labelName(), (Option)new Some((Object)nodeVariable$1), (InputPosition)InputPosition$.MODULE$.NONE()), (Object)nodeVariable$1);
        }
        if (graphElementTypeReferenceForConstraint instanceof RelationshipElementTypeReferenceByLabel) {
            RelationshipElementTypeReferenceByLabel relationshipElementTypeReferenceByLabel = (RelationshipElementTypeReferenceByLabel)graphElementTypeReferenceForConstraint;
            return new Tuple2((Object)new EdgeTypeReferenceByLabel(relationshipElementTypeReferenceByLabel.relTypeName(), (Option)new Some((Object)relVariable$1), (InputPosition)InputPosition$.MODULE$.NONE()), (Object)relVariable$1);
        }
        if (graphElementTypeReferenceForConstraint instanceof RelationshipElementTypeReferenceByIdentifyingLabel) {
            RelationshipElementTypeReferenceByIdentifyingLabel relationshipElementTypeReferenceByIdentifyingLabel = (RelationshipElementTypeReferenceByIdentifyingLabel)graphElementTypeReferenceForConstraint;
            return new Tuple2((Object)new EdgeTypeReferenceByIdentifyingLabel(relationshipElementTypeReferenceByIdentifyingLabel.relTypeName(), (Option)new Some((Object)relVariable$1), (InputPosition)InputPosition$.MODULE$.NONE()), (Object)relVariable$1);
        }
        throw new MatchError((Object)graphElementTypeReferenceForConstraint);
    }

    private static final List getProperties$1(Set propTypes) {
        return ((List)propTypes.toList().sorted((Ordering)GraphType$PropertyTypeOrdering$.MODULE$)).map((Function1 & Serializable)pt -> MODULE$.stringifier().apply((SymbolicName)pt.name()) + " :: " + pt.propertyType().normalizedCypherTypeString());
    }

    private final String getEndpointRefNode$1(NodeElementTypeReferenceForRelationshipElementType node) {
        NodeElementTypeReferenceForRelationshipElementType nodeElementTypeReferenceForRelationshipElementType = node;
        if (EmptyNodeElementTypeReference$.MODULE$.equals(nodeElementTypeReferenceForRelationshipElementType)) {
            return "()";
        }
        if (nodeElementTypeReferenceForRelationshipElementType instanceof NodeElementTypeReferenceByLabel) {
            NodeElementTypeReferenceByLabel nodeElementTypeReferenceByLabel = (NodeElementTypeReferenceByLabel)nodeElementTypeReferenceForRelationshipElementType;
            return "(:" + this.stringifier().apply((SymbolicName)nodeElementTypeReferenceByLabel.labelName()) + ")";
        }
        if (nodeElementTypeReferenceForRelationshipElementType instanceof NodeElementTypeReferenceByIdentifyingLabel) {
            NodeElementTypeReferenceByIdentifyingLabel nodeElementTypeReferenceByIdentifyingLabel = (NodeElementTypeReferenceByIdentifyingLabel)nodeElementTypeReferenceForRelationshipElementType;
            return "(:" + this.stringifier().apply((SymbolicName)nodeElementTypeReferenceByIdentifyingLabel.labelName()) + " =>)";
        }
        throw new MatchError((Object)nodeElementTypeReferenceForRelationshipElementType);
    }

    private GraphType$() {
    }
}

