/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.cypher.internal.logical.plans;

import java.util.regex.Pattern;
import org.neo4j.exceptions.InvalidArgumentException;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;

public final class NameValidator$ {
    public static final NameValidator$ MODULE$ = new NameValidator$();
    private static final Pattern usernamePattern = Pattern.compile("^[\\x21-\\x2B\\x2D-\\x39\\x3B-\\x7E]+$");
    private static final Pattern roleNamePattern = Pattern.compile("^[a-zA-Z0-9_]+$");
    private static final String reservedRoleName = "PUBLIC";

    private Pattern usernamePattern() {
        return usernamePattern;
    }

    private Pattern roleNamePattern() {
        return roleNamePattern;
    }

    private String reservedRoleName() {
        return reservedRoleName;
    }

    public boolean assertValidUsername(String name) {
        if (name == null || name.isEmpty()) {
            throw InvalidArgumentException.providedStringEmpty((String)"Username");
        }
        if (!this.usernamePattern().matcher(name).matches()) {
            throw InvalidArgumentException.inputContainsInvalidCharacters((String)name, (String)"username", (String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Username '" + name + "' contains illegal characters.\n           |Use ascii characters that are not ',', ':' or whitespaces.")));
        }
        return true;
    }

    public boolean assertValidRoleName(String name) {
        if (name == null || name.isEmpty()) {
            throw InvalidArgumentException.providedStringEmpty((String)"Role name");
        }
        if (!this.roleNamePattern().matcher(name).matches()) {
            throw InvalidArgumentException.inputContainsInvalidCharacters((String)name, (String)"role name", (String)StringOps$.MODULE$.stripMargin$extension(Predef$.MODULE$.augmentString("Role name '" + name + "' contains illegal characters.\n           |Use simple ascii characters, numbers and underscores.")));
        }
        return true;
    }

    public boolean assertValidAliasName(String name) {
        if (name == null || name.isEmpty()) {
            throw InvalidArgumentException.providedStringEmpty((String)"Alias name", (String)"Alias");
        }
        if (name.length() > 65534) {
            throw InvalidArgumentException.aliasTooLong((String)name);
        }
        if (name.startsWith("system")) {
            throw InvalidArgumentException.invalidPrefixSystem((String)"Alias name", (String)name);
        }
        return true;
    }

    public boolean assertValidTargetName(String name) {
        if (name == null || name.isEmpty()) {
            throw InvalidArgumentException.providedStringEmpty((String)"Target database name");
        }
        if (name.length() > 65534) {
            throw InvalidArgumentException.dbNameTooLong((String)name);
        }
        if (name.startsWith("system")) {
            throw InvalidArgumentException.invalidPrefixSystem((String)"Target database name", (String)name);
        }
        return true;
    }

    public boolean assertUnreservedRoleName(String verb, String name, Option<String> newName) {
        if (this.reservedRoleName().equals(name)) {
            throw InvalidArgumentException.failedActionReservedRole((String)(verb + " the specified role '" + name + "'"), (String)this.reservedRoleName());
        }
        if (newName.contains((Object)this.reservedRoleName())) {
            throw InvalidArgumentException.failedActionReservedRole((String)(verb + " the specified role '" + name + "' to '" + newName.get() + "'"), (String)this.reservedRoleName());
        }
        return true;
    }

    public Option<String> assertUnreservedRoleName$default$3() {
        return None$.MODULE$;
    }

    private NameValidator$() {
    }
}

