/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.util.Optional;
import org.neo4j.dbms.api.DatabaseManagementHelper;
import org.neo4j.dbms.api.DatabaseNotFoundHelper;
import org.neo4j.dbms.database.DatabaseContext;
import org.neo4j.dbms.database.DatabaseContextFactory;
import org.neo4j.dbms.database.DatabaseRepository;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.dbms.database.UnableToStartDatabaseException;
import org.neo4j.function.ThrowingAction;
import org.neo4j.kernel.database.Database;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.Log;
import org.neo4j.logging.LogProvider;
import org.neo4j.monitoring.ExceptionHandlerService;

public final class DatabaseLifecycles {
    private final DatabaseRepository<StandaloneDatabaseContext> databaseRepository;
    private final String defaultDatabaseName;
    private final DatabaseContextFactory<StandaloneDatabaseContext, NamedDatabaseId> databaseContextFactory;
    private final Log log;
    private final ExceptionHandlerService exceptionHandlerService;

    public DatabaseLifecycles(DatabaseRepository<StandaloneDatabaseContext> databaseRepository, String defaultDatabaseName, DatabaseContextFactory<StandaloneDatabaseContext, NamedDatabaseId> databaseContextFactory, LogProvider logProvider, ExceptionHandlerService exceptionHandlerService) {
        this.databaseRepository = databaseRepository;
        this.defaultDatabaseName = defaultDatabaseName;
        this.databaseContextFactory = databaseContextFactory;
        this.log = logProvider.getLog(this.getClass());
        this.exceptionHandlerService = exceptionHandlerService;
    }

    public Lifecycle systemDatabaseStarter() {
        return new SystemDatabaseStarter();
    }

    public Lifecycle defaultDatabaseStarter() {
        return new DefaultDatabaseStarter();
    }

    public Lifecycle allDatabaseShutdown() {
        return new AllDatabaseStopper();
    }

    private StandaloneDatabaseContext systemContext() {
        return (StandaloneDatabaseContext)this.databaseRepository.getDatabaseContext(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID).orElseThrow(() -> DatabaseNotFoundHelper.databaseNotFound((String)"system"));
    }

    private Optional<StandaloneDatabaseContext> defaultContext() {
        return this.databaseRepository.getDatabaseContext(this.defaultDatabaseName);
    }

    private synchronized void initialiseDefaultDatabase() {
        NamedDatabaseId defaultDatabaseId = (NamedDatabaseId)this.databaseRepository.databaseIdRepository().getByName(this.defaultDatabaseName).orElseThrow(() -> DatabaseNotFoundHelper.defaultDatabaseNotFound((String)this.defaultDatabaseName));
        if (this.databaseRepository.getDatabaseContext(defaultDatabaseId).isPresent()) {
            throw DatabaseManagementHelper.internalError((String)this.getClass().getSimpleName(), (String)("Cannot initialize " + String.valueOf(defaultDatabaseId) + " because it already exists"));
        }
        StandaloneDatabaseContext context = this.createDatabase(defaultDatabaseId);
        this.startDatabase(context);
    }

    private StandaloneDatabaseContext createDatabase(NamedDatabaseId namedDatabaseId) {
        this.log.info("Creating '%s'.", new Object[]{namedDatabaseId});
        this.checkDatabaseLimit(namedDatabaseId);
        StandaloneDatabaseContext databaseContext = this.databaseContextFactory.create(namedDatabaseId);
        this.databaseRepository.add(namedDatabaseId, (DatabaseContext)databaseContext);
        return databaseContext;
    }

    private void stopDatabase(StandaloneDatabaseContext context) {
        NamedDatabaseId namedDatabaseId = context.database().getNamedDatabaseId();
        context.clearFailure();
        try {
            this.log.info("Stopping '%s'.", new Object[]{namedDatabaseId});
            Database database = context.database();
            database.stop();
            this.log.info("Stopped '%s' successfully.", new Object[]{namedDatabaseId});
        }
        catch (Throwable t) {
            String message = "Failed to stop " + String.valueOf(namedDatabaseId);
            this.logError(message, t);
            context.fail((Throwable)DatabaseManagementHelper.internalError((String)this.getClass().getSimpleName(), (String)String.format("An error occurred! Unable to stop `%s`.", namedDatabaseId), (Throwable)t));
        }
    }

    private void startDatabase(StandaloneDatabaseContext context) {
        NamedDatabaseId namedDatabaseId = context.database().getNamedDatabaseId();
        try {
            this.log.info("Starting '%s'.", new Object[]{namedDatabaseId});
            Database database = context.database();
            database.start();
        }
        catch (Throwable t) {
            this.logError("Failed to start " + String.valueOf(namedDatabaseId), t);
            context.fail((Throwable)UnableToStartDatabaseException.unableToStartDb((NamedDatabaseId)namedDatabaseId, (Throwable)t));
        }
    }

    private void checkDatabaseLimit(NamedDatabaseId namedDatabaseId) {
        if (this.databaseRepository.registeredDatabases().size() >= 2) {
            throw DatabaseManagementHelper.internalError((String)this.getClass().getSimpleName(), (String)("Default database already exists. Fail to create another: " + String.valueOf(namedDatabaseId)));
        }
    }

    private void logError(String message, Throwable t) {
        this.log.error(message, t);
        this.exceptionHandlerService.raiseException(message, t);
    }

    private class SystemDatabaseStarter
    extends LifecycleAdapter {
        private SystemDatabaseStarter() {
        }

        public void init() {
            DatabaseLifecycles.this.createDatabase(NamedDatabaseId.NAMED_SYSTEM_DATABASE_ID);
        }

        public void start() {
            DatabaseLifecycles.this.startDatabase(DatabaseLifecycles.this.systemContext());
        }
    }

    private class DefaultDatabaseStarter
    extends LifecycleAdapter {
        private DefaultDatabaseStarter() {
        }

        public void start() {
            DatabaseLifecycles.this.initialiseDefaultDatabase();
        }
    }

    private class AllDatabaseStopper
    extends LifecycleAdapter {
        private AllDatabaseStopper() {
        }

        public void stop() throws Exception {
            Optional<StandaloneDatabaseContext> standaloneDatabaseContext = DatabaseLifecycles.this.defaultContext();
            standaloneDatabaseContext.ifPresent(DatabaseLifecycles.this::stopDatabase);
            StandaloneDatabaseContext systemContext = DatabaseLifecycles.this.systemContext();
            DatabaseLifecycles.this.stopDatabase(systemContext);
            ThrowingAction.executeAll((ThrowingAction[])new ThrowingAction[]{() -> standaloneDatabaseContext.ifPresent(this::throwIfUnableToStop), () -> this.throwIfUnableToStop(systemContext)});
        }

        private void throwIfUnableToStop(StandaloneDatabaseContext ctx) {
            if (!ctx.isFailed()) {
                return;
            }
            if (ctx.failureCause() instanceof UnableToStartDatabaseException) {
                return;
            }
            throw DatabaseManagementHelper.internalError((String)((Object)((Object)this)).getClass().getSimpleName(), (String)("Failed to stop " + ctx.database().getNamedDatabaseId().name() + " database."), (Throwable)ctx.failureCause());
        }
    }
}

