/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.dbms.database;

import java.time.Clock;
import java.time.ZonedDateTime;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.cypher.internal.CypherVersion;
import org.neo4j.dbms.database.AbstractSystemGraphComponent;
import org.neo4j.dbms.database.ComponentVersion;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.systemgraph.TopologyGraphDbmsModel;
import org.neo4j.graphdb.ConstraintViolationException;
import org.neo4j.graphdb.GraphDatabaseService;
import org.neo4j.graphdb.Label;
import org.neo4j.graphdb.Node;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.Transaction;
import org.neo4j.graphdb.schema.ConstraintDefinition;
import org.neo4j.kernel.api.exceptions.InvalidArgumentsException;
import org.neo4j.kernel.database.DatabaseId;
import org.neo4j.kernel.database.NormalizedDatabaseName;
import org.neo4j.util.Stringifier;

public class DefaultSystemGraphComponent
extends AbstractSystemGraphComponent {
    private final NormalizedDatabaseName defaultDbName;
    private final Clock clock;

    public DefaultSystemGraphComponent(Config config, Clock clock) {
        super(config);
        this.defaultDbName = new NormalizedDatabaseName((String)config.get(GraphDatabaseSettings.initial_default_database));
        this.clock = clock;
    }

    public SystemGraphComponent.Name componentName() {
        return ComponentVersion.MULTI_DATABASE_COMPONENT;
    }

    public SystemGraphComponent.Status detect(Transaction tx) {
        boolean hasDatabaseNode = DefaultSystemGraphComponent.hasDatabaseNode(tx);
        if (!hasDatabaseNode) {
            return SystemGraphComponent.Status.UNINITIALIZED;
        }
        if (!DefaultSystemGraphComponent.hasSystemDatabaseNode(tx)) {
            return SystemGraphComponent.Status.UNSUPPORTED;
        }
        if (DefaultSystemGraphComponent.hasUniqueConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String[])new String[]{"name", "namespace"}) && DefaultSystemGraphComponent.hasUniqueConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String[])new String[]{"displayName"}) && DefaultSystemGraphComponent.hasUniqueConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_LABEL, (String[])new String[]{"name"})) {
            return SystemGraphComponent.Status.CURRENT;
        }
        return SystemGraphComponent.Status.REQUIRES_UPGRADE;
    }

    protected void initializeSystemGraphSchema(GraphDatabaseService system) throws Exception {
        DefaultSystemGraphComponent.initializeSystemGraphConstraint((GraphDatabaseService)system, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String[])new String[]{"name", "namespace"});
        DefaultSystemGraphComponent.initializeDisplayNameSystemGraphConstraint((GraphDatabaseService)system);
        DefaultSystemGraphComponent.initializeSystemGraphConstraint((GraphDatabaseService)system, (Label)TopologyGraphDbmsModel.DATABASE_LABEL, (String[])new String[]{"name"});
    }

    public void initializeSystemGraphModel(GraphDatabaseService system) throws InvalidArgumentsException {
        CypherVersion languageVersion = DefaultSystemGraphComponent.cypherVersionFromConfig((GraphDatabaseSettings.CypherVersion)this.config.get(GraphDatabaseSettings.default_language));
        try (Transaction tx = system.beginTx();){
            ZonedDateTime now = ZonedDateTime.ofInstant(this.clock.instant(), this.clock.getZone());
            DefaultSystemGraphComponent.createDatabaseNode(tx, this.defaultDbName.name(), UUID.randomUUID(), now, languageVersion);
            DefaultSystemGraphComponent.createDatabaseNode(tx, "system", DatabaseId.SYSTEM_DATABASE_ID.uuid(), now, languageVersion);
            tx.commit();
        }
        catch (ConstraintViolationException e) {
            throw InvalidArgumentsException.databaseAlreadyExistsInSystemDb((String)this.defaultDbName.name());
        }
    }

    protected void verifySystemGraph(GraphDatabaseService system) throws Exception {
        this.updateDefaultDatabase(system);
    }

    public void upgradeToCurrent(GraphDatabaseService system) throws Exception {
        this.initializeSystemGraphSchema(system);
        SystemGraphComponent.executeWithFullAccess((GraphDatabaseService)system, DefaultSystemGraphComponent::dropOldConstraints);
    }

    private static void dropOldConstraints(Transaction tx) {
        DefaultSystemGraphComponent.findUniqueConstraint((Transaction)tx, (Label)TopologyGraphDbmsModel.DATABASE_NAME_LABEL, (String[])new String[]{"name"}).ifPresent(ConstraintDefinition::drop);
    }

    private static boolean hasDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL);){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private static boolean hasSystemDatabaseNode(Transaction tx) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)"system");){
            boolean bl = nodes.hasNext();
            return bl;
        }
    }

    private void updateDefaultDatabase(GraphDatabaseService system) {
        try (Transaction tx = system.beginTx();){
            boolean defaultFound;
            Function<ResourceIterator<Node>, Boolean> unsetOldNode = nodes -> {
                boolean correctDefaultFound = false;
                while (nodes.hasNext()) {
                    Node oldDb = (Node)nodes.next();
                    if (oldDb.getProperty("name").equals(this.defaultDbName.name())) {
                        correctDefaultFound = true;
                    } else if (!oldDb.getProperty("name").equals("system")) {
                        oldDb.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.OFFLINE.statusName());
                    }
                    if (!oldDb.hasProperty("default")) continue;
                    oldDb.removeProperty("default");
                }
                return correctDefaultFound;
            };
            try (ResourceIterator nodes2 = tx.findNodes(TopologyGraphDbmsModel.DATABASE_LABEL);){
                defaultFound = unsetOldNode.apply((ResourceIterator)nodes2);
            }
            this.unsetAnyDeleted(tx, unsetOldNode);
            if (!defaultFound) {
                Node defaultDb = tx.findNode(TopologyGraphDbmsModel.DATABASE_LABEL, "name", (Object)this.defaultDbName.name());
                if (defaultDb != null) {
                    defaultDb.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.ONLINE.statusName());
                } else {
                    ZonedDateTime now = ZonedDateTime.ofInstant(this.clock.instant(), this.clock.getZone());
                    CypherVersion languageVersion = DefaultSystemGraphComponent.cypherVersionFromConfig((GraphDatabaseSettings.CypherVersion)this.config.get(GraphDatabaseSettings.default_language));
                    DefaultSystemGraphComponent.createDatabaseNode(tx, this.defaultDbName.name(), UUID.randomUUID(), now, languageVersion);
                }
            }
            tx.commit();
        }
    }

    private void unsetAnyDeleted(Transaction tx, Function<ResourceIterator<Node>, Boolean> unsetOldNode) {
        try (ResourceIterator nodes = tx.findNodes(TopologyGraphDbmsModel.DELETED_DATABASE_LABEL);){
            unsetOldNode.apply((ResourceIterator<Node>)nodes);
        }
    }

    public static Node createDatabaseNode(Transaction tx, String databaseName, UUID uuid, ZonedDateTime now, CypherVersion defaultLanguage) {
        Node databaseNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_LABEL});
        databaseNode.setProperty("name", (Object)databaseName);
        databaseNode.setProperty("uuid", (Object)uuid.toString());
        databaseNode.setProperty("status", (Object)TopologyGraphDbmsModel.DatabaseStatus.ONLINE.statusName());
        databaseNode.setProperty("created_at", (Object)now);
        databaseNode.setProperty("started_at", (Object)now);
        databaseNode.setProperty("defaultLanguage", (Object)defaultLanguage.persistedValue);
        long randomId = ThreadLocalRandom.current().nextLong();
        databaseNode.setProperty("store_random_id", (Object)randomId);
        Node nameNode = tx.createNode(new Label[]{TopologyGraphDbmsModel.DATABASE_NAME_LABEL});
        nameNode.setProperty("name", (Object)databaseName);
        nameNode.setProperty("namespace", (Object)"system-root");
        nameNode.setProperty("displayName", (Object)databaseName);
        nameNode.setProperty("quotedDisplayName", (Object)Stringifier.backtick((String)databaseName));
        nameNode.setProperty("primary", (Object)true);
        nameNode.createRelationshipTo(databaseNode, TopologyGraphDbmsModel.TARGETS_RELATIONSHIP);
        return databaseNode;
    }

    public static CypherVersion cypherVersionFromConfig(GraphDatabaseSettings.CypherVersion dbmsVersion) {
        return switch (dbmsVersion) {
            default -> throw new MatchException(null, null);
            case GraphDatabaseSettings.CypherVersion.Cypher5 -> CypherVersion.Cypher5;
            case GraphDatabaseSettings.CypherVersion.Cypher25 -> CypherVersion.Cypher25;
        };
    }
}

