/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.facade;

import java.util.Iterator;
import java.util.List;
import org.neo4j.common.DependencyResolver;
import org.neo4j.graphdb.event.DatabaseEventListener;
import org.neo4j.graphdb.facade.ExternalDependencies;
import org.neo4j.internal.helpers.collection.Iterables;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.kernel.extension.ExtensionFactory;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.monitoring.Monitors;
import org.neo4j.service.Services;

public class GraphDatabaseDependencies
implements ExternalDependencies {
    private Monitors monitors;
    private InternalLogProvider userLogProvider;
    private InternalLogProvider debugLogProvider;
    private DependencyResolver dependencies;
    private List<ExtensionFactory<?>> extensions;
    private List<DatabaseEventListener> databaseEventListeners;

    public static GraphDatabaseDependencies newDependencies(ExternalDependencies deps) {
        return new GraphDatabaseDependencies(deps.monitors(), deps.userLogProvider(), deps.dependencies(), deps.extensions(), deps.databaseEventListeners());
    }

    public static GraphDatabaseDependencies newDependencies() {
        Iterable<ExtensionFactory<?>> extensions = GraphDatabaseDependencies.getExtensions(Services.loadAll(ExtensionFactory.class).iterator());
        return new GraphDatabaseDependencies(null, null, null, extensions, Iterables.empty());
    }

    private GraphDatabaseDependencies(Monitors monitors, InternalLogProvider userLogProvider, DependencyResolver dependencies, Iterable<ExtensionFactory<?>> extensions, Iterable<DatabaseEventListener> eventListeners) {
        this.monitors = monitors;
        this.userLogProvider = userLogProvider;
        this.dependencies = dependencies;
        this.extensions = Iterables.asList(extensions);
        this.databaseEventListeners = Iterables.asList(eventListeners);
    }

    public GraphDatabaseDependencies monitors(Monitors monitors) {
        this.monitors = monitors;
        return this;
    }

    public GraphDatabaseDependencies userLogProvider(InternalLogProvider userLogProvider) {
        this.userLogProvider = userLogProvider;
        return this;
    }

    public GraphDatabaseDependencies debugLogProvider(InternalLogProvider debugLogProvider) {
        this.debugLogProvider = debugLogProvider;
        return this;
    }

    public GraphDatabaseDependencies dependencies(DependencyResolver dependencies) {
        this.dependencies = dependencies;
        return this;
    }

    public GraphDatabaseDependencies databaseEventListeners(Iterable<DatabaseEventListener> eventListeners) {
        this.databaseEventListeners = Iterables.asList(eventListeners);
        return this;
    }

    public GraphDatabaseDependencies extensions(Iterable<ExtensionFactory<?>> extensions) {
        this.extensions = Iterables.asList(extensions);
        return this;
    }

    @Override
    public Monitors monitors() {
        return this.monitors;
    }

    @Override
    public InternalLogProvider userLogProvider() {
        return this.userLogProvider;
    }

    public InternalLogProvider debugLogProvider() {
        return this.debugLogProvider;
    }

    @Override
    public Iterable<ExtensionFactory<?>> extensions() {
        return this.extensions;
    }

    @Override
    public Iterable<DatabaseEventListener> databaseEventListeners() {
        return this.databaseEventListeners;
    }

    @Override
    public DependencyResolver dependencies() {
        return this.dependencies;
    }

    private static Iterable<ExtensionFactory<?>> getExtensions(final Iterator<ExtensionFactory> parent) {
        return Iterators.asList((Iterator)new Iterator<ExtensionFactory<?>>(){

            @Override
            public boolean hasNext() {
                return parent.hasNext();
            }

            @Override
            public ExtensionFactory<?> next() {
                return (ExtensionFactory)parent.next();
            }
        });
    }
}

