/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module;

import java.util.Collection;
import java.util.HashSet;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.graphdb.event.DatabaseEventContext;
import org.neo4j.graphdb.event.DatabaseEventListenerAdapter;
import org.neo4j.kernel.monitoring.ExceptionalDatabaseEvent;
import org.neo4j.logging.InternalLog;

public class OutOfDiskSpaceListener
extends DatabaseEventListenerAdapter {
    private final Config globalConfig;
    private final InternalLog log;

    public OutOfDiskSpaceListener(Config globalConfig, InternalLog log) {
        this.globalConfig = globalConfig;
        this.log = log;
    }

    public void databaseOutOfDiskSpace(DatabaseEventContext event) {
        ExceptionalDatabaseEvent databaseEvent = (ExceptionalDatabaseEvent)event;
        String databaseName = databaseEvent.getDatabaseName();
        if (!"system".equals(databaseName)) {
            this.makeReadOnly(databaseName);
        }
    }

    private synchronized void makeReadOnly(String databaseName) {
        HashSet<String> readOnlyDatabases = new HashSet<String>((Collection)this.globalConfig.get(GraphDatabaseSettings.read_only_databases));
        if (readOnlyDatabases.add(databaseName)) {
            this.globalConfig.setDynamic(GraphDatabaseSettings.read_only_databases, readOnlyDatabases, "Dynamic failover to read-only mode because of failure to allocate disk space.");
            this.log.error(String.format("As a result of the database failing to allocate enough disk space, it has been put into read-only mode to protect from system failure and ensure data integrity. Please free up more disk space before changing access mode for database back to read-write state. Making database writable again can be done by:%n    CALL dbms.listConfig(\"%s\") YIELD value%n    WITH value%n    CALL dbms.setConfigValue(\"%s\", replace(value, \"<databaseName>\", \"\"))", GraphDatabaseSettings.read_only_databases.name(), GraphDatabaseSettings.read_only_databases.name()));
        }
    }
}

