/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.graphdb.factory.module.edition;

import java.time.Clock;
import java.util.Set;
import org.neo4j.bolt.dbapi.BoltGraphDatabaseManagementServiceSPI;
import org.neo4j.bolt.tx.TransactionManager;
import org.neo4j.collection.Dependencies;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.connectors.ConnectorPortRegister;
import org.neo4j.dbms.CommunityDatabaseStateService;
import org.neo4j.dbms.CommunityKernelPanicListener;
import org.neo4j.dbms.DatabaseStateService;
import org.neo4j.dbms.api.DatabaseManagementService;
import org.neo4j.dbms.database.CommunityDatabaseObjectRepositoryModelProvider;
import org.neo4j.dbms.database.DatabaseContextProvider;
import org.neo4j.dbms.database.DatabaseContextProviderDelegate;
import org.neo4j.dbms.database.DatabaseLifecycles;
import org.neo4j.dbms.database.DatabaseOperationCounts;
import org.neo4j.dbms.database.DatabaseReferenceCacheClearingListener;
import org.neo4j.dbms.database.DatabaseRepository;
import org.neo4j.dbms.database.DatabaseStateMonitor;
import org.neo4j.dbms.database.DefaultDatabaseContextFactory;
import org.neo4j.dbms.database.DefaultDatabaseContextFactoryComponents;
import org.neo4j.dbms.database.DefaultDatabaseDetailsExtrasProvider;
import org.neo4j.dbms.database.DefaultSystemGraphComponent;
import org.neo4j.dbms.database.DefaultSystemGraphInitializer;
import org.neo4j.dbms.database.DefaultTopologyInfoService;
import org.neo4j.dbms.database.StandaloneDatabaseContext;
import org.neo4j.dbms.database.SystemGraphComponent;
import org.neo4j.dbms.database.SystemGraphComponents;
import org.neo4j.dbms.database.SystemGraphInitializer;
import org.neo4j.dbms.database.TopologyInfoService;
import org.neo4j.dbms.database.readonly.ReadOnlyChangeListener;
import org.neo4j.dbms.database.readonly.ReadOnlyDatabases;
import org.neo4j.dbms.database.readonly.SystemGraphReadOnlyDatabaseLookupFactory;
import org.neo4j.dbms.database.readonly.SystemGraphReadOnlyListener;
import org.neo4j.dbms.identity.DefaultIdentityModule;
import org.neo4j.dbms.identity.ServerIdentity;
import org.neo4j.dbms.identity.ServerIdentityFactory;
import org.neo4j.dbms.routing.ClientRoutingDomainChecker;
import org.neo4j.dbms.routing.ClientSideRoutingTableProvider;
import org.neo4j.dbms.routing.CommunityRoutingService;
import org.neo4j.dbms.routing.DatabaseAvailabilityChecker;
import org.neo4j.dbms.routing.DefaultDatabaseAvailabilityChecker;
import org.neo4j.dbms.routing.DefaultRoutingService;
import org.neo4j.dbms.routing.LocalRoutingTableServiceValidator;
import org.neo4j.dbms.routing.RoutingOption;
import org.neo4j.dbms.routing.RoutingService;
import org.neo4j.dbms.routing.RoutingTableServiceValidator;
import org.neo4j.dbms.routing.RoutingTableTTLProvider;
import org.neo4j.dbms.routing.ServerSideRoutingTableProvider;
import org.neo4j.dbms.routing.SingleAddressRoutingTableProvider;
import org.neo4j.dbms.systemgraph.CommunityDefaultQueryLanguageLookup;
import org.neo4j.dbms.systemgraph.CommunityTopologyGraphComponent;
import org.neo4j.dbms.systemgraph.ContextBasedSystemDatabaseProvider;
import org.neo4j.dbms.systemgraph.SystemDatabaseProvider;
import org.neo4j.graphdb.event.TransactionEventListener;
import org.neo4j.graphdb.factory.module.GlobalModule;
import org.neo4j.graphdb.factory.module.edition.AbstractEditionModule;
import org.neo4j.internal.kernel.api.security.AbstractSecurityLog;
import org.neo4j.internal.kernel.api.security.CommunitySecurityLog;
import org.neo4j.io.device.DeviceMapper;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.kernel.api.net.NetworkConnectionTracker;
import org.neo4j.kernel.api.security.provider.NoAuthSecurityProvider;
import org.neo4j.kernel.api.security.provider.SecurityProvider;
import org.neo4j.kernel.database.DatabaseIdRepository;
import org.neo4j.kernel.database.DatabaseObjectRepositoryModelProvider;
import org.neo4j.kernel.database.DatabaseReferenceRepository;
import org.neo4j.kernel.database.DefaultDatabaseResolver;
import org.neo4j.kernel.database.MapCachingDatabaseIdRepository;
import org.neo4j.kernel.database.MapCachingDatabaseReferenceRepository;
import org.neo4j.kernel.database.ModelBasedDatabaseIdRepository;
import org.neo4j.kernel.database.ModelBasedDatabaseReferenceRepository;
import org.neo4j.kernel.database.NamedDatabaseId;
import org.neo4j.kernel.impl.api.TransactionalProcessFactory;
import org.neo4j.kernel.impl.factory.DbmsInfo;
import org.neo4j.kernel.impl.factory.DefaultTransactionalProcessFactory;
import org.neo4j.kernel.impl.pagecache.CommunityIOControllerService;
import org.neo4j.kernel.impl.pagecache.IOControllerService;
import org.neo4j.kernel.impl.security.URIAccessRules;
import org.neo4j.kernel.lifecycle.Lifecycle;
import org.neo4j.kernel.lifecycle.LifecycleAdapter;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.LogProvider;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.procedure.impl.ProcedureConfig;
import org.neo4j.router.CommunityQueryRouterBootstrap;
import org.neo4j.server.CommunityNeoWebServer;
import org.neo4j.server.config.AuthConfigProvider;
import org.neo4j.server.rest.repr.CommunityAuthConfigProvider;
import org.neo4j.server.security.auth.CommunitySecurityModule;
import org.neo4j.server.security.systemgraph.UserSecurityGraphComponent;
import org.neo4j.ssl.config.DefaultSslPolicyProvider;
import org.neo4j.time.SystemNanoClock;

public class CommunityEditionModule
extends AbstractEditionModule
implements DefaultDatabaseContextFactoryComponents {
    protected final GlobalModule globalModule;
    protected final ServerIdentity identityModule;
    private final DeviceMapper deviceMapper;
    private final InternalLogProvider logProvider;
    private final CommunitySecurityLog securityLog;
    protected DatabaseStateService databaseStateService;
    private MapCachingDatabaseReferenceRepository databaseReferenceRepo;
    private Lifecycle defaultDatabaseInitializer = new LifecycleAdapter();
    private SystemGraphComponents systemGraphComponents;

    public CommunityEditionModule(GlobalModule globalModule) {
        Dependencies globalDependencies = globalModule.getGlobalDependencies();
        Config globalConfig = globalModule.getGlobalConfig();
        LogService logService = globalModule.getLogService();
        this.globalModule = globalModule;
        DefaultSslPolicyProvider sslPolicyProvider = new DefaultSslPolicyProvider(globalModule.getFileSystem(), globalConfig, true, logService.getInternalLogProvider());
        globalDependencies.satisfyDependency((Object)sslPolicyProvider);
        globalDependencies.satisfyDependency((Object)new DatabaseOperationCounts.Counter());
        globalDependencies.satisfyDependency((Object)new DatabaseStateMonitor.Counter());
        globalDependencies.satisfyDependency((Object)this.createAuthConfigProvider(globalModule));
        this.logProvider = globalModule.getLogService().getInternalLogProvider();
        this.securityLog = new CommunitySecurityLog(this.logProvider.getLog(CommunitySecurityModule.class));
        globalDependencies.satisfyDependency((Object)new URIAccessRules((AbstractSecurityLog)this.securityLog, globalConfig));
        this.identityModule = CommunityEditionModule.tryResolveOrCreate(ServerIdentityFactory.class, globalModule.getExternalDependencyResolver(), DefaultIdentityModule::fromGlobalModule).create(globalModule);
        globalDependencies.satisfyDependency((Object)this.identityModule);
        this.deviceMapper = DeviceMapper.UNKNOWN_MAPPER;
        globalDependencies.satisfyDependency((Object)this.deviceMapper);
        this.connectionTracker = (NetworkConnectionTracker)globalDependencies.satisfyDependency((Object)CommunityEditionModule.createConnectionTracker());
    }

    public DatabaseContextProvider<?> createDatabaseContextProvider(GlobalModule globalModule) {
        DefaultDatabaseContextFactory databaseContextFactory = new DefaultDatabaseContextFactory(globalModule, this.identityModule, this.getTransactionMonitorFactory(), this.getIndexMonitorFactory(), CommunityEditionModule.createIdContextFactory(globalModule), this.deviceMapper, (IOControllerService)new CommunityIOControllerService(), this.createCommitProcessFactory(), this);
        MapCachingDatabaseIdRepository databaseIdRepo = new MapCachingDatabaseIdRepository();
        DatabaseRepository databaseRepository = new DatabaseRepository((DatabaseIdRepository)databaseIdRepo);
        ContextBasedSystemDatabaseProvider systemDatabaseProvider = new ContextBasedSystemDatabaseProvider((DatabaseContextProvider)databaseRepository, globalModule.getDatabaseEventListeners());
        CommunityDatabaseObjectRepositoryModelProvider modelProvider = new CommunityDatabaseObjectRepositoryModelProvider((SystemDatabaseProvider)systemDatabaseProvider);
        databaseIdRepo.setDelegate(AbstractEditionModule.tryResolveOrCreate(DatabaseIdRepository.class, globalModule.getExternalDependencyResolver(), () -> new ModelBasedDatabaseIdRepository((DatabaseObjectRepositoryModelProvider)modelProvider)));
        this.databaseReferenceRepo = (MapCachingDatabaseReferenceRepository)globalModule.getGlobalDependencies().satisfyDependency((Object)new MapCachingDatabaseReferenceRepository(AbstractEditionModule.tryResolveOrCreate(DatabaseReferenceRepository.class, globalModule.getExternalDependencyResolver(), () -> new ModelBasedDatabaseReferenceRepository((DatabaseObjectRepositoryModelProvider)modelProvider))));
        DatabaseReferenceCacheClearingListener databaseIdCacheCleaner = new DatabaseReferenceCacheClearingListener((DatabaseIdRepository.Caching)databaseIdRepo, (DatabaseReferenceRepository.Caching)this.databaseReferenceRepo);
        CommunityKernelPanicListener kernelPanicListener = new CommunityKernelPanicListener(globalModule.getDatabaseEventListeners(), (DatabaseContextProvider<StandaloneDatabaseContext>)databaseRepository);
        globalModule.getGlobalLife().add((Lifecycle)kernelPanicListener);
        DatabaseLifecycles databaseLifecycles = new DatabaseLifecycles((DatabaseRepository<StandaloneDatabaseContext>)databaseRepository, (String)globalModule.getGlobalConfig().get(GraphDatabaseSettings.initial_default_database), databaseContextFactory, (LogProvider)globalModule.getLogService().getInternalLogProvider(), globalModule.getExceptionHandlerService());
        this.databaseStateService = new CommunityDatabaseStateService((DatabaseContextProvider<StandaloneDatabaseContext>)databaseRepository);
        globalModule.getGlobalLife().add(databaseLifecycles.systemDatabaseStarter());
        globalModule.getGlobalLife().add(databaseLifecycles.allDatabaseShutdown());
        globalModule.getGlobalDependencies().satisfyDependency((Object)DatabaseContextProviderDelegate.delegate((DatabaseContextProvider)databaseRepository));
        globalModule.getGlobalDependencies().satisfyDependency((Object)this.databaseStateService);
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", (TransactionEventListener)databaseIdCacheCleaner);
        this.defaultDatabaseInitializer = databaseLifecycles.defaultDatabaseStarter();
        globalModule.getGlobalDependencies().satisfyDependency((Object)SystemGraphComponents.UpgradeChecker.UPGRADE_ALWAYS_ALLOWED);
        CommunityDefaultQueryLanguageLookup defaultQueryLanguage = new CommunityDefaultQueryLanguageLookup((SystemDatabaseProvider)systemDatabaseProvider, globalModule.getJobScheduler(), this.logProvider);
        globalModule.getGlobalDependencies().satisfyDependency((Object)defaultQueryLanguage);
        globalModule.getGlobalLife().add(defaultQueryLanguage.life());
        globalModule.getTransactionEventListeners().registerTransactionEventListener("system", defaultQueryLanguage.transactionListener());
        return databaseRepository;
    }

    @Override
    public Lifecycle createWebServer(DatabaseManagementService managementService, TransactionManager transactionManager, Dependencies globalDependencies, Config config, InternalLogProvider userLogProvider, DbmsInfo dbmsInfo) {
        return new CommunityNeoWebServer(managementService, transactionManager, globalDependencies, config, userLogProvider, dbmsInfo, this.globalModule.getMemoryPools(), this.globalModule.getGlobalMonitors(), this.globalModule.getGlobalClock());
    }

    @Override
    public TopologyInfoService createTopologyInfoService(DatabaseContextProvider<?> databaseContextProvider) {
        DefaultDatabaseDetailsExtrasProvider detailsExtrasProvider = new DefaultDatabaseDetailsExtrasProvider(databaseContextProvider);
        return new DefaultTopologyInfoService(this.identityModule.serverId(), this.globalModule.getGlobalConfig(), this.databaseStateService, this.globalReadOnlyChecker, detailsExtrasProvider);
    }

    @Override
    public RoutingService createRoutingService(DatabaseContextProvider<?> databaseContextProvider, ClientRoutingDomainChecker clientRoutingDomainChecker) {
        Config config = this.globalModule.getGlobalConfig();
        if (((Boolean)config.get(GraphDatabaseInternalSettings.use_new_routing_stack)).booleanValue()) {
            return new CommunityRoutingService(databaseContextProvider, this.defaultDatabaseResolver, this.globalModule.getConnectorPortRegister(), this.globalModule.getGlobalConfig());
        }
        LogService logService = this.globalModule.getLogService();
        ConnectorPortRegister portRegister = this.globalModule.getConnectorPortRegister();
        InternalLogProvider logProvider = this.globalModule.getLogService().getInternalLogProvider();
        DefaultDatabaseAvailabilityChecker databaseAvailabilityChecker = new DefaultDatabaseAvailabilityChecker(databaseContextProvider);
        LocalRoutingTableServiceValidator validator = new LocalRoutingTableServiceValidator((DatabaseAvailabilityChecker)databaseAvailabilityChecker);
        SingleAddressRoutingTableProvider routingTableProvider = new SingleAddressRoutingTableProvider(portRegister, RoutingOption.ROUTE_WRITE_AND_READ, config, logProvider, RoutingTableTTLProvider.ttlFromConfig((Config)config));
        return new DefaultRoutingService(logService.getInternalLogProvider(), (RoutingTableServiceValidator)validator, (ClientSideRoutingTableProvider)routingTableProvider, (ServerSideRoutingTableProvider)routingTableProvider, clientRoutingDomainChecker, config, () -> true, this.defaultDatabaseResolver, (DatabaseReferenceRepository)this.databaseReferenceRepo, true, (Clock)this.globalModule.getGlobalClock());
    }

    @Override
    public ProcedureConfig getProcedureConfig(Config config) {
        return new ProcedureConfig(config, false);
    }

    @Override
    protected AuthConfigProvider createAuthConfigProvider(GlobalModule globalModule) {
        return new CommunityAuthConfigProvider();
    }

    @Override
    public void registerDatabaseInitializers(GlobalModule globalModule, SystemDatabaseProvider systemDatabaseProvider) {
        this.registerSystemGraphInitializer(globalModule, systemDatabaseProvider);
        this.registerDefaultDatabaseInitializer(globalModule);
    }

    private void registerSystemGraphInitializer(GlobalModule globalModule, SystemDatabaseProvider systemDatabaseProvider) {
        SystemGraphInitializer initializer = AbstractEditionModule.tryResolveOrCreate(SystemGraphInitializer.class, globalModule.getExternalDependencyResolver(), () -> new DefaultSystemGraphInitializer(() -> ((SystemDatabaseProvider)systemDatabaseProvider).database(), this.systemGraphComponents));
        globalModule.getGlobalDependencies().satisfyDependency((Object)initializer);
        globalModule.getGlobalLife().add((Lifecycle)initializer);
    }

    protected void registerDefaultDatabaseInitializer(GlobalModule globalModule) {
        globalModule.getGlobalLife().add(this.defaultDatabaseInitializer);
    }

    @Override
    public void registerSystemGraphComponents(SystemGraphComponents.Builder systemGraphComponentsBuilder, GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        InternalLogProvider log = globalModule.getLogService().getInternalLogProvider();
        SystemNanoClock clock = globalModule.getGlobalClock();
        DefaultSystemGraphComponent systemGraphComponent = new DefaultSystemGraphComponent(config, (Clock)clock);
        CommunityTopologyGraphComponent communityTopologyGraphComponentComponent = new CommunityTopologyGraphComponent(config, log);
        systemGraphComponentsBuilder.register((SystemGraphComponent)systemGraphComponent);
        systemGraphComponentsBuilder.register((SystemGraphComponent)communityTopologyGraphComponentComponent);
        this.registerSecurityGraphComponent(systemGraphComponentsBuilder, globalModule);
        this.systemGraphComponents = systemGraphComponentsBuilder.build();
    }

    private void registerSecurityGraphComponent(SystemGraphComponents.Builder systemGraphComponentsBuilder, GlobalModule globalModule) {
        Config config = globalModule.getGlobalConfig();
        FileSystemAbstraction fileSystem = globalModule.getFileSystem();
        UserSecurityGraphComponent communityComponent = CommunitySecurityModule.createSecurityComponent((Config)config, (FileSystemAbstraction)fileSystem, (InternalLogProvider)this.logProvider, (AbstractSecurityLog)this.securityLog, (MemoryTracker)globalModule.getOtherMemoryPool().getPoolMemoryTracker());
        systemGraphComponentsBuilder.register((SystemGraphComponent)communityComponent);
        Dependencies dependencies = globalModule.getGlobalDependencies();
        dependencies.satisfyDependency((Object)communityComponent);
    }

    @Override
    public void createSecurityModule(GlobalModule globalModule, SystemDatabaseProvider systemDatabaseProvider) {
        this.setSecurityProvider(this.makeSecurityModule(globalModule));
    }

    private SecurityProvider makeSecurityModule(GlobalModule globalModule) {
        globalModule.getGlobalDependencies().satisfyDependency((Object)CommunitySecurityLog.NULL_LOG);
        if (((Boolean)globalModule.getGlobalConfig().get(GraphDatabaseSettings.auth_enabled)).booleanValue()) {
            CommunitySecurityModule securityModule = new CommunitySecurityModule(globalModule.getLogService(), globalModule.getGlobalConfig(), globalModule.getGlobalDependencies(), (AbstractSecurityLog)this.securityLog);
            securityModule.setup();
            return securityModule;
        }
        return NoAuthSecurityProvider.INSTANCE;
    }

    @Override
    public void createDefaultDatabaseResolver(SystemDatabaseProvider systemDatabaseProvider) {
        this.defaultDatabaseResolver = DefaultDatabaseResolver.constant((String)((String)this.globalModule.getGlobalConfig().get(GraphDatabaseSettings.initial_default_database)));
    }

    @Override
    public void createGlobalReadOnlyChecker(SystemDatabaseProvider systemDatabaseProvider, DatabaseIdRepository databaseIdRepository, GlobalModule globalModule) {
        this.globalReadOnlyChecker = CommunityEditionModule.createGlobalReadOnlyChecker(Set.of(SystemGraphReadOnlyDatabaseLookupFactory.DEFAULT_PROVIDER), systemDatabaseProvider, name -> databaseIdRepository.getByName(name).map(NamedDatabaseId::databaseId), ReadOnlyChangeListener.NO_OP, globalModule);
        globalModule.getGlobalLife().add((Lifecycle)new SystemGraphReadOnlyListener(globalModule.getTransactionEventListeners(), this.globalReadOnlyChecker));
        globalModule.getGlobalDependencies().satisfyDependency((Object)this.globalReadOnlyChecker);
    }

    @Override
    public BoltGraphDatabaseManagementServiceSPI createBoltDatabaseManagementServiceProvider() {
        return (BoltGraphDatabaseManagementServiceSPI)this.globalModule.getGlobalDependencies().resolveDependency(BoltGraphDatabaseManagementServiceSPI.class);
    }

    protected TransactionalProcessFactory createCommitProcessFactory() {
        return new DefaultTransactionalProcessFactory();
    }

    @Override
    public void bootstrapQueryRouterServices(DatabaseManagementService databaseManagementService) {
        DatabaseContextProvider databaseRepository = (DatabaseContextProvider)this.globalModule.getGlobalDependencies().resolveDependency(DatabaseContextProvider.class);
        CommunityQueryRouterBootstrap queryRouterBootstrap = new CommunityQueryRouterBootstrap(this.globalModule.getGlobalLife(), this.globalModule.getGlobalDependencies(), this.globalModule.getLogService(), databaseRepository, (DatabaseReferenceRepository)this.databaseReferenceRepo, (AbstractSecurityLog)CommunitySecurityLog.NULL_LOG);
        this.globalModule.getGlobalDependencies().satisfyDependency((Object)queryRouterBootstrap.bootstrapServices(databaseManagementService));
    }

    @Override
    public ReadOnlyDatabases readOnlyDatabases() {
        return this.globalReadOnlyChecker;
    }

    @Override
    public SystemGraphComponents getSystemGraphComponents() {
        return this.systemGraphComponents;
    }
}

