/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.io.Serializable;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.SystemUtils;
import org.eclipse.collections.api.block.predicate.Predicate;
import org.eclipse.collections.api.factory.Lists;
import org.eclipse.collections.api.list.MutableList;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.configuration.SettingValueParsers;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.fs.FileUtils;
import org.neo4j.kernel.info.JvmChecker;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.ExitCodeMessageMapper;
import org.neo4j.server.startup.MacBootloaderOs;
import org.neo4j.server.startup.ProcessManager;
import org.neo4j.server.startup.ProcessStages;
import org.neo4j.server.startup.UnixBootloaderOs;
import org.neo4j.server.startup.WindowsBootloaderOs;

abstract class BootloaderOsAbstraction {
    static final long UNKNOWN_PID = Long.MAX_VALUE;
    private static final int TEST_VERSION = Integer.getInteger("test.temp.vm.version", 21);
    protected final Bootloader bootloader;
    protected static final ExitCodeMessageMapper NEO4J_PROCESS_EXITCODE_MAPPER = exitCode -> (switch (exitCode) {
        case 1 -> "Neo4j web server failed to start.";
        case 2 -> "Neo4j server failed to start.";
        case 3 -> "Configuration is invalid.";
        case 4 -> "License agreement has not been accepted.";
        default -> "Unexpected Neo4j server failure.";
    }) + " See log for more info.";

    protected BootloaderOsAbstraction(Bootloader bootloader) {
        this.bootloader = bootloader;
    }

    abstract Optional<Long> getPidIfRunning();

    abstract boolean isRunning(long var1);

    abstract long start() throws CommandFailedException;

    abstract void stop(long var1) throws CommandFailedException;

    long console() throws CommandFailedException {
        return this.bootloader.processManager().run(this.buildStandardStartArguments(), new ConsoleProcess(true));
    }

    long admin() throws CommandFailedException {
        MutableList arguments = this.buildBaseArguments();
        if (this.bootloader.getEnv("HEAP_SIZE").isBlank()) {
            arguments = arguments.reject((Predicate & Serializable)argument -> argument.startsWith("-Xms"));
        }
        return this.bootloader.processManager().run((List<String>)arguments.withAll(this.bootloader.additionalArgs), new AdminProcess());
    }

    abstract void installService() throws CommandFailedException;

    abstract void uninstallService() throws CommandFailedException;

    abstract void updateService() throws CommandFailedException;

    abstract boolean serviceInstalled();

    protected List<String> buildStandardStartArguments() {
        return this.buildBaseArguments().with((Object)("--home-dir=" + String.valueOf(this.bootloader.home()))).with((Object)("--config-dir=" + String.valueOf(this.bootloader.confDir()))).withAll(this.bootloader.additionalArgs);
    }

    private MutableList<String> buildBaseArguments() {
        return Lists.mutable.with((Object[])new String[]{this.getJavaCmd()}).with((Object)"-cp").with((Object)this.getClassPath()).withAll(this.getJvmOpts()).with((Object)this.bootloader.entrypoint.getName());
    }

    static BootloaderOsAbstraction getOsAbstraction(Bootloader context) {
        return SystemUtils.IS_OS_WINDOWS ? new WindowsBootloaderOs(context) : (SystemUtils.IS_OS_MAC_OSX ? new MacBootloaderOs(context) : new UnixBootloaderOs(context));
    }

    protected String getJavaCmd() {
        Path java = BootloaderOsAbstraction.getJava();
        this.checkJavaVersion();
        return java.toString();
    }

    private void printBadRuntime() {
        PrintStream err = this.bootloader.environment.err();
        err.println("WARNING! You are using an unsupported Java runtime.");
        err.println("* Please use Java(TM) 21 to run Neo4j.");
        err.println("* Please see https://neo4j.com/docs/ for Neo4j installation instructions.");
    }

    private static Path getJava() {
        Optional<String> currentCommand = ProcessHandle.current().info().command();
        return Path.of(currentCommand.orElseThrow(() -> new IllegalStateException("Wasn't able to figure out java binary")), new String[0]);
    }

    private void checkJavaVersion() {
        int version = this.bootloader.environment.version().feature();
        if (version != 21 && version != TEST_VERSION) {
            this.printBadRuntime();
        } else {
            String runtime = this.bootloader.getProp("java.vm.name");
            if (!JvmChecker.SUPPORTED_JAVA_NAME_PATTERN.matcher(runtime).matches()) {
                this.printBadRuntime();
            }
        }
    }

    private static String bytesToSuitableJvmString(long bytes) {
        return Math.max(bytes / ByteUnit.kibiBytes((long)1L), 1L) + "k";
    }

    protected List<String> getJvmOpts() {
        String envJavaOptions = this.bootloader.getEnv("JAVA_OPTS");
        if (StringUtils.isNotEmpty((CharSequence)envJavaOptions)) {
            if (StringUtils.isNotEmpty((CharSequence)this.bootloader.getEnv("HEAP_SIZE"))) {
                this.bootloader.environment.err().println("WARNING! HEAP_SIZE is ignored, because JAVA_OPTS is set");
            }
            return List.of(((String)SettingValueParsers.JVM_ADDITIONAL.parse(envJavaOptions)).split(System.lineSeparator()));
        }
        return this.buildJvmOpts();
    }

    private List<String> buildJvmOpts() {
        MutableList opts = Lists.mutable.empty();
        Bootloader.FilteredConfig config = this.bootloader.config();
        String jvmAdditionals = (String)config.get(BootloaderSettings.additional_jvm);
        if (StringUtils.isNotEmpty((CharSequence)jvmAdditionals)) {
            opts.withAll(List.of(jvmAdditionals.split(System.lineSeparator())));
        }
        if (((Boolean)config.get(BootloaderSettings.gc_logging_enabled)).booleanValue()) {
            opts.with((Object)String.format("%s:file=%s::filecount=%s,filesize=%s", config.get(BootloaderSettings.gc_logging_options), ((Path)config.get(GraphDatabaseSettings.logs_directory)).resolve("gc.log"), config.get(BootloaderSettings.gc_logging_rotation_keep_number), BootloaderOsAbstraction.bytesToSuitableJvmString((Long)config.get(BootloaderSettings.gc_logging_rotation_size))));
        }
        opts.with((Object)"-Dfile.encoding=UTF-8");
        this.selectHeapSettings((MutableList<String>)opts);
        return opts;
    }

    private void selectHeapSettings(MutableList<String> opts) {
        Long xmxConfigValue;
        String xmxValue;
        String xmsValue;
        String envHeapSize = this.bootloader.getEnv("HEAP_SIZE");
        if (StringUtils.isNotEmpty((CharSequence)envHeapSize)) {
            opts.with((Object)("-Xms" + envHeapSize)).with((Object)("-Xmx" + envHeapSize));
            return;
        }
        Bootloader.FilteredConfig config = this.bootloader.config();
        Long xmsConfigValue = (Long)config.get(BootloaderSettings.initial_heap_size);
        String string = xmsValue = xmsConfigValue != null ? BootloaderOsAbstraction.bytesToSuitableJvmString(xmsConfigValue) : null;
        if (xmsValue != null) {
            opts.with((Object)("-Xms" + xmsValue));
        }
        String string2 = xmxValue = (xmxConfigValue = (Long)config.get(BootloaderSettings.max_heap_size)) != null ? BootloaderOsAbstraction.bytesToSuitableJvmString(xmxConfigValue) : null;
        if (xmxValue != null) {
            opts.with((Object)("-Xmx" + xmxValue));
        }
    }

    protected String getClassPath() {
        String libCp = BootloaderOsAbstraction.classPathFromDir((Path)this.bootloader.config().get(BootloaderSettings.lib_directory));
        MutableList paths = Lists.mutable.with((Object[])new String[]{BootloaderOsAbstraction.classPathFromDir((Path)this.bootloader.config().get(GraphDatabaseSettings.plugin_dir)), BootloaderOsAbstraction.classPathFromDir(this.bootloader.confDir()), StringUtils.isNotBlank((CharSequence)libCp) ? libCp : this.bootloader.getProp("java.class.path")});
        return paths.stream().filter(StringUtils::isNotBlank).collect(Collectors.joining(File.pathSeparator));
    }

    private static String classPathFromDir(Path dir) {
        try {
            if (Files.isDirectory(dir, new LinkOption[0]) && !FileUtils.isDirectoryEmpty((Path)dir)) {
                return String.valueOf(dir.toAbsolutePath()) + File.separator + "*";
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    static class ConsoleProcess
    implements ProcessStages {
        private final boolean installShutdownHooksForParentProcess;

        ConsoleProcess(boolean installShutdownHooksForParentProcess) {
            this.installShutdownHooksForParentProcess = installShutdownHooksForParentProcess;
        }

        @Override
        public void preStart(ProcessManager processManager, ProcessBuilder processBuilder) {
            processBuilder.inheritIO();
        }

        @Override
        public void postStart(ProcessManager processManager, Process process) throws Exception {
            if (this.installShutdownHooksForParentProcess) {
                processManager.installShutdownHook(process);
            }
            processManager.waitUntilSuccessful(process, NEO4J_PROCESS_EXITCODE_MAPPER);
        }
    }

    private static class AdminProcess
    implements ProcessStages {
        private AdminProcess() {
        }

        @Override
        public void preStart(ProcessManager processManager, ProcessBuilder processBuilder) {
            processManager.addHomeAndConf(processBuilder);
            processBuilder.inheritIO();
        }

        @Override
        public void postStart(ProcessManager processManager, Process process) throws Exception {
            processManager.waitUntilSuccessful(process, e -> "Admin command failed to start. See output for more info.");
        }
    }
}

