/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import java.io.IOException;
import java.nio.file.AccessDeniedException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.neo4j.cli.CommandFailedException;
import org.neo4j.configuration.BootloaderSettings;
import org.neo4j.server.startup.BootProcessFailureException;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.ExitCodeMessageMapper;
import org.neo4j.server.startup.PidFileHelper;
import org.neo4j.server.startup.ProcessStages;
import sun.misc.Signal;

class ProcessManager {
    private final Bootloader bootloader;

    ProcessManager(Bootloader bootloader) {
        this.bootloader = bootloader;
    }

    long run(List<String> command, ProcessStages processStages) throws CommandFailedException {
        ProcessBuilder processBuilder = new ProcessBuilder(command);
        processStages.preStart(this, processBuilder);
        Process process = null;
        try {
            if (this.bootloader.verbose) {
                this.bootloader.environment.out().println("Executing command line: " + String.join((CharSequence)" ", command));
            }
            process = processBuilder.start();
            processStages.postStart(this, process);
            return process.pid();
        }
        catch (CommandFailedException e) {
            throw e;
        }
        catch (Exception e) {
            if (process != null && process.isAlive()) {
                process.destroy();
            }
            throw new CommandFailedException("Unexpected error while starting. Aborting. " + e.getClass().getSimpleName() + " : " + e.getMessage(), (Throwable)e);
        }
    }

    void addHomeAndConf(ProcessBuilder processBuilder) {
        Map<String, String> env = processBuilder.environment();
        env.putIfAbsent("NEO4J_HOME", this.bootloader.home().toString());
        env.putIfAbsent("NEO4J_CONF", this.bootloader.confDir().toString());
    }

    void waitUntilSuccessful(Process process, ExitCodeMessageMapper exitCodeMessageMapper) throws InterruptedException {
        if (process.waitFor() != 0) {
            int code = process.exitValue();
            throw new BootProcessFailureException(exitCodeMessageMapper.map(code), code);
        }
    }

    void installShutdownHook(Process finalProcess) {
        Runtime.getRuntime().addShutdownHook(new Thread(() -> this.killProcess(finalProcess)));
        Runnable onSignal = () -> System.exit(this.killProcess(finalProcess));
        ProcessManager.installSignal("INT", onSignal);
        ProcessManager.installSignal("TERM", onSignal);
    }

    private static void installSignal(String signal, Runnable onExit) {
        try {
            Signal.handle(new Signal(signal), s -> onExit.run());
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private synchronized int killProcess(Process finalProcess) {
        if (finalProcess.isAlive()) {
            finalProcess.destroy();
            while (finalProcess.isAlive()) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
            }
        }
        this.deletePid();
        return finalProcess.exitValue();
    }

    Long getPidFromFile() {
        Path pidFile = this.pidFile();
        try {
            return PidFileHelper.readPid(pidFile);
        }
        catch (AccessDeniedException e) {
            throw new CommandFailedException("Access denied reading pid file " + String.valueOf(pidFile), 1);
        }
        catch (IOException e) {
            throw new CommandFailedException("Unexpected error reading pid file " + String.valueOf(pidFile), (Throwable)e, 1);
        }
    }

    Optional<ProcessHandle> getProcessHandle(long pid) throws CommandFailedException {
        Optional<ProcessHandle> handleOption = ProcessHandle.of(pid);
        if (handleOption.isEmpty() || !handleOption.get().isAlive()) {
            this.deletePid();
            return Optional.empty();
        }
        return handleOption;
    }

    private void deletePid() {
        PidFileHelper.remove(this.pidFile());
    }

    void storePid(long pid, boolean throwOnFailure) throws IOException {
        Path pidFilePath = this.pidFile();
        try {
            PidFileHelper.storePid(this.pidFile(), pid);
        }
        catch (AccessDeniedException exception) {
            if (throwOnFailure) {
                throw exception;
            }
            this.bootloader.environment.err().printf("Failed to write PID file: Access denied at %s%n", pidFilePath.toAbsolutePath());
        }
    }

    private Path pidFile() {
        return (Path)this.bootloader.config().get(BootloaderSettings.pid_file);
    }
}

