/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.EnhancedExecutionContext;
import picocli.CommandLine;

@CommandLine.Command(name="stop", description={"Stop the server daemon."})
public class StopCommand
extends AbstractCommand {
    @CommandLine.Option(names={"--shutdown-timeout"}, paramLabel="<seconds>", description={"A time interval in seconds for how long the command will wait for the DBMS process to stop. The default is 120 seconds. The interval can also be configured using NEO4J_SHUTDOWN_TIMEOUT environment variable. If both are present, this option has higher priority than the environment variable."})
    private Integer timeout;

    public StopCommand(ExecutionContext ctx) {
        super(ctx);
    }

    protected void execute() throws Exception {
        EnhancedExecutionContext enhancedCtx = EnhancedExecutionContext.unwrapFromExecutionContext(this.ctx);
        try (Bootloader.Dbms bootloader = enhancedCtx.createDbmsBootloader();){
            bootloader.stop(this.timeout);
        }
    }
}

