/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup;

import org.neo4j.cli.AbstractCommand;
import org.neo4j.cli.ExecutionContext;
import org.neo4j.server.startup.Bootloader;
import org.neo4j.server.startup.EnhancedExecutionContext;
import picocli.CommandLine;

@CommandLine.Command(name="windows-service", description={"Neo4j windows service commands."}, subcommands={Install.class, Update.class, Uninstall.class, CommandLine.HelpCommand.class})
public class WindowsServiceCommand {
    @CommandLine.Option(names={"-h", "--help"}, usageHelp=true, fallbackValue="true", description={"Show this help message and exit."})
    private boolean helpRequested;

    @CommandLine.Command(name="update", description={"Update the Windows service."})
    public static class Update
    extends AbstractCommand {
        public Update(ExecutionContext ctx) {
            super(ctx);
        }

        protected void execute() throws Exception {
            EnhancedExecutionContext enhancedCtx = EnhancedExecutionContext.unwrapFromExecutionContext(this.ctx);
            try (Bootloader.Dbms bootloader = enhancedCtx.createDbmsBootloader();){
                bootloader.updateService();
            }
        }
    }

    @CommandLine.Command(name="uninstall", description={"Uninstall the Windows service."})
    public static class Uninstall
    extends AbstractCommand {
        public Uninstall(ExecutionContext ctx) {
            super(ctx);
        }

        protected void execute() throws Exception {
            EnhancedExecutionContext enhancedCtx = EnhancedExecutionContext.unwrapFromExecutionContext(this.ctx);
            try (Bootloader.Dbms bootloader = enhancedCtx.createDbmsBootloader();){
                bootloader.uninstallService();
            }
        }
    }

    @CommandLine.Command(name="install", description={"Install the Windows service."})
    public static class Install
    extends AbstractCommand {
        public Install(ExecutionContext ctx) {
            super(ctx);
        }

        protected void execute() throws Exception {
            EnhancedExecutionContext enhancedCtx = EnhancedExecutionContext.unwrapFromExecutionContext(this.ctx);
            try (Bootloader.Dbms bootloader = enhancedCtx.createDbmsBootloader();){
                bootloader.installService();
            }
        }
    }
}

