/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.server.startup.validation;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ObjectUtils;
import org.neo4j.logging.Log;
import org.neo4j.server.startup.validation.ConfigValidationIssue;
import org.neo4j.util.VisibleForTesting;

public class ConfigValidationSummary {
    private ValidationResult result = ValidationResult.OK;
    private final List<Event> events = new ArrayList<Event>();

    public void print(PrintStream out, boolean verbose) {
        for (Event event : this.events) {
            event.print(out, verbose);
            out.println();
        }
    }

    public String message(boolean verbose) {
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        this.print(new PrintStream(output), verbose);
        return output.toString();
    }

    public ValidationResult result() {
        return this.result;
    }

    public void add(Event event) {
        this.result = this.result.and(event.result());
        this.events.add(event);
    }

    public void printClosingStatement(PrintStream out) {
        out.println(this.closingStatement());
    }

    public String closingStatement() {
        if (this.result == ValidationResult.ERRORS) {
            return "Configuration file validation failed.";
        }
        if (this.result == ValidationResult.WARNINGS) {
            return "Configuration file validation successful (with warnings).";
        }
        return "Configuration file validation successful.";
    }

    public void log(Log log) {
        for (Event event : this.events) {
            event.log(log);
        }
    }

    public static enum ValidationResult {
        OK,
        WARNINGS,
        ERRORS;


        @VisibleForTesting
        ValidationResult and(ValidationResult other) {
            return (ValidationResult)((Object)ObjectUtils.max((Comparable[])new ValidationResult[]{this, other}));
        }
    }

    public static interface Event {
        public void print(PrintStream var1, boolean var2);

        public ValidationResult result();

        default public Event treatErrorsAsWarnings() {
            return new NoBigDealEvent(this);
        }

        public void log(Log var1);
    }

    public static class MessageEvent
    implements Event {
        private final String message;

        public MessageEvent(String message) {
            this.message = message;
        }

        @Override
        public void print(PrintStream out, boolean verbose) {
            out.println(this.message);
        }

        @Override
        public ValidationResult result() {
            return ValidationResult.OK;
        }

        @Override
        public void log(Log log) {
        }
    }

    public static class ErrorEvent
    implements Event {
        private final String label;
        private final Exception exception;

        public ErrorEvent(String label, Exception exception) {
            this.label = label;
            this.exception = exception;
        }

        @Override
        public void print(PrintStream out, boolean verbose) {
            out.printf("Error when validating %s: %s%n", this.label, this.exception.getMessage());
            if (verbose) {
                this.exception.printStackTrace(out);
            }
        }

        @Override
        public ValidationResult result() {
            return ValidationResult.ERRORS;
        }

        private String message() {
            return String.format("Error when validating %s: %s", this.label, this.exception.getMessage());
        }

        @Override
        public void log(Log log) {
            log.error(this.message());
        }
    }

    public static class ResultEvent
    implements Event {
        private final List<ConfigValidationIssue> issues;
        private final String label;
        private ValidationResult result;

        public ResultEvent(String label, List<ConfigValidationIssue> issues) {
            this.label = label;
            this.issues = issues;
            this.result = ValidationResult.OK;
            for (ConfigValidationIssue issue : issues) {
                this.result = this.result.and(issue.isError() ? ValidationResult.ERRORS : ValidationResult.WARNINGS);
            }
        }

        @Override
        public void print(PrintStream out, boolean verbose) {
            out.printf("Validating %s%n", this.label);
            this.printIssueCount(this.issues, out);
            for (ConfigValidationIssue issue : this.issues) {
                this.printIssue(issue, out, verbose);
            }
        }

        private void printIssueCount(List<ConfigValidationIssue> issues, PrintStream out) {
            if (issues.isEmpty()) {
                out.printf("No issues found.%n", new Object[0]);
            } else {
                out.printf("%d issue%s found.%n", issues.size(), issues.size() == 1 ? "" : "s");
            }
        }

        private void printIssue(ConfigValidationIssue issue, PrintStream out, boolean verbose) {
            out.printf("%s%n", issue.getMessage());
            if (verbose) {
                issue.printStackTrace(out);
            }
        }

        @Override
        public ValidationResult result() {
            return this.result;
        }

        @Override
        public ResultEvent treatErrorsAsWarnings() {
            List<ConfigValidationIssue> issues = this.issues.stream().map(ConfigValidationIssue::asWarning).collect(Collectors.toList());
            return new ResultEvent(this.label, issues);
        }

        @Override
        public void log(Log log) {
            for (ConfigValidationIssue issue : this.issues) {
                if (issue.isError()) {
                    log.error(issue.getLogMessage());
                    continue;
                }
                log.warn(issue.getLogMessage());
            }
        }
    }

    private record NoBigDealEvent(Event delegate) implements Event
    {
        @Override
        public void print(PrintStream out, boolean verbose) {
            this.delegate.print(out, verbose);
        }

        @Override
        public ValidationResult result() {
            ValidationResult actualResult = this.delegate.result();
            if (actualResult == ValidationResult.ERRORS) {
                return ValidationResult.WARNINGS;
            }
            return actualResult;
        }

        @Override
        public Event treatErrorsAsWarnings() {
            return this;
        }

        @Override
        public void log(Log log) {
            this.delegate.log(new NoBigDealLog(log));
        }

        private record NoBigDealLog(Log delegate) implements Log
        {
            public boolean isDebugEnabled() {
                return this.delegate.isDebugEnabled();
            }

            public void debug(String message) {
                this.delegate.debug(message);
            }

            public void debug(String message, Throwable throwable) {
                this.delegate.debug(message, throwable);
            }

            public void debug(String format, Object ... arguments) {
                this.delegate.debug(format, arguments);
            }

            public void info(String message) {
                this.delegate.info(message);
            }

            public void info(String message, Throwable throwable) {
                this.delegate.info(message, throwable);
            }

            public void info(String format, Object ... arguments) {
                this.delegate.info(format, arguments);
            }

            public void warn(String message) {
                this.delegate.warn(message);
            }

            public void warn(String message, Throwable throwable) {
                this.delegate.warn(message, throwable);
            }

            public void warn(String format, Object ... arguments) {
                this.delegate.warn(format, arguments);
            }

            public void error(String message) {
                this.delegate.warn(message);
            }

            public void error(String message, Throwable throwable) {
                this.delegate.warn(message, throwable);
            }

            public void error(String format, Object ... arguments) {
                this.delegate.warn(format, arguments);
            }
        }
    }
}

