/*
 * Decompiled with CFR 0.152.
 */
package blue.strategic.parquet;

import blue.strategic.parquet.Dehydrator;
import blue.strategic.parquet.ValueWriter;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Collections;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.io.DelegatingPositionOutputStream;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.RecordConsumer;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;

public final class ParquetWriter<T>
implements Closeable {
    private final org.apache.parquet.hadoop.ParquetWriter<T> writer;

    public static <T> ParquetWriter<T> writeFile(MessageType schema, final File out, Dehydrator<T> dehydrator) throws IOException {
        OutputFile f = new OutputFile(){

            public PositionOutputStream create(long blockSizeHint) throws IOException {
                return this.createOrOverwrite(blockSizeHint);
            }

            public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
                final FileOutputStream fos = new FileOutputStream(out);
                return new DelegatingPositionOutputStream(fos){

                    public long getPos() throws IOException {
                        return fos.getChannel().position();
                    }
                };
            }

            public boolean supportsBlockSize() {
                return false;
            }

            public long defaultBlockSize() {
                return 1024L;
            }
        };
        return ParquetWriter.writeOutputFile(schema, f, dehydrator);
    }

    private static <T> ParquetWriter<T> writeOutputFile(MessageType schema, OutputFile file, Dehydrator<T> dehydrator) throws IOException {
        return new ParquetWriter<T>(file, schema, dehydrator);
    }

    private ParquetWriter(OutputFile outputFile, MessageType schema, Dehydrator<T> dehydrator) throws IOException {
        this.writer = ((Builder)((Builder)new Builder(outputFile).withType(schema).withDehydrator(dehydrator).withCompressionCodec(CompressionCodecName.SNAPPY)).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_2_0)).build();
    }

    public void write(T record) throws IOException {
        this.writer.write(record);
    }

    @Override
    public void close() throws IOException {
        this.writer.close();
    }

    private static final class Builder<T>
    extends ParquetWriter.Builder<T, Builder<T>> {
        private MessageType schema;
        private Dehydrator<T> dehydrator;

        private Builder(OutputFile file) {
            super(file);
        }

        public Builder<T> withType(MessageType schema) {
            this.schema = schema;
            return this;
        }

        public Builder<T> withDehydrator(Dehydrator<T> dehydrator) {
            this.dehydrator = dehydrator;
            return this;
        }

        protected Builder<T> self() {
            return this;
        }

        protected WriteSupport<T> getWriteSupport(Configuration conf) {
            return new SimpleWriteSupport<T>(this.schema, this.dehydrator);
        }
    }

    private static class SimpleWriteSupport<T>
    extends WriteSupport<T> {
        private final MessageType schema;
        private final Dehydrator<T> dehydrator;
        private final ValueWriter valueWriter = this::writeField;
        private RecordConsumer recordConsumer;

        SimpleWriteSupport(MessageType schema, Dehydrator<T> dehydrator) {
            this.schema = schema;
            this.dehydrator = dehydrator;
        }

        public WriteSupport.WriteContext init(Configuration configuration) {
            return new WriteSupport.WriteContext(this.schema, Collections.emptyMap());
        }

        public void prepareForWrite(RecordConsumer recordConsumer) {
            this.recordConsumer = recordConsumer;
        }

        public void write(T record) {
            this.recordConsumer.startMessage();
            this.dehydrator.dehydrate(record, this.valueWriter);
            this.recordConsumer.endMessage();
        }

        public String getName() {
            return "blue.strategic.parquet.ParquetWriter";
        }

        private void writeField(String name, Object value) {
            int fieldIndex = this.schema.getFieldIndex(name);
            PrimitiveType type = this.schema.getType(fieldIndex).asPrimitiveType();
            this.recordConsumer.startField(name, fieldIndex);
            switch (type.getPrimitiveTypeName()) {
                case INT32: {
                    this.recordConsumer.addInteger(((Integer)value).intValue());
                    break;
                }
                case INT64: {
                    this.recordConsumer.addLong(((Long)value).longValue());
                    break;
                }
                case DOUBLE: {
                    this.recordConsumer.addDouble(((Double)value).doubleValue());
                    break;
                }
                case BOOLEAN: {
                    this.recordConsumer.addBoolean(((Boolean)value).booleanValue());
                    break;
                }
                case FLOAT: {
                    this.recordConsumer.addFloat(((Float)value).floatValue());
                    break;
                }
                case BINARY: {
                    if (type.getLogicalTypeAnnotation() == LogicalTypeAnnotation.stringType()) {
                        this.recordConsumer.addBinary(Binary.fromString((String)((String)value)));
                        break;
                    }
                    throw new UnsupportedOperationException("We don't support writing " + String.valueOf(type.getLogicalTypeAnnotation()));
                }
                default: {
                    throw new UnsupportedOperationException("We don't support writing " + String.valueOf(type.getPrimitiveTypeName()));
                }
            }
            this.recordConsumer.endField(name, fieldIndex);
        }
    }
}

