/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.IndexChecker;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeIndexChecker
extends IndexChecker<NodeRecord> {
    NodeIndexChecker(CheckerContext context) {
        super(context, EntityType.NODE, "Node");
    }

    @Override
    CommonAbstractStore<NodeRecord, ?> store() {
        return this.context.neoStores.getNodeStore();
    }

    @Override
    long highId() {
        return this.context.highNodeId;
    }

    @Override
    NodeRecord getEntity(StoreCursors storeCursors, long entityId) {
        return this.context.recordLoader.node(entityId, storeCursors, this.context.memoryTracker);
    }

    @Override
    int[] getEntityTokens(CheckerContext context, StoreCursors storeCursors, NodeRecord record, RecordReader<DynamicRecord> additionalReader) {
        return RecordLoading.safeGetNodeLabels(context, storeCursors, record.getId(), record.getLabelField(), additionalReader, context.memoryTracker);
    }

    @Override
    RecordReader<DynamicRecord> additionalEntityTokenReader(CursorContext cursorContext) {
        return new RecordReader<DynamicRecord>(this.context.neoStores.getNodeStore().getDynamicLabelStore(), false, cursorContext, this.context.memoryTracker);
    }

    @Override
    void reportEntityNotInUse(ConsistencyReport.IndexConsistencyReport report, NodeRecord record) {
        report.nodeNotInUse(record);
    }

    @Override
    void reportIndexedIncorrectValues(ConsistencyReport.IndexConsistencyReport report, NodeRecord record, Object[] propertyValues) {
        report.nodeIndexedWithWrongValues(record, propertyValues);
    }

    @Override
    void reportIndexedWhenShouldNot(ConsistencyReport.IndexConsistencyReport report, NodeRecord record) {
        report.nodeIndexedWhenShouldNot(record);
    }

    @Override
    ConsistencyReport.PrimitiveConsistencyReport getReport(NodeRecord cursor, ConsistencyReport.Reporter reporter) {
        return reporter.forNode(cursor);
    }
}

