/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.lang.reflect.InvocationHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.annotations.documented.ReporterFactory;
import org.neo4j.common.TokenNameLookup;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseInternalSettings;
import org.neo4j.consistency.RecordType;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.CountsState;
import org.neo4j.consistency.checker.EntityBasedMemoryLimiter;
import org.neo4j.consistency.checker.NodeChecker;
import org.neo4j.consistency.checker.NodeIndexChecker;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RelationshipChainChecker;
import org.neo4j.consistency.checker.RelationshipChecker;
import org.neo4j.consistency.checker.RelationshipGroupChecker;
import org.neo4j.consistency.checker.RelationshipIndexChecker;
import org.neo4j.consistency.checker.SchemaChecker;
import org.neo4j.consistency.checking.ConsistencyCheckIncompleteException;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.checking.cache.DefaultCacheAccess;
import org.neo4j.consistency.checking.index.IndexAccessors;
import org.neo4j.consistency.checking.index.IndexDescriptorProvider;
import org.neo4j.consistency.report.ConsistencyReporter;
import org.neo4j.consistency.report.ConsistencySummaryStatistics;
import org.neo4j.consistency.report.InconsistencyMessageLogger;
import org.neo4j.consistency.report.InconsistencyReport;
import org.neo4j.counts.CountsStore;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.counts.CountsVisitor;
import org.neo4j.graphdb.ResourceIterator;
import org.neo4j.graphdb.config.Setting;
import org.neo4j.index.internal.gbptree.RecoveryCleanupWorkCollector;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.counts.CountsStoreProvider;
import org.neo4j.internal.counts.DegreeStoreProvider;
import org.neo4j.internal.counts.DegreeUpdater;
import org.neo4j.internal.counts.DegreesRebuilder;
import org.neo4j.internal.counts.RelationshipGroupDegreesStore;
import org.neo4j.internal.helpers.collection.Iterators;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.recordstorage.RecordStorageIndexingBehaviour;
import org.neo4j.internal.recordstorage.SchemaRuleAccess;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.StorageEngineIndexingBehaviour;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.PageCache;
import org.neo4j.io.pagecache.PageCacheOpenOptions;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.impl.muninn.VersionStorage;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.api.index.IndexAccessor;
import org.neo4j.kernel.database.DatabaseIdFactory;
import org.neo4j.kernel.impl.api.index.IndexProviderMap;
import org.neo4j.kernel.impl.api.index.IndexSamplingConfig;
import org.neo4j.kernel.impl.index.schema.ConsistencyCheckable;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;
import org.neo4j.logging.NullLogProvider;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.CreatingTokenHolder;
import org.neo4j.token.ReadOnlyTokenCreator;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.DefaultElementIdMapperV1;
import org.neo4j.values.ElementIdMapper;

public class RecordStorageConsistencyChecker
implements AutoCloseable {
    private static final String COUNT_STORE_CONSISTENCY_CHECKER_TAG = "countStoreConsistencyChecker";
    private static final String SCHEMA_CONSISTENCY_CHECKER_TAG = "schemaConsistencyChecker";
    private static final String CONSISTENCY_CHECKER_TOKEN_LOADER_TAG = "consistencyCheckerTokenLoader";
    static final int[] DEFAULT_SLOT_SIZES = new int[]{40, 40, 1, 1, 1, 1, 1, 1};
    private final FileSystemAbstraction fileSystem;
    private final RecordDatabaseLayout databaseLayout;
    private final PageCache pageCache;
    private final NeoStores neoStores;
    private final IdGeneratorFactory idGeneratorFactory;
    private final ConsistencySummaryStatistics summary;
    private final ProgressMonitorFactory progressFactory;
    private final ConsistencyFlags consistencyFlags;
    private final CursorContextFactory contextFactory;
    private final PageCacheTracer cacheTracer;
    private final long lastCommittedTxId;
    private final CacheAccess cacheAccess;
    private final ConsistencyReporter reporter;
    private final CountsState observedCounts;
    private final EntityBasedMemoryLimiter limiter;
    private final CheckerContext context;
    private final ProgressMonitorFactory.MultiPartBuilder progress;
    private final IndexAccessors indexAccessors;
    private final InconsistencyReport report;
    private final ByteArray cacheAccessMemory;

    public RecordStorageConsistencyChecker(FileSystemAbstraction fileSystem, RecordDatabaseLayout databaseLayout, PageCache pageCache, NeoStores neoStores, IndexProviderMap indexProviders, IdGeneratorFactory idGeneratorFactory, ConsistencySummaryStatistics summary, ProgressMonitorFactory progressFactory, Config config, int numberOfThreads, InternalLog reportLog, InternalLog verboseLog, boolean verbose, ConsistencyFlags consistencyFlags, EntityBasedMemoryLimiter.Factory memoryLimit, MemoryTracker memoryTracker, CursorContextFactory contextFactory, PageCacheTracer cacheTracer, long lastCommittedTxId) {
        this.fileSystem = fileSystem;
        this.databaseLayout = databaseLayout;
        this.pageCache = pageCache;
        this.neoStores = neoStores;
        this.idGeneratorFactory = idGeneratorFactory;
        this.summary = summary;
        this.progressFactory = progressFactory;
        this.consistencyFlags = consistencyFlags;
        this.contextFactory = contextFactory;
        this.cacheTracer = cacheTracer;
        this.lastCommittedTxId = lastCommittedTxId;
        int stopCountThreshold = (Integer)config.get(GraphDatabaseInternalSettings.consistency_checker_fail_fast_threshold);
        AtomicInteger stopCount = new AtomicInteger(0);
        ConsistencyReporter.Monitor monitor = ConsistencyReporter.NO_MONITOR;
        if (stopCountThreshold > 0) {
            monitor = (ignoredArg1, ignoredArg2, ignoredArg3, isError) -> {
                if (isError && !this.isCancelled() && stopCount.incrementAndGet() >= stopCountThreshold) {
                    this.cancel("Observed " + stopCount.get() + " inconsistencies.");
                }
            };
        }
        TokenHolders tokenHolders = RecordStorageConsistencyChecker.safeLoadTokens(neoStores, contextFactory, memoryTracker);
        ElementIdMapper elementIdMapper = RecordStorageConsistencyChecker.makeElementIdMapper(neoStores, (DatabaseLayout)databaseLayout, contextFactory);
        this.report = new InconsistencyReport(new InconsistencyMessageLogger(reportLog, SchemaChecker.moreDescriptiveRecordToStrings(neoStores, tokenHolders, memoryTracker)), summary);
        this.reporter = new ConsistencyReporter(this.report, monitor);
        ParallelExecution execution = new ParallelExecution(numberOfThreads, exception -> this.cancel("Unexpected exception"), 1000000);
        RecordLoading recordLoading = new RecordLoading(neoStores);
        this.limiter = this.instantiateMemoryLimiter(memoryLimit);
        this.cacheAccessMemory = DefaultCacheAccess.defaultByteArray(this.limiter.rangeSize(), memoryTracker);
        this.cacheAccess = new DefaultCacheAccess(this.cacheAccessMemory);
        this.observedCounts = new CountsState(neoStores, this.cacheAccess, memoryTracker);
        this.progress = progressFactory.multipleParts("Consistency check");
        this.indexAccessors = this.instantiateIndexAccessors(neoStores, indexProviders, tokenHolders, elementIdMapper, config, memoryTracker);
        this.context = new CheckerContext(neoStores, this.indexAccessors, execution, this.reporter, this.cacheAccess, tokenHolders, recordLoading, this.observedCounts, this.limiter, this.progress, pageCache, memoryTracker, verboseLog, verbose, consistencyFlags, contextFactory);
    }

    private IndexAccessors instantiateIndexAccessors(NeoStores neoStores, IndexProviderMap indexProviders, TokenHolders tokenHolders, ElementIdMapper elementIdMapper, Config config, MemoryTracker memoryTracker) {
        SchemaRuleAccess schemaRuleAccess = SchemaRuleAccess.getSchemaRuleAccess(neoStores.getSchemaStore(), tokenHolders);
        return new IndexAccessors(indexProviders, (IndexDescriptorProvider)new SchemaRulesDescriptors(neoStores, schemaRuleAccess), new IndexSamplingConfig(config), (TokenNameLookup)tokenHolders, elementIdMapper, this.contextFactory, neoStores.getOpenOptions(), (StorageEngineIndexingBehaviour)new RecordStorageIndexingBehaviour(neoStores.getNodeStore().getRecordsPerPage(), neoStores.getRelationshipStore().getRecordsPerPage()), memoryTracker);
    }

    public void check() throws ConsistencyCheckIncompleteException {
        if (this.consistencyFlags.checkPropertyOwners()) {
            this.context.error("The consistency checker has been configured to check property ownership. This feature is currently unavailable for this database format. The check will continue as if it were disabled.", new Object[0]);
        }
        assert (!this.context.isCancelled());
        try {
            this.consistencyCheckIdGenerator();
            this.consistencyCheckIndexes();
            this.context.initialize();
            SchemaChecker schemaChecker = new SchemaChecker(this.context);
            IntObjectHashMap mandatoryNodeProperties = new IntObjectHashMap();
            IntObjectHashMap allowedNodePropertyTypes = new IntObjectHashMap();
            IntObjectHashMap mandatoryRelationshipProperties = new IntObjectHashMap();
            IntObjectHashMap allowedRelationshipPropertyTypes = new IntObjectHashMap();
            try (CursorContext cursorContext = this.contextFactory.create(SCHEMA_CONSISTENCY_CHECKER_TAG);
                 CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, cursorContext);){
                schemaChecker.check((MutableIntObjectMap<MutableIntSet>)mandatoryNodeProperties, (MutableIntObjectMap<MutableIntSet>)mandatoryRelationshipProperties, (MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>>)allowedNodePropertyTypes, (MutableIntObjectMap<MutableIntObjectMap<PropertyTypeSet>>)allowedRelationshipPropertyTypes, cursorContext, (StoreCursors)storeCursors);
            }
            NodeChecker nodeChecker = new NodeChecker(this.context, (IntObjectMap<? extends IntSet>)mandatoryNodeProperties, (IntObjectMap<? extends IntObjectMap<PropertyTypeSet>>)allowedNodePropertyTypes);
            NodeIndexChecker indexChecker = new NodeIndexChecker(this.context);
            RelationshipIndexChecker relationshipIndexChecker = new RelationshipIndexChecker(this.context);
            RelationshipChecker relationshipChecker = new RelationshipChecker(this.context, (IntObjectMap<? extends IntSet>)mandatoryRelationshipProperties, (IntObjectMap<? extends IntObjectMap<PropertyTypeSet>>)allowedRelationshipPropertyTypes);
            RelationshipGroupChecker relationshipGroupChecker = new RelationshipGroupChecker(this.context);
            RelationshipChainChecker relationshipChainChecker = new RelationshipChainChecker(this.context);
            ProgressMonitorFactory.Completer progressCompleter = this.progress.build();
            int numberOfRanges = this.limiter.numberOfRanges();
            int i = 1;
            while (this.limiter.hasNext() && !this.isCancelled()) {
                EntityBasedMemoryLimiter.CheckRange range = (EntityBasedMemoryLimiter.CheckRange)this.limiter.next();
                if (numberOfRanges > 1) {
                    this.context.debug("=== Checking range %d/%d (%s) ===", i, numberOfRanges, range);
                }
                this.context.initializeRange();
                this.cacheAccess.setPivotId(range.from());
                if (range.applicableForRelationshipBasedChecks()) {
                    LongRange relationshipRange = range.getRelationshipRange();
                    this.context.runIfAllowed(relationshipIndexChecker, relationshipRange);
                }
                if (range.applicableForNodeBasedChecks()) {
                    LongRange nodeRange = range.getNodeRange();
                    this.context.runIfAllowed(indexChecker, nodeRange);
                    this.cacheAccess.setCacheSlotSizesAndClear(DEFAULT_SLOT_SIZES);
                    this.context.runIfAllowed(nodeChecker, nodeRange);
                    this.context.runIfAllowed(relationshipGroupChecker, nodeRange);
                    this.context.runIfAllowed(relationshipChecker, nodeRange);
                    this.context.runIfAllowed(relationshipChainChecker, nodeRange);
                }
                ++i;
            }
            if (!this.isCancelled()) {
                this.checkCounts();
                this.checkRelationshipGroupDegressStore();
            }
            progressCompleter.close();
        }
        catch (Exception e) {
            this.cancel("ConsistencyChecker failed unexpectedly");
            throw new ConsistencyCheckIncompleteException((Throwable)e);
        }
    }

    private void consistencyCheckIdGenerator() {
        if (!this.consistencyFlags.checkStructure()) {
            return;
        }
        ArrayList idGenerators = new ArrayList();
        this.idGeneratorFactory.visit(idGenerators::add);
        ProgressListener progressListener = this.progressFactory.singlePart("ID Generator consistency check", (long)idGenerators.size());
        for (IdGenerator idGenerator : idGenerators) {
            this.consistencyCheckSingleCheckable(this.report, progressListener, (ConsistencyCheckable)idGenerator, RecordType.ID_STORE);
        }
    }

    private void consistencyCheckIndexes() {
        if (!this.consistencyFlags.checkIndexes() || !this.consistencyFlags.checkStructure()) {
            return;
        }
        ProgressListener progressListener = this.progressFactory.singlePart("Index structure consistency check", (long)(this.indexAccessors.onlineRules().size() + (this.indexAccessors.nodeLabelIndex() != null ? 1 : 0) + (this.indexAccessors.relationshipTypeIndex() != null ? 1 : 0)));
        if (this.indexAccessors.nodeLabelIndex() != null) {
            this.consistencyCheckSingleCheckable(this.report, progressListener, (ConsistencyCheckable)this.indexAccessors.nodeLabelIndex(), RecordType.LABEL_SCAN_DOCUMENT);
        }
        if (this.indexAccessors.relationshipTypeIndex() != null) {
            this.consistencyCheckSingleCheckable(this.report, progressListener, (ConsistencyCheckable)this.indexAccessors.relationshipTypeIndex(), RecordType.RELATIONSHIP_TYPE_SCAN_DOCUMENT);
        }
        ArrayList<IndexDescriptor> rulesToRemove = new ArrayList<IndexDescriptor>();
        for (IndexDescriptor onlineRule : this.indexAccessors.onlineRules()) {
            ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(this.report, RecordType.INDEX);
            ReporterFactory reporterFactory = new ReporterFactory((InvocationHandler)handler);
            IndexAccessor accessor = this.indexAccessors.accessorFor(onlineRule);
            if (!accessor.consistencyCheck(reporterFactory, this.contextFactory, this.context.execution.getNumberOfThreads())) {
                rulesToRemove.add(onlineRule);
            }
            handler.updateSummary();
            progressListener.add(1L);
        }
        for (IndexDescriptor toRemove : rulesToRemove) {
            this.indexAccessors.remove(toRemove);
        }
    }

    private EntityBasedMemoryLimiter instantiateMemoryLimiter(EntityBasedMemoryLimiter.Factory memoryLimit) {
        NodeStore nodeStore = this.neoStores.getNodeStore();
        long nodeCount = nodeStore.getIdGenerator().getHighId();
        RelationshipStore relStore = this.neoStores.getRelationshipStore();
        long relationshipCount = relStore.getIdGenerator().getHighId();
        return memoryLimit.create(nodeCount, relationshipCount);
    }

    @Override
    public void close() {
        this.context.cancel();
        IOUtils.closeAllUnchecked((AutoCloseable[])new AutoCloseable[]{this.observedCounts, this.indexAccessors, this.cacheAccessMemory});
    }

    private void checkCounts() {
        if (!this.consistencyFlags.checkCounts() || this.neoStores.getOpenOptions().contains((Object)PageCacheOpenOptions.MULTI_VERSIONED)) {
            return;
        }
        try (CursorContext cursorContext = this.contextFactory.create(COUNT_STORE_CONSISTENCY_CHECKER_TAG);
             CountsStore countsStore = CountsStoreProvider.getInstance().openCountsStore(this.pageCache, this.fileSystem, this.databaseLayout, (InternalLogProvider)NullLogProvider.getInstance(), RecoveryCleanupWorkCollector.ignore(), Config.defaults((Setting)GraphDatabaseInternalSettings.counts_store_max_cached_entries, (Object)100), this.contextFactory, this.cacheTracer, this.neoStores.getOpenOptions(), new CountsBuilder(){

            public void initialize(CountsUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                throw new UnsupportedOperationException("Counts store needed rebuild, consistency checker will instead report broken or missing store");
            }

            public long lastCommittedTxId() {
                return RecordStorageConsistencyChecker.this.lastCommittedTxId;
            }
        }, true, VersionStorage.EMPTY_STORAGE);
             CountsState.CountsChecker checker = this.observedCounts.checker(this.reporter);){
            if (this.consistencyFlags.checkStructure()) {
                this.consistencyCheckSingleCheckable(this.report, ProgressListener.NONE, (ConsistencyCheckable)countsStore, RecordType.COUNTS);
            }
            countsStore.accept((CountsVisitor)checker, cursorContext);
        }
        catch (Exception e) {
            this.report.error("Counts store is missing, broken or of an older format and will not be consistency checked");
            this.summary.genericError("Counts store is missing, broken or of an older format");
            this.context.error("Counts store is missing, broken or of an older format and will not be consistency checked", e);
        }
    }

    private void checkRelationshipGroupDegressStore() {
        if (!this.consistencyFlags.checkCounts() || !this.consistencyFlags.checkStructure()) {
            return;
        }
        try (RelationshipGroupDegreesStore relationshipGroupDegrees = DegreeStoreProvider.getInstance().openDegreesStore(this.pageCache, this.fileSystem, this.databaseLayout, (InternalLogProvider)NullLogProvider.getInstance(), RecoveryCleanupWorkCollector.ignore(), Config.defaults((Setting)GraphDatabaseInternalSettings.counts_store_max_cached_entries, (Object)100), this.contextFactory, this.cacheTracer, new DegreesRebuilder(){

            public void rebuild(DegreeUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                throw new UnsupportedOperationException("Counts store needed rebuild, consistency checker will instead report broken or missing store");
            }

            public long lastCommittedTxId() {
                return RecordStorageConsistencyChecker.this.lastCommittedTxId;
            }
        }, this.neoStores.getOpenOptions(), true, VersionStorage.EMPTY_STORAGE);){
            this.consistencyCheckSingleCheckable(this.report, ProgressListener.NONE, (ConsistencyCheckable)relationshipGroupDegrees, RecordType.RELATIONSHIP_GROUP);
        }
        catch (Exception e) {
            this.report.error("Relationship group degrees is missing, broken or of an older format and will not be consistency checked");
            this.summary.genericError("Relationship group degrees store is missing, broken or of an older format");
            this.context.error("Relationship group degrees is missing, broken or of an older format and will not be consistency checked", e);
        }
    }

    private static TokenHolders safeLoadTokens(NeoStores neoStores, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        TokenHolders tokenHolders = new TokenHolders((TokenHolder)new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "PropertyKey"), (TokenHolder)new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "Label"), (TokenHolder)new CreatingTokenHolder(ReadOnlyTokenCreator.READ_ONLY, "RelationshipType"));
        try (CursorContext cursorContext = contextFactory.create(CONSISTENCY_CHECKER_TOKEN_LOADER_TAG);){
            tokenHolders.relationshipTypeTokens().setInitialTokens(RecordLoading.safeLoadTokens(neoStores.getRelationshipTypeTokenStore(), cursorContext, memoryTracker));
            tokenHolders.labelTokens().setInitialTokens(RecordLoading.safeLoadTokens(neoStores.getLabelTokenStore(), cursorContext, memoryTracker));
            tokenHolders.propertyKeyTokens().setInitialTokens(RecordLoading.safeLoadTokens(neoStores.getPropertyKeyTokenStore(), cursorContext, memoryTracker));
        }
        return tokenHolders;
    }

    private void cancel(String message) {
        if (!this.isCancelled()) {
            this.context.debug("Stopping: %s", message);
            this.context.cancel();
        }
    }

    private boolean isCancelled() {
        return this.context.isCancelled();
    }

    private void consistencyCheckSingleCheckable(InconsistencyReport report, ProgressListener listener, ConsistencyCheckable checkable, RecordType recordType) {
        ConsistencyReporter.FormattingDocumentedHandler handler = ConsistencyReporter.formattingHandler(report, recordType);
        ReporterFactory proxyFactory = new ReporterFactory((InvocationHandler)handler);
        checkable.consistencyCheck(proxyFactory, this.contextFactory, this.context.execution.getNumberOfThreads());
        handler.updateSummary();
        listener.add(1L);
    }

    private static ElementIdMapper makeElementIdMapper(NeoStores neoStores, DatabaseLayout layout, CursorContextFactory contextFactory) {
        try (CursorContext ctx = contextFactory.create("readUUID");){
            ElementIdMapper elementIdMapper = neoStores.getMetaDataStore().getDatabaseIdUuid(ctx).map(uuid -> new DefaultElementIdMapperV1(DatabaseIdFactory.from((String)layout.getDatabaseName(), (UUID)uuid))).orElse(ElementIdMapper.PLACEHOLDER);
            return elementIdMapper;
        }
    }

    private static class SchemaRulesDescriptors
    implements IndexDescriptorProvider {
        private final NeoStores neoStores;
        private final SchemaRuleAccess schemaRuleAccess;

        SchemaRulesDescriptors(NeoStores neoStores, SchemaRuleAccess schemaRuleAccess) {
            this.neoStores = neoStores;
            this.schemaRuleAccess = schemaRuleAccess;
        }

        public ResourceIterator<IndexDescriptor> indexDescriptors(CursorContext cursorContext, MemoryTracker memoryTracker) {
            CachedStoreCursors storeCursors = new CachedStoreCursors(this.neoStores, cursorContext);
            Iterator<IndexDescriptor> descriptorIterator = this.schemaRuleAccess.indexesGetAllIgnoreMalformed((StoreCursors)storeCursors, memoryTracker);
            return Iterators.resourceIterator(descriptorIterator, () -> ((CachedStoreCursors)storeCursors).close());
        }
    }
}

