/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checker;

import java.util.Iterator;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.map.primitive.MutableIntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.impl.map.mutable.primitive.IntObjectHashMap;
import org.neo4j.collection.PrimitiveLongResourceIterator;
import org.neo4j.common.EntityType;
import org.neo4j.consistency.checker.Checker;
import org.neo4j.consistency.checker.CheckerContext;
import org.neo4j.consistency.checker.CountsState;
import org.neo4j.consistency.checker.EntityTokenIndexCheckState;
import org.neo4j.consistency.checker.NodeChecker;
import org.neo4j.consistency.checker.ParallelExecution;
import org.neo4j.consistency.checker.RecordLoading;
import org.neo4j.consistency.checker.RecordReader;
import org.neo4j.consistency.checker.SafePropertyChainReader;
import org.neo4j.consistency.checker.SchemaComplianceChecker;
import org.neo4j.consistency.checking.ConsistencyFlags;
import org.neo4j.consistency.checking.cache.CacheAccess;
import org.neo4j.consistency.report.ConsistencyReport;
import org.neo4j.consistency.store.synthetic.TokenScanDocument;
import org.neo4j.internal.helpers.collection.BoundedIterable;
import org.neo4j.internal.helpers.collection.LongRange;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.recordstorage.RelationshipCounter;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaPatternMatchingType;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.index.schema.EntityTokenRange;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.values.storable.Value;

class RelationshipChecker
implements Checker {
    private static final String UNUSED_RELATIONSHIP_CHECKER_TAG = "unusedRelationshipChecker";
    private static final String RELATIONSHIP_RANGE_CHECKER_TAG = "relationshipRangeChecker";
    private final NeoStores neoStores;
    private final ParallelExecution execution;
    private final ConsistencyReport.Reporter reporter;
    private final CacheAccess cacheAccess;
    private final TokenHolders tokenHolders;
    private final RecordLoading recordLoader;
    private final CountsState observedCounts;
    private final CheckerContext context;
    private final IntObjectMap<? extends IntSet> mandatoryProperties;
    private final IntObjectMap<? extends IntObjectMap<PropertyTypeSet>> allowedTypes;
    private final List<IndexDescriptor> indexes;
    private final ProgressListener progress;

    RelationshipChecker(CheckerContext context, IntObjectMap<? extends IntSet> mandatoryProperties, IntObjectMap<? extends IntObjectMap<PropertyTypeSet>> allowedTypes) {
        this.context = context;
        this.neoStores = context.neoStores;
        this.execution = context.execution;
        this.reporter = context.reporter;
        this.cacheAccess = context.cacheAccess;
        this.tokenHolders = context.tokenHolders;
        this.recordLoader = context.recordLoader;
        this.observedCounts = context.observedCounts;
        this.mandatoryProperties = mandatoryProperties;
        this.allowedTypes = allowedTypes;
        this.indexes = context.indexSizes.smallIndexes(EntityType.RELATIONSHIP);
        this.progress = context.progressReporter(this, "Relationships", this.neoStores.getRelationshipStore().getIdGenerator().getHighId());
    }

    @Override
    public boolean shouldBeChecked(ConsistencyFlags flags) {
        return flags.checkGraph() || !this.indexes.isEmpty() && flags.checkIndexes();
    }

    @Override
    public void check(LongRange nodeIdRange, boolean firstRange, boolean lastRange, MemoryTracker memoryTracker) throws Exception {
        this.execution.run(this.getClass().getSimpleName() + "-relationships", this.execution.partition(this.neoStores.getRelationshipStore(), (from, to, last) -> () -> this.check(nodeIdRange, firstRange, from, to, firstRange && last, memoryTracker)));
        this.execution.run(this.getClass().getSimpleName() + "-unusedRelationships", this.execution.partition(nodeIdRange, (from, to, last) -> () -> this.checkNodesReferencingUnusedRelationships(from, to, this.context.contextFactory, memoryTracker)));
    }

    private void check(LongRange nodeIdRange, boolean firstRound, long fromRelationshipId, long toRelationshipId, boolean checkToEndOfIndex, MemoryTracker memoryTracker) throws Exception {
        RelationshipCounter counter = this.observedCounts.instantiateRelationshipCounter();
        int[] typeHolder = new int[1];
        try (CursorContext cursorContext = this.context.contextFactory.create(RELATIONSHIP_RANGE_CHECKER_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, cursorContext);
             RecordReader<RelationshipRecord> relationshipReader = new RecordReader<RelationshipRecord>(this.context.neoStores.getRelationshipStore(), true, cursorContext, this.context.memoryTracker);
             BoundedIterable<EntityTokenRange> relationshipTypeReader = this.getRelationshipTypeIndexReader(fromRelationshipId, toRelationshipId, checkToEndOfIndex, cursorContext);
             SafePropertyChainReader property = new SafePropertyChainReader(this.context, cursorContext);
             SchemaComplianceChecker schemaComplianceChecker = new SchemaComplianceChecker(this.context, this.mandatoryProperties, this.allowedTypes, this.indexes, cursorContext, (StoreCursors)storeCursors);
             ProgressListener localProgress = this.progress.threadLocalReporter();
             PrimitiveLongResourceIterator freeIdsIterator = firstRound ? this.context.neoStores.getRelationshipStore().getIdGenerator().notUsedIdsIterator(fromRelationshipId, toRelationshipId) : null;){
            CacheAccess.Client client = this.cacheAccess.client();
            IntObjectHashMap<Value> propertyValues = new IntObjectHashMap<Value>();
            Iterator relationshipTypeRangeIterator = relationshipTypeReader.iterator();
            EntityTokenIndexCheckState typeIndexState = new EntityTokenIndexCheckState(null, fromRelationshipId - 1L);
            long nextFreeId = Record.NULL_REFERENCE.longValue();
            for (long relationshipId = fromRelationshipId; relationshipId < toRelationshipId && !this.context.isCancelled(); ++relationshipId) {
                boolean endNodeIsNegativeOnFirstRound;
                boolean startNodeIsNegativeOnFirstRound;
                localProgress.add(1L);
                RelationshipRecord relationshipRecord = relationshipReader.read(relationshipId);
                if (firstRound) {
                    while (nextFreeId < relationshipId && freeIdsIterator.hasNext()) {
                        nextFreeId = freeIdsIterator.next();
                    }
                }
                if (!relationshipRecord.inUse()) {
                    if (!firstRound || relationshipId == nextFreeId) continue;
                    this.reporter.forRelationship(relationshipRecord).idIsNotFreed();
                    continue;
                }
                long startNode = relationshipRecord.getFirstNode();
                boolean startNodeIsWithinRange = nodeIdRange.isWithinRangeExclusiveTo(startNode);
                boolean bl = startNodeIsNegativeOnFirstRound = startNode < 0L && firstRound;
                if (startNodeIsWithinRange || startNodeIsNegativeOnFirstRound) {
                    this.checkRelationshipVsNode(client, relationshipRecord, startNode, relationshipRecord.isFirstInFirstChain(), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).sourceNodeNotInUse((NodeRecord)node), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).sourceNodeDoesNotReferenceBack((NodeRecord)node), (relationship, node) -> this.reporter.forNode((NodeRecord)node).relationshipNotFirstInSourceChain((RelationshipRecord)relationship), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).sourceNodeHasNoRelationships((NodeRecord)node), relationship -> this.reporter.forRelationship((RelationshipRecord)relationship).illegalSourceNode(), (StoreCursors)storeCursors, memoryTracker);
                }
                long endNode = relationshipRecord.getSecondNode();
                boolean endNodeIsWithinRange = nodeIdRange.isWithinRangeExclusiveTo(endNode);
                boolean bl2 = endNodeIsNegativeOnFirstRound = endNode < 0L && firstRound;
                if (endNodeIsWithinRange || endNodeIsNegativeOnFirstRound) {
                    this.checkRelationshipVsNode(client, relationshipRecord, endNode, relationshipRecord.isFirstInSecondChain(), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).targetNodeNotInUse((NodeRecord)node), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).targetNodeDoesNotReferenceBack((NodeRecord)node), (relationship, node) -> this.reporter.forNode((NodeRecord)node).relationshipNotFirstInTargetChain((RelationshipRecord)relationship), (relationship, node) -> this.reporter.forRelationship((RelationshipRecord)relationship).targetNodeHasNoRelationships((NodeRecord)node), relationship -> this.reporter.forRelationship((RelationshipRecord)relationship).illegalTargetNode(), (StoreCursors)storeCursors, memoryTracker);
                }
                if (firstRound) {
                    if (relationshipId == nextFreeId) {
                        this.reporter.forRelationship(relationshipRecord).idIsFreed();
                    }
                    if (startNode >= this.context.highNodeId) {
                        this.reporter.forRelationship(relationshipRecord).sourceNodeNotInUse(this.context.recordLoader.node(startNode, (StoreCursors)storeCursors, memoryTracker));
                    }
                    if (endNode >= this.context.highNodeId) {
                        this.reporter.forRelationship(relationshipRecord).targetNodeNotInUse(this.context.recordLoader.node(endNode, (StoreCursors)storeCursors, memoryTracker));
                    }
                    typeHolder[0] = relationshipRecord.getType();
                    propertyValues = RecordLoading.lightReplace(propertyValues);
                    boolean propertyChainIsOk = property.read((MutableIntObjectMap<Value>)propertyValues, relationshipRecord, this.reporter::forRelationship, (StoreCursors)storeCursors);
                    if (propertyChainIsOk) {
                        schemaComplianceChecker.checkExistenceAndTypeConstraints(relationshipRecord, typeHolder, (IntObjectMap<Value>)propertyValues, this.reporter::forRelationship);
                        if (this.context.consistencyFlags.checkIndexes()) {
                            schemaComplianceChecker.checkCorrectlyIndexed(relationshipRecord, typeHolder, (IntObjectMap<Value>)propertyValues, this.reporter::forRelationship);
                        }
                    }
                    RecordLoading.checkValidToken(relationshipRecord, relationshipRecord.getType(), this.tokenHolders.relationshipTypeTokens(), this.neoStores.getRelationshipTypeTokenStore(), (rel, token) -> this.reporter.forRelationship((RelationshipRecord)rel).illegalRelationshipType(), (rel, token) -> this.reporter.forRelationship((RelationshipRecord)rel).relationshipTypeNotInUse((RelationshipTypeTokenRecord)token), (StoreCursors)storeCursors, memoryTracker);
                    this.observedCounts.incrementRelationshipTypeCounts(counter, relationshipRecord);
                    if (relationshipTypeReader.maxCount() != 0L) {
                        this.checkRelationshipVsRelationshipTypeIndex(relationshipRecord, relationshipTypeRangeIterator, typeIndexState, relationshipId, relationshipRecord.getType(), fromRelationshipId, (StoreCursors)storeCursors, memoryTracker);
                    }
                }
                this.observedCounts.incrementRelationshipNodeCounts(counter, relationshipRecord, startNodeIsWithinRange, endNodeIsWithinRange);
            }
            if (firstRound && !this.context.isCancelled() && relationshipTypeReader.maxCount() != 0L) {
                this.reportRemainingRelationshipTypeIndexEntries(relationshipTypeRangeIterator, typeIndexState, checkToEndOfIndex ? Long.MAX_VALUE : toRelationshipId, (StoreCursors)storeCursors, memoryTracker);
            }
        }
    }

    private BoundedIterable<EntityTokenRange> getRelationshipTypeIndexReader(long fromRelationshipId, long toRelationshipId, boolean last, CursorContext cursorContext) {
        if (this.context.relationshipTypeIndex != null) {
            return this.context.relationshipTypeIndex.newAllEntriesTokenReader(fromRelationshipId, last ? Long.MAX_VALUE : toRelationshipId, cursorContext);
        }
        return BoundedIterable.empty();
    }

    private void checkRelationshipVsRelationshipTypeIndex(RelationshipRecord relationshipRecord, Iterator<EntityTokenRange> relationshipTypeRangeIterator, EntityTokenIndexCheckState relationshipTypeIndexState, long relationshipId, int type, long fromRelationshipId, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        long relationshipIdMissingFromStore;
        while (relationshipTypeIndexState.needToMoveRangeForwardToReachEntity(relationshipId) && !this.context.isCancelled() && relationshipTypeRangeIterator.hasNext()) {
            if (relationshipTypeIndexState.currentRange != null) {
                for (relationshipIdMissingFromStore = relationshipTypeIndexState.lastCheckedEntityId + 1L; relationshipIdMissingFromStore < relationshipId && relationshipTypeIndexState.currentRange.covers(relationshipIdMissingFromStore); ++relationshipIdMissingFromStore) {
                    if (relationshipTypeIndexState.currentRange.tokens(relationshipIdMissingFromStore).length <= 0) continue;
                    this.reporter.forRelationshipTypeScan(new TokenScanDocument(relationshipTypeIndexState.currentRange)).relationshipNotInUse(this.recordLoader.relationship(relationshipIdMissingFromStore, storeCursors, memoryTracker));
                }
            }
            relationshipTypeIndexState.currentRange = relationshipTypeRangeIterator.next();
            relationshipTypeIndexState.lastCheckedEntityId = Math.max(fromRelationshipId, relationshipTypeIndexState.currentRange.entities()[0]) - 1L;
        }
        if (relationshipTypeIndexState.currentRange != null && relationshipTypeIndexState.currentRange.covers(relationshipId)) {
            for (relationshipIdMissingFromStore = relationshipTypeIndexState.lastCheckedEntityId + 1L; relationshipIdMissingFromStore < relationshipId; ++relationshipIdMissingFromStore) {
                if (relationshipTypeIndexState.currentRange.tokens(relationshipIdMissingFromStore).length <= 0) continue;
                this.reporter.forRelationshipTypeScan(new TokenScanDocument(relationshipTypeIndexState.currentRange)).relationshipNotInUse(this.recordLoader.relationship(relationshipIdMissingFromStore, storeCursors, memoryTracker));
            }
            int[] relationshipTypesInTypeIndex = relationshipTypeIndexState.currentRange.tokens(relationshipId);
            this.validateTypeIds(relationshipRecord, type, relationshipTypesInTypeIndex, relationshipTypeIndexState.currentRange, storeCursors, memoryTracker);
            relationshipTypeIndexState.lastCheckedEntityId = relationshipId;
        } else {
            TokenScanDocument document = new TokenScanDocument(null);
            this.reporter.forRelationshipTypeScan(document).relationshipTypeNotInIndex(this.recordLoader.relationship(relationshipId, storeCursors, memoryTracker), type);
        }
    }

    private void reportRemainingRelationshipTypeIndexEntries(Iterator<EntityTokenRange> relationshipTypeRangeIterator, EntityTokenIndexCheckState relationshipTypeIndexState, long toRelationshipId, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        if (relationshipTypeIndexState.currentRange == null && relationshipTypeRangeIterator.hasNext()) {
            relationshipTypeIndexState.currentRange = relationshipTypeRangeIterator.next();
        }
        while (relationshipTypeIndexState.currentRange != null && !this.context.isCancelled()) {
            long relationshipIdMissingFromStore = relationshipTypeIndexState.lastCheckedEntityId + 1L;
            while (relationshipIdMissingFromStore < toRelationshipId && !relationshipTypeIndexState.needToMoveRangeForwardToReachEntity(relationshipIdMissingFromStore)) {
                if (relationshipTypeIndexState.currentRange.covers(relationshipIdMissingFromStore) && relationshipTypeIndexState.currentRange.tokens(relationshipIdMissingFromStore).length > 0) {
                    this.reporter.forRelationshipTypeScan(new TokenScanDocument(relationshipTypeIndexState.currentRange)).relationshipNotInUse(this.recordLoader.relationship(relationshipIdMissingFromStore, storeCursors, memoryTracker));
                }
                relationshipTypeIndexState.lastCheckedEntityId = relationshipIdMissingFromStore++;
            }
            relationshipTypeIndexState.currentRange = relationshipTypeRangeIterator.hasNext() ? relationshipTypeRangeIterator.next() : null;
        }
    }

    private void validateTypeIds(RelationshipRecord relationshipRecord, int typeInStore, int[] relationshipTypesInTypeIndex, EntityTokenRange entityTokenRange, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        NodeChecker.compareTwoSortedIntArrays(SchemaPatternMatchingType.COMPLETE_ALL_TOKENS, new int[]{typeInStore}, relationshipTypesInTypeIndex, indexType -> this.reporter.forRelationshipTypeScan(new TokenScanDocument(entityTokenRange)).relationshipDoesNotHaveExpectedRelationshipType(this.recordLoader.relationship(relationshipRecord.getId(), storeCursors, memoryTracker), indexType), storeType -> this.reporter.forRelationshipTypeScan(new TokenScanDocument(entityTokenRange)).relationshipTypeNotInIndex(this.recordLoader.relationship(relationshipRecord.getId(), storeCursors, memoryTracker), storeType));
    }

    private void checkRelationshipVsNode(CacheAccess.Client client, RelationshipRecord relationshipRecord, long node, boolean firstInChain, BiConsumer<RelationshipRecord, NodeRecord> reportNodeNotInUse, BiConsumer<RelationshipRecord, NodeRecord> reportNodeDoesNotReferenceBack, BiConsumer<RelationshipRecord, NodeRecord> reportNodeNotFirstInChain, BiConsumer<RelationshipRecord, NodeRecord> reportNodeHasNoChain, Consumer<RelationshipRecord> reportIllegalNode, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        if (node < 0L) {
            reportIllegalNode.accept(this.recordLoader.relationship(relationshipRecord.getId(), storeCursors, memoryTracker));
            return;
        }
        boolean nodeInUse = client.getBooleanFromCache(node, 2);
        if (!nodeInUse) {
            reportNodeNotInUse.accept(this.recordLoader.relationship(relationshipRecord.getId(), storeCursors, memoryTracker), this.recordLoader.node(node, storeCursors, memoryTracker));
            return;
        }
        long nodeNextRel = client.getFromCache(node, 0);
        if (Record.NULL_REFERENCE.is(nodeNextRel)) {
            reportNodeHasNoChain.accept(this.recordLoader.relationship(relationshipRecord.getId(), storeCursors, memoryTracker), this.recordLoader.node(node, storeCursors, memoryTracker));
            return;
        }
        boolean nodeIsDense = client.getBooleanFromCache(node, 3);
        if (!nodeIsDense) {
            if (firstInChain) {
                if (nodeNextRel != relationshipRecord.getId()) {
                    reportNodeDoesNotReferenceBack.accept(this.recordLoader.relationship(relationshipRecord.getId(), storeCursors, memoryTracker), this.recordLoader.node(node, storeCursors, memoryTracker));
                    RelationshipRecord relationshipThatNodeActuallyReferences = this.recordLoader.relationship(nodeNextRel, storeCursors, memoryTracker);
                    if (!relationshipThatNodeActuallyReferences.inUse()) {
                        this.reporter.forNode(this.recordLoader.node(node, storeCursors, memoryTracker)).relationshipNotInUse(relationshipThatNodeActuallyReferences);
                    } else if (relationshipThatNodeActuallyReferences.getFirstNode() != node && relationshipThatNodeActuallyReferences.getSecondNode() != node) {
                        this.reporter.forNode(this.recordLoader.node(node, storeCursors, memoryTracker)).relationshipForOtherNode(relationshipThatNodeActuallyReferences);
                    }
                }
                client.putToCacheSingle(node, 5, 0L);
            }
            if (!firstInChain && nodeNextRel == relationshipRecord.getId()) {
                reportNodeNotFirstInChain.accept(this.recordLoader.relationship(relationshipRecord.getId(), storeCursors, memoryTracker), this.recordLoader.node(node, storeCursors, memoryTracker));
            }
        }
    }

    private void checkNodesReferencingUnusedRelationships(long fromNodeId, long toNodeId, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        CacheAccess.Client client = this.cacheAccess.client();
        try (CursorContext cursorContext = contextFactory.create(UNUSED_RELATIONSHIP_CHECKER_TAG);
             CachedStoreCursors storeCursors = new CachedStoreCursors(this.context.neoStores, cursorContext);){
            for (long id = fromNodeId; id < toNodeId && !this.context.isCancelled(); ++id) {
                boolean needsChecking;
                boolean nodeInUse = client.getBooleanFromCache(id, 2);
                if (!nodeInUse || !(needsChecking = client.getBooleanFromCache(id, 5))) continue;
                long nodeNextRel = client.getFromCache(id, 0);
                boolean nodeIsDense = client.getBooleanFromCache(id, 3);
                if (Record.NULL_REFERENCE.is(nodeNextRel)) continue;
                if (!nodeIsDense) {
                    RelationshipRecord relationship = this.recordLoader.relationship(nodeNextRel, (StoreCursors)storeCursors, memoryTracker);
                    NodeRecord node = this.recordLoader.node(id, (StoreCursors)storeCursors, memoryTracker);
                    if (!relationship.inUse()) {
                        this.reporter.forNode(node).relationshipNotInUse(relationship);
                        continue;
                    }
                    this.reporter.forNode(node).relationshipForOtherNode(relationship);
                    continue;
                }
                RelationshipGroupRecord group = this.recordLoader.relationshipGroup(nodeNextRel, (StoreCursors)storeCursors, memoryTracker);
                if (!group.inUse()) {
                    this.reporter.forNode(this.recordLoader.node(id, (StoreCursors)storeCursors, memoryTracker)).relationshipGroupNotInUse(group);
                    continue;
                }
                this.reporter.forNode(this.recordLoader.node(id, (StoreCursors)storeCursors, memoryTracker)).relationshipGroupHasOtherOwner(group);
            }
        }
    }

    public String toString() {
        RelationshipStore relStore = this.neoStores.getRelationshipStore();
        return String.format("%s[highId:%d,indexesToCheck:%d]", this.getClass().getSimpleName(), relStore.getIdGenerator().getHighId(), this.indexes.size());
    }
}

