/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.consistency.checking;

import java.util.Objects;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;

public abstract class SchemaRuleKey {
    private final boolean isUnique;
    private final SchemaDescriptor schema;
    private final IndexType indexType;
    private final boolean isExistenceConstraint;

    protected SchemaRuleKey(SchemaDescriptor schema, boolean isUnique, IndexType indexType, boolean isExistenceConstraint) {
        this.isUnique = isUnique;
        this.schema = schema;
        this.indexType = indexType;
        this.isExistenceConstraint = isExistenceConstraint;
    }

    public static SchemaRuleKey from(SchemaRule rule) {
        return rule instanceof ConstraintDescriptor ? new ConstraintKey((ConstraintDescriptor)rule) : new IndexKey((IndexDescriptor)rule);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SchemaRuleKey that = (SchemaRuleKey)o;
        return this.isUnique == that.isUnique && this.schema.equals((Object)that.schema) && this.indexType == that.indexType && this.isExistenceConstraint == that.isExistenceConstraint;
    }

    public int hashCode() {
        return Objects.hash(this.indexType, this.isUnique ? 1 : 0, this.schema.hashCode(), this.isExistenceConstraint);
    }

    static class ConstraintKey
    extends SchemaRuleKey {
        ConstraintKey(ConstraintDescriptor constraint) {
            super(constraint.schema(), constraint.enforcesUniqueness(), constraint.isIndexBackedConstraint() ? constraint.asIndexBackedConstraint().indexType() : null, constraint.isPropertyExistenceConstraint());
        }
    }

    static class IndexKey
    extends SchemaRuleKey {
        IndexKey(IndexDescriptor index) {
            super(index.schema(), index.isUnique(), index.getIndexType(), false);
        }
    }
}

