/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Arrays;
import org.eclipse.collections.api.iterator.LongIterator;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.staging.ProducerStep;
import org.neo4j.internal.batchimport.staging.StageControl;

class BatchIdsStep
extends ProducerStep {
    private final LongIterator ids;
    private long position;

    BatchIdsStep(StageControl control, Configuration config, LongIterator ids) {
        super(control, config);
        this.ids = ids;
    }

    protected void process() {
        long[] batch = new long[this.config.batchSize()];
        int batchIndex = 0;
        while (this.ids.hasNext()) {
            if (batchIndex == batch.length) {
                this.send(batch);
                batch = new long[this.config.batchSize()];
                batchIndex = 0;
            }
            batch[batchIndex++] = this.ids.next();
        }
        if (batchIndex > 0) {
            this.send(Arrays.copyOf(batch, batchIndex));
        }
    }

    private void send(long[] batch) {
        this.sendDownstream(batch);
        this.position += (long)batch.length;
    }

    protected long position() {
        return this.position;
    }
}

