/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.staging.BatchSender;
import org.neo4j.internal.batchimport.staging.ProcessorStep;
import org.neo4j.internal.batchimport.staging.StageControl;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.memory.MemoryTracker;

public class EncodeGroupsStep
extends ProcessorStep<RelationshipGroupRecord[]> {
    private final IdGenerator idGenerator;
    private long nextId = -1L;
    private final RecordStore<RelationshipGroupRecord> store;

    public EncodeGroupsStep(StageControl control, Configuration config, RecordStore<RelationshipGroupRecord> store, CursorContextFactory contextFactory) {
        super(control, "ENCODE", config, 1, contextFactory, new StatsProvider[0]);
        this.store = store;
        this.idGenerator = store.getIdGenerator();
    }

    protected void process(RelationshipGroupRecord[] batch, BatchSender sender, CursorContext cursorContext, MemoryTracker memoryTracker) {
        int groupStartIndex = 0;
        for (int i = 0; i < batch.length; ++i) {
            long l;
            boolean lastInChain;
            RelationshipGroupRecord group = batch[i];
            long count = group.getNext();
            boolean bl = lastInChain = count == 0L;
            if (this.nextId == -1L) {
                l = this.idGenerator.nextId(cursorContext);
                this.nextId = this.nextId;
            } else {
                l = this.nextId;
            }
            group.setId(l);
            if (!lastInChain) {
                this.nextId = this.idGenerator.nextId(cursorContext);
                group.setNext(this.nextId);
                continue;
            }
            this.nextId = -1L;
            group.setNext(-1L);
            for (int j = groupStartIndex; j <= i; ++j) {
                this.store.prepareForCommit(batch[j], (IdSequence)this.idGenerator, cursorContext);
            }
            groupStartIndex = i + 1;
        }
        assert (groupStartIndex == batch.length);
        sender.send((Object)batch);
    }
}

