/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import org.eclipse.collections.api.iterator.LongIterator;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.eclipse.collections.api.set.primitive.LongSet;
import org.neo4j.batchimport.api.AdditionalInitialIds;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.batchimport.api.IndexImporterFactory;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.PropertyValueLookup;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.collection.Dependencies;
import org.neo4j.common.DependencyResolver;
import org.neo4j.configuration.Config;
import org.neo4j.configuration.GraphDatabaseSettings;
import org.neo4j.counts.CountsUpdater;
import org.neo4j.function.Predicates;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.DataStatistics;
import org.neo4j.internal.batchimport.DeleteDuplicateNodesStage;
import org.neo4j.internal.batchimport.DeleteViolatingRelationshipsStage;
import org.neo4j.internal.batchimport.HeapSizeSanityChecker;
import org.neo4j.internal.batchimport.IdMapperPreparationStage;
import org.neo4j.internal.batchimport.MemoryUsageStatsProvider;
import org.neo4j.internal.batchimport.NodeCountsAndLabelIndexBuildStage;
import org.neo4j.internal.batchimport.NodeDegreeCountStage;
import org.neo4j.internal.batchimport.NodeInputIdPropertyLookup;
import org.neo4j.internal.batchimport.RelationshipCountsAndTypeIndexBuildStage;
import org.neo4j.internal.batchimport.RelationshipGroupDefragmenter;
import org.neo4j.internal.batchimport.RelationshipGroupStage;
import org.neo4j.internal.batchimport.RelationshipLinkbackStage;
import org.neo4j.internal.batchimport.RelationshipLinkforwardStage;
import org.neo4j.internal.batchimport.RelationshipLinkingProgress;
import org.neo4j.internal.batchimport.SchemaMonitors;
import org.neo4j.internal.batchimport.SparseNodeFirstRelationshipStage;
import org.neo4j.internal.batchimport.cache.GatheringMemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.MemoryStatsVisitor;
import org.neo4j.internal.batchimport.cache.NumberArrayFactories;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.cache.idmapping.IdMappers;
import org.neo4j.internal.batchimport.cache.legacy.NodeLabelsCache;
import org.neo4j.internal.batchimport.cache.legacy.NodeRelationshipCache;
import org.neo4j.internal.batchimport.input.EstimationSanityChecker;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.counts.CountsBuilder;
import org.neo4j.internal.helpers.Format;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;
import org.neo4j.io.ByteUnit;
import org.neo4j.io.IOUtils;
import org.neo4j.io.fs.FileSystemAbstraction;
import org.neo4j.io.layout.DatabaseLayout;
import org.neo4j.io.layout.recordstorage.RecordDatabaseLayout;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.io.pagecache.tracing.PageCacheTracer;
import org.neo4j.kernel.impl.store.LabelTokenStore;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipTypeTokenStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.format.RecordFormats;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.internal.LogService;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.scheduler.JobScheduler;
import org.neo4j.storageengine.api.LogMetadataProvider;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.storageengine.migration.MigrationProgressMonitor;

public class ImportLogic
implements Closeable {
    private static final String ID_MAPPER_PREPARATION_TAG = "Id mapper preparation.";
    private static final RelationshipLinkingMonitor NO_LINKING_MONITOR = new RelationshipLinkingMonitor(){};
    private final Path databaseDirectory;
    private final String databaseName;
    protected final BatchingNeoStores neoStore;
    protected final Configuration config;
    private final Config dbConfig;
    private final InternalLog log;
    protected final CursorContextFactory contextFactory;
    private final IndexImporterFactory indexImporterFactory;
    private final PageCacheTracer pageCacheTracer;
    private final MemoryTracker memoryTracker;
    private final ExecutionMonitor executionMonitor;
    private final RecordFormats recordFormats;
    private final DataImporter.Monitor storeUpdateMonitor = new DataImporter.Monitor();
    private final long maxMemory;
    private final Dependencies dependencies = new Dependencies();
    private final Monitor monitor;
    private Input input;
    private boolean successful;
    private final Map<Class<?>, Object> accessibleState = new HashMap();
    protected NodeRelationshipCache nodeRelationshipCache;
    private NodeLabelsCache nodeLabelsCache;
    private long startTime;
    private NumberArrayFactory numberArrayFactory;
    private final Collector badCollector;
    private IdMapper idMapper;
    private long peakMemoryUsage;
    private long availableMemoryForLinking;
    private NodeInputIdPropertyLookup inputIdLookup;
    private CursorContext cursorContext;

    public ImportLogic(DatabaseLayout databaseLayout, BatchingNeoStores neoStore, Configuration config, Config dbConfig, LogService logService, ExecutionMonitor executionMonitor, Collector badCollector, Monitor monitor, CursorContextFactory contextFactory, IndexImporterFactory indexImporterFactory, PageCacheTracer pageCacheTracer, MemoryTracker memoryTracker) {
        this.databaseDirectory = databaseLayout.databaseDirectory();
        this.databaseName = databaseLayout.getDatabaseName();
        this.neoStore = neoStore;
        this.config = config;
        this.dbConfig = dbConfig;
        this.recordFormats = neoStore.recordFormats();
        this.badCollector = badCollector;
        this.monitor = monitor;
        this.log = logService.getInternalLogProvider().getLog(this.getClass());
        this.contextFactory = contextFactory;
        this.indexImporterFactory = indexImporterFactory;
        this.pageCacheTracer = pageCacheTracer;
        this.memoryTracker = memoryTracker;
        this.executionMonitor = ExecutionSupervisors.withDynamicProcessorAssignment((ExecutionMonitor)executionMonitor, (Configuration)config);
        this.maxMemory = config.maxOffHeapMemory();
    }

    public void initialize(Input input) throws IOException {
        this.log.info("Import starting");
        this.startTime = System.currentTimeMillis();
        this.input = input;
        this.numberArrayFactory = NumberArrayFactories.auto((FileSystemAbstraction)this.neoStore.fileSystem(), (Path)this.databaseDirectory, (InternalLog)this.log);
        Input.Estimates inputEstimates = input.validateAndEstimate((PropertySizeCalculator)this.neoStore.getPropertyStore().newValueEncodedSizeCalculator());
        this.cursorContext = this.contextFactory.create(ID_MAPPER_PREPARATION_TAG);
        this.inputIdLookup = new NodeInputIdPropertyLookup(this.neoStore.getTemporaryPropertyStore(), () -> new CachedStoreCursors(this.neoStore.getTemporaryNeoStores(), this.cursorContext));
        this.idMapper = this.instantiateIdMapper(input, inputEstimates, this.inputIdLookup);
        this.nodeRelationshipCache = new NodeRelationshipCache(this.numberArrayFactory, ((Integer)this.dbConfig.get(GraphDatabaseSettings.dense_node_threshold)).intValue(), this.memoryTracker);
        new EstimationSanityChecker(this.recordFormats, this.monitor).sanityCheck(inputEstimates);
        new HeapSizeSanityChecker(this.monitor).sanityCheck(inputEstimates, this.recordFormats, this.neoStore, NodeRelationshipCache.memoryEstimation((long)inputEstimates.numberOfNodes()), this.idMapper.memoryEstimation(inputEstimates.numberOfNodes()));
        this.dependencies.satisfyDependencies(new Object[]{inputEstimates, this.idMapper, this.neoStore, this.nodeRelationshipCache});
        if (this.neoStore.determineDoubleRelationshipRecordUnits(inputEstimates)) {
            this.monitor.doubleRelationshipRecordUnitsEnabled();
        }
        this.monitor.started();
        this.executionMonitor.initialize((DependencyResolver)this.dependencies);
    }

    protected IdMapper instantiateIdMapper(Input input, Input.Estimates inputEstimates, NodeInputIdPropertyLookup inputIdLookup) {
        long estimatedNumNodes = inputEstimates.numberOfNodes();
        return switch (input.idType()) {
            default -> throw new MatchException(null, null);
            case IdType.STRING -> IdMappers.strings((NumberArrayFactory)this.numberArrayFactory, (ReadableGroups)input.groups(), (boolean)this.config.strictNodeCheck(), (MemoryTracker)this.memoryTracker, (long)estimatedNumNodes, (PropertyValueLookup)inputIdLookup);
            case IdType.INTEGER -> IdMappers.longs((NumberArrayFactory)this.numberArrayFactory, (ReadableGroups)input.groups(), (MemoryTracker)this.memoryTracker, (long)estimatedNumNodes);
            case IdType.ACTUAL -> IdMappers.actual();
        };
    }

    public <T> T getState(Class<T> type) {
        return type.cast(this.accessibleState.get(type));
    }

    public <T> void putState(T state) {
        this.accessibleState.put(state.getClass(), state);
        this.dependencies.satisfyDependency(state);
    }

    public void importNodes() throws IOException {
        this.importNodes(SchemaMonitors.NO_SCHEMA);
    }

    public void importNodes(SchemaMonitors schemaMonitors) throws IOException {
        this.neoStore.startFlushingPageCache();
        DataImporter.importNodes(this.config, this.input, this.neoStore, this.idMapper, this.badCollector, this.executionMonitor, this.storeUpdateMonitor, this.contextFactory, this.memoryTracker, schemaMonitors);
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
        if (this.storeUpdateMonitor.hasExternallyChosenNodeIds()) {
            this.neoStore.needsRebuildNodeStoreIdFile();
        }
        LongSet otherViolatingNodes = schemaMonitors.validate(this.badCollector, ProgressMonitorFactory.NONE);
        this.prepareIdMapper(otherViolatingNodes);
        schemaMonitors.writeToTarget(this.idMapper.leftOverDuplicateNodesIdsPredicate(), otherViolatingNodes, ProgressMonitorFactory.NONE);
    }

    private void prepareIdMapper(LongSet otherViolatingNodes) {
        if (this.idMapper.needsPreparation()) {
            MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{this.neoStore, this.idMapper});
            this.executeStage(new IdMapperPreparationStage(this.config, this.idMapper, this.inputIdLookup, this.badCollector, otherViolatingNodes, (StatsProvider)memoryUsageStats));
            LongIterator duplicateNodeIds = IdMappers.combineSkipListSorted((LongIterator)this.idMapper.leftOverDuplicateNodesIds(), (LongSet)otherViolatingNodes);
            if (duplicateNodeIds.hasNext()) {
                this.executeStage(new DeleteDuplicateNodesStage(this.config, duplicateNodeIds, this.neoStore.getNeoStores(), this.storeUpdateMonitor, this.contextFactory));
            }
            this.updatePeakMemoryUsage();
        }
    }

    public void importRelationships() throws IOException {
        this.importRelationships(SchemaMonitors.NO_SCHEMA);
    }

    public void removeViolatingRelationships(LongSet violatingRelationships) {
        if (violatingRelationships.notEmpty()) {
            DataStatistics state = this.getState(DataStatistics.class);
            try (DataStatistics.Client client = state.newClient();){
                this.executeStage(new DeleteViolatingRelationshipsStage(this.config, violatingRelationships.longIterator(), this.neoStore.getNeoStores(), this.storeUpdateMonitor, client, this.contextFactory));
            }
        }
    }

    public void importRelationships(SchemaMonitors schemaMonitors) throws IOException {
        this.neoStore.startFlushingPageCache();
        DataStatistics typeDistribution = DataImporter.importRelationships(this.config, this.input, this.neoStore, this.idMapper, this.badCollector, this.executionMonitor, this.storeUpdateMonitor, !this.badCollector.isCollectingBadRelationships(), this.contextFactory, this.memoryTracker, schemaMonitors);
        this.neoStore.stopFlushingPageCache();
        this.updatePeakMemoryUsage();
        this.idMapper.close();
        this.idMapper = null;
        this.putState(typeDistribution);
        LongSet otherViolatingRelationships = schemaMonitors.validate(this.badCollector, ProgressMonitorFactory.NONE);
        schemaMonitors.writeToTarget(null, otherViolatingRelationships, ProgressMonitorFactory.NONE);
        this.removeViolatingRelationships(otherViolatingRelationships);
    }

    public void calculateNodeDegrees() {
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        NodeStore nodeStore = this.neoStore.getNodeStore();
        this.nodeRelationshipCache.setNodeCount(nodeStore.getIdGenerator().getHighId());
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{this.neoStore, this.nodeRelationshipCache});
        NodeDegreeCountStage nodeDegreeStage = new NodeDegreeCountStage(relationshipConfig, this.neoStore.getRelationshipStore(), this.nodeRelationshipCache, (StatsProvider)memoryUsageStats, this.contextFactory);
        this.executeStage(nodeDegreeStage);
        this.nodeRelationshipCache.countingCompleted();
        this.availableMemoryForLinking = this.maxMemory - ImportLogic.totalMemoryUsageOf(new MemoryStatsVisitor.Visitable[]{this.nodeRelationshipCache, this.neoStore});
    }

    public int linkRelationships(int startingFromType, RelationshipLinkingMonitor linkingMonitor) throws IOException {
        assert (startingFromType >= 0) : startingFromType;
        DataStatistics relationshipTypeDistribution = this.getState(DataStatistics.class);
        MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{this.neoStore, this.nodeRelationshipCache});
        int upToType = ImportLogic.nextSetOfTypesThatFitInMemory(relationshipTypeDistribution, startingFromType, this.availableMemoryForLinking, this.nodeRelationshipCache.getNumberOfDenseNodes());
        IntSet typesToLinkThisRound = relationshipTypeDistribution.types(startingFromType, upToType);
        int typesImported = typesToLinkThisRound.size();
        boolean thisIsTheFirstRound = startingFromType == 0;
        boolean thisIsTheLastRound = upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes();
        boolean thisIsTheOnlyRound = thisIsTheFirstRound && thisIsTheLastRound;
        Configuration relationshipConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipStore());
        Configuration nodeConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getNodeStore());
        Configuration groupConfig = ImportLogic.configWithRecordsPerPageBasedBatchSize(this.config, this.neoStore.getRelationshipGroupStore());
        this.nodeRelationshipCache.setForwardScan(true, true);
        String range = typesToLinkThisRound.size() == 1 ? String.valueOf(ImportLogic.oneBased(startingFromType)) : ImportLogic.oneBased(startingFromType) + "-" + (startingFromType + typesImported);
        String topic = " " + range + "/" + relationshipTypeDistribution.getNumberOfRelationshipTypes();
        int nodeTypes = thisIsTheFirstRound ? 3 : 1;
        Predicate<RelationshipRecord> readFilter = thisIsTheFirstRound ? Predicates.alwaysTrue() : record -> typesToLinkThisRound.contains(record.getType());
        Predicate<RelationshipRecord> denseChangeFilter = thisIsTheOnlyRound ? Predicates.alwaysTrue() : record -> typesToLinkThisRound.contains(record.getType());
        Function<CursorContext, StoreCursors> neoStoreCursorCreator = cursorContext -> new CachedStoreCursors(this.neoStore.getNeoStores(), (CursorContext)cursorContext);
        RelationshipLinkforwardStage linkForwardStage = new RelationshipLinkforwardStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, neoStoreCursorCreator, denseChangeFilter, nodeTypes, this.contextFactory, new StatsProvider[]{new RelationshipLinkingProgress(), memoryUsageStats});
        this.executeStage(linkForwardStage);
        this.executeStage(new RelationshipGroupStage(topic, groupConfig, this.neoStore.getTemporaryRelationshipGroupStore(), this.nodeRelationshipCache, this.contextFactory, cursorContext -> new CachedStoreCursors(this.neoStore.getTemporaryNeoStores(), (CursorContext)cursorContext)));
        if (thisIsTheFirstRound) {
            this.executeStage(new SparseNodeFirstRelationshipStage(nodeConfig, this.neoStore.getNodeStore(), this.nodeRelationshipCache, this.contextFactory, cursorContext -> new CachedStoreCursors(this.neoStore.getNeoStores(), (CursorContext)cursorContext)));
        }
        linkingMonitor.forwardLinkingCompleted(startingFromType, upToType, thisIsTheFirstRound, thisIsTheLastRound);
        this.nodeRelationshipCache.setForwardScan(false, true);
        this.executeStage(new RelationshipLinkbackStage(topic, relationshipConfig, this.neoStore, this.nodeRelationshipCache, readFilter, neoStoreCursorCreator, denseChangeFilter, nodeTypes, this.contextFactory, new StatsProvider[]{new RelationshipLinkingProgress(), memoryUsageStats}));
        linkingMonitor.backwardLinkingCompleted(startingFromType, upToType, thisIsTheFirstRound, thisIsTheLastRound);
        this.updatePeakMemoryUsage();
        if (upToType == relationshipTypeDistribution.getNumberOfRelationshipTypes()) {
            this.nodeRelationshipCache.close();
            this.nodeRelationshipCache = null;
            return -1;
        }
        return upToType;
    }

    public void linkRelationshipsOfAllTypes() throws IOException {
        this.linkRelationshipsOfAllTypes(NO_LINKING_MONITOR);
    }

    public void linkRelationshipsOfAllTypes(RelationshipLinkingMonitor linkingMonitor) throws IOException {
        int type = 0;
        while ((type = this.linkRelationships(type, linkingMonitor)) != -1) {
        }
    }

    private static int oneBased(int value) {
        return value + 1;
    }

    static int nextSetOfTypesThatFitInMemory(DataStatistics typeDistribution, int startingFromType, long freeMemoryForDenseNodeCache, long numberOfDenseNodes) {
        DataStatistics.RelationshipTypeCount type;
        long relationshipCountForThisType;
        long memoryUsageUpToAndIncludingThisType;
        int toType;
        long memoryUsageForThisType;
        assert (startingFromType >= 0) : startingFromType;
        long currentSetOfRelationshipsMemoryUsage = 0L;
        int numberOfTypes = typeDistribution.getNumberOfRelationshipTypes();
        for (toType = startingFromType; toType < numberOfTypes && ((memoryUsageUpToAndIncludingThisType = currentSetOfRelationshipsMemoryUsage + (memoryUsageForThisType = NodeRelationshipCache.calculateMaxMemoryUsage((long)numberOfDenseNodes, (long)(relationshipCountForThisType = (type = typeDistribution.get(toType)).getCount())))) <= freeMemoryForDenseNodeCache || currentSetOfRelationshipsMemoryUsage <= 0L); currentSetOfRelationshipsMemoryUsage += memoryUsageForThisType, ++toType) {
        }
        return toType;
    }

    public void defragmentRelationshipGroups() {
        NodeStore nodeStore = this.neoStore.getNodeStore();
        new RelationshipGroupDefragmenter(this.config, this.executionMonitor, RelationshipGroupDefragmenter.Monitor.EMPTY, this.numberArrayFactory, this.contextFactory, this.memoryTracker).run(Long.max(this.maxMemory, this.peakMemoryUsage), this.neoStore, nodeStore.getIdGenerator().getHighId());
    }

    public void buildAuxiliaryStores(LogMetadataProvider logMetadataProvider) {
        this.buildAuxiliaryStores(0L, logMetadataProvider);
    }

    public void buildAuxiliaryStores(final long fromNodeId, final LogMetadataProvider logMetadataProvider) {
        this.neoStore.buildCountsStore(new CountsBuilder(){

            public void initialize(CountsUpdater updater, CursorContext cursorContext, MemoryTracker memoryTracker) {
                MigrationProgressMonitor progressMonitor = MigrationProgressMonitor.SILENT;
                LabelTokenStore labelTokenStore = ImportLogic.this.neoStore.getNeoStores().getLabelTokenStore();
                int highLabelId = Math.toIntExact(labelTokenStore.getIdGenerator().getHighId());
                RelationshipTypeTokenStore relTypeTokenStore = ImportLogic.this.neoStore.getNeoStores().getRelationshipTypeTokenStore();
                int highRelationshipTypeId = Math.toIntExact(relTypeTokenStore.getIdGenerator().getHighId());
                NodeStore nodeStore = ImportLogic.this.neoStore.getNodeStore();
                ImportLogic.this.nodeLabelsCache = new NodeLabelsCache(ImportLogic.this.numberArrayFactory, nodeStore.getIdGenerator().getHighId(), highLabelId, memoryTracker);
                MemoryUsageStatsProvider memoryUsageStats = new MemoryUsageStatsProvider(new MemoryStatsVisitor.Visitable[]{ImportLogic.this.neoStore, ImportLogic.this.nodeLabelsCache});
                Function<CursorContext, StoreCursors> storeCursorsFactory = context -> new CachedStoreCursors(ImportLogic.this.neoStore.getNeoStores(), (CursorContext)context);
                try (ProgressListener progress = progressMonitor.startSection("Nodes");){
                    ImportLogic.this.executeStage(new NodeCountsAndLabelIndexBuildStage(ImportLogic.this.config, ImportLogic.this.neoStore, ImportLogic.this.nodeLabelsCache, ImportLogic.this.neoStore.getNodeStore(), highLabelId, updater, progress, ImportLogic.this.indexImporterFactory, fromNodeId, ImportLogic.this.contextFactory, ImportLogic.this.pageCacheTracer, storeCursorsFactory, memoryTracker, memoryUsageStats));
                }
                progress = progressMonitor.startSection("Relationships");
                try {
                    ImportLogic.this.executeStage(new RelationshipCountsAndTypeIndexBuildStage(ImportLogic.this.config, ImportLogic.this.neoStore, ImportLogic.this.nodeLabelsCache, ImportLogic.this.neoStore.getRelationshipStore(), highLabelId, highRelationshipTypeId, updater, ImportLogic.this.numberArrayFactory, progress, ImportLogic.this.indexImporterFactory, ImportLogic.this.contextFactory, ImportLogic.this.pageCacheTracer, storeCursorsFactory, memoryTracker));
                }
                finally {
                    if (progress != null) {
                        progress.close();
                    }
                }
            }

            public long lastCommittedTxId() {
                return logMetadataProvider.getLastCommittedTransactionId();
            }
        }, logMetadataProvider, this.contextFactory, this.memoryTracker);
    }

    public void success() {
        this.neoStore.success();
        this.successful = true;
    }

    @Override
    public void close() throws IOException {
        long totalTimeMillis = this.startTime > 0L ? System.currentTimeMillis() - this.startTime : 0L;
        DataStatistics state = this.getState(DataStatistics.class);
        String additionalInformation = Objects.toString(state, "Data statistics is not available.");
        this.executionMonitor.done(this.successful, totalTimeMillis, String.format("%n%s%nPeak memory usage: %s", additionalInformation, ByteUnit.bytesToString((long)this.peakMemoryUsage)));
        this.log.info("Import " + (this.successful ? "completed successfully" : "failed") + ", took " + Format.duration((long)totalTimeMillis) + ". " + additionalInformation);
        IOUtils.closeAll((AutoCloseable[])new AutoCloseable[]{this.nodeRelationshipCache, this.nodeLabelsCache, this.idMapper, this.cursorContext, this.numberArrayFactory});
        this.monitor.completed(this.successful);
    }

    private void updatePeakMemoryUsage() {
        this.peakMemoryUsage = Long.max(this.peakMemoryUsage, ImportLogic.totalMemoryUsageOf(new MemoryStatsVisitor.Visitable[]{this.nodeRelationshipCache, this.idMapper, this.neoStore}));
    }

    public static BatchingNeoStores instantiateNeoStores(FileSystemAbstraction fileSystem, RecordDatabaseLayout databaseLayout, PageCacheTracer cacheTracer, Configuration config, LogService logService, AdditionalInitialIds additionalInitialIds, LogMetadataProvider logMetadataProvider, Config dbConfig, JobScheduler scheduler, MemoryTracker memoryTracker, CursorContextFactory contextFactory) {
        logMetadataProvider.setLastCommittedAndClosedTransactionId(additionalInitialIds.lastCommittedTransactionId(), additionalInitialIds.lastCommittedTransactionAppendIndex(), logMetadataProvider.getLastCommittedTransaction().kernelVersion(), additionalInitialIds.lastCommittedTransactionChecksum(), 0L, -1L, additionalInitialIds.lastCommittedTransactionLogByteOffset(), additionalInitialIds.lastCommittedTransactionLogVersion(), additionalInitialIds.lastAppendIndex());
        logMetadataProvider.setCheckpointLogVersion(additionalInitialIds.checkpointLogVersion());
        return BatchingNeoStores.batchingNeoStores(fileSystem, databaseLayout, config, logService, dbConfig, scheduler, cacheTracer, contextFactory, memoryTracker);
    }

    private static long totalMemoryUsageOf(MemoryStatsVisitor.Visitable ... users) {
        GatheringMemoryStatsVisitor total = new GatheringMemoryStatsVisitor();
        for (MemoryStatsVisitor.Visitable user : users) {
            if (user == null) continue;
            user.acceptMemoryStatsVisitor((MemoryStatsVisitor)total);
        }
        return total.getHeapUsage() + total.getOffHeapUsage();
    }

    private static Configuration configWithRecordsPerPageBasedBatchSize(Configuration source, final RecordStore<?> store) {
        return new Configuration.Overridden(source){

            public int batchSize() {
                return store.getRecordsPerPage() * 500;
            }

            public int maxQueueSize() {
                return 10;
            }
        };
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution((ExecutionMonitor)this.executionMonitor, (Stage)stage);
    }

    public static interface RelationshipLinkingMonitor {
        default public void forwardLinkingCompleted(int fromType, int toType, boolean firstRound, boolean lastRound) throws IOException {
        }

        default public void backwardLinkingCompleted(int fromType, int toType, boolean firstRound, boolean lastRound) throws IOException {
        }
    }
}

