/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import org.neo4j.counts.CountsUpdater;
import org.neo4j.internal.batchimport.RecordProcessor;
import org.neo4j.internal.batchimport.cache.legacy.NodeLabelsCache;
import org.neo4j.internal.helpers.progress.ProgressListener;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class NodeCountsProcessor
implements RecordProcessor<NodeRecord> {
    private final NodeStore nodeStore;
    private final long[] labelCounts;
    private final ProgressListener progressListener;
    private final NodeLabelsCache cache;
    private final long fromNodeId;
    private final CountsUpdater counts;
    private final int anyLabel;
    private final NodeLabelsCache.Client cacheClient;

    NodeCountsProcessor(NodeStore nodeStore, NodeLabelsCache cache, int highLabelId, long fromNodeId, CountsUpdater counts, ProgressListener progressReporter) {
        this.nodeStore = nodeStore;
        this.cache = cache;
        this.anyLabel = highLabelId;
        this.fromNodeId = fromNodeId;
        this.counts = counts;
        this.labelCounts = new long[highLabelId + 1];
        this.progressListener = progressReporter;
        this.cacheClient = cache.newClient();
    }

    @Override
    public boolean process(NodeRecord node, StoreCursors storeCursors, MemoryTracker memoryTracker) {
        int[] labels = NodeLabelsField.get(node, this.nodeStore, storeCursors);
        if (labels.length > 0) {
            for (int labelId : labels) {
                if (node.getId() < this.fromNodeId) continue;
                int n = labelId;
                this.labelCounts[n] = this.labelCounts[n] + 1L;
            }
            this.cache.put(this.cacheClient, node.getId(), labels);
        }
        if (node.getId() >= this.fromNodeId) {
            int n = this.anyLabel;
            this.labelCounts[n] = this.labelCounts[n] + 1L;
        }
        this.progressListener.add(1L);
        return false;
    }

    @Override
    public void mergeResultsFrom(RecordProcessor<NodeRecord> other) {
        NodeCountsProcessor o = (NodeCountsProcessor)other;
        for (int i = 0; i < o.labelCounts.length; ++i) {
            int n = i;
            this.labelCounts[n] = this.labelCounts[n] + o.labelCounts[i];
        }
    }

    @Override
    public void done() {
        for (int i = 0; i < this.labelCounts.length; ++i) {
            this.counts.incrementNodeCount(i == this.anyLabel ? -1 : i, this.labelCounts[i]);
        }
    }

    @Override
    public void close() {
    }
}

