/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.CountGroupsStage;
import org.neo4j.internal.batchimport.MemoryUsageStatsProvider;
import org.neo4j.internal.batchimport.NodeFirstGroupStage;
import org.neo4j.internal.batchimport.RelationshipGroupCache;
import org.neo4j.internal.batchimport.ScanAndCacheGroupsStage;
import org.neo4j.internal.batchimport.WriteGroupsStage;
import org.neo4j.internal.batchimport.cache.ByteArray;
import org.neo4j.internal.batchimport.cache.NumberArrayFactory;
import org.neo4j.internal.batchimport.staging.ExecutionMonitor;
import org.neo4j.internal.batchimport.staging.ExecutionSupervisors;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.RelationshipGroupStore;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipGroupDefragmenter {
    private final Configuration config;
    private final ExecutionMonitor executionMonitor;
    private final Monitor monitor;
    private final NumberArrayFactory numberArrayFactory;
    private final CursorContextFactory contextFactory;
    private final MemoryTracker memoryTracker;

    public RelationshipGroupDefragmenter(Configuration config, ExecutionMonitor executionMonitor, Monitor monitor, NumberArrayFactory numberArrayFactory, CursorContextFactory contextFactory, MemoryTracker memoryTracker) {
        this.config = config;
        this.executionMonitor = executionMonitor;
        this.monitor = monitor;
        this.numberArrayFactory = numberArrayFactory;
        this.contextFactory = contextFactory;
        this.memoryTracker = memoryTracker;
    }

    public void run(long memoryWeCanHoldForCertain, BatchingNeoStores neoStore, long highNodeId) {
        try (RelationshipGroupCache groupCache = new RelationshipGroupCache(this.numberArrayFactory, memoryWeCanHoldForCertain, highNodeId, this.memoryTracker);){
            RecordStore<RelationshipGroupRecord> fromStore = neoStore.getTemporaryRelationshipGroupStore();
            RelationshipGroupStore toStore = neoStore.getRelationshipGroupStore();
            Function<CursorContext, StoreCursors> storeCursorCreator = cursorContext -> new CachedStoreCursors(neoStore.getNeoStores(), (CursorContext)cursorContext);
            Configuration groupConfig = Configuration.withBatchSize((Configuration)this.config, (int)neoStore.getRelationshipGroupStore().getRecordsPerPage());
            MemoryUsageStatsProvider memoryUsage = new MemoryUsageStatsProvider(neoStore, groupCache);
            this.executeStage(new CountGroupsStage(groupConfig, fromStore, groupCache, this.contextFactory, new StatsProvider[]{memoryUsage}));
            long fromNodeId = 0L;
            while (fromNodeId < highNodeId) {
                long toNodeId = groupCache.prepare(fromNodeId);
                this.monitor.defragmentingNodeRange(fromNodeId, toNodeId);
                this.executeStage(new ScanAndCacheGroupsStage(groupConfig, fromStore, groupCache, this.contextFactory, new StatsProvider[]{memoryUsage}));
                this.executeStage(new WriteGroupsStage(groupConfig, groupCache, toStore, this.contextFactory, storeCursorCreator));
                fromNodeId = toNodeId;
            }
            ByteArray groupCountCache = groupCache.getGroupCountCache();
            groupCountCache.clear();
            Configuration nodeConfig = Configuration.withBatchSize((Configuration)this.config, (int)neoStore.getNodeStore().getRecordsPerPage());
            this.executeStage(new NodeFirstGroupStage(nodeConfig, toStore, neoStore.getNodeStore(), groupCountCache, this.contextFactory, storeCursorCreator));
        }
    }

    private void executeStage(Stage stage) {
        ExecutionSupervisors.superviseExecution((ExecutionMonitor)this.executionMonitor, (Stage)stage);
    }

    public static interface Monitor {
        public static final Monitor EMPTY = new Monitor(){};

        default public void defragmentingNodeRange(long fromNodeId, long toNodeId) {
        }
    }
}

