/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.Collections;
import java.util.List;
import java.util.function.LongFunction;
import org.eclipse.collections.api.factory.primitive.IntSets;
import org.eclipse.collections.api.map.primitive.IntObjectMap;
import org.eclipse.collections.api.set.primitive.IntSet;
import org.neo4j.batchimport.api.input.ApplicationMode;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.exceptions.KernelException;
import org.neo4j.internal.batchimport.BatchingIdGetter;
import org.neo4j.internal.batchimport.DataImporter;
import org.neo4j.internal.batchimport.DataStatistics;
import org.neo4j.internal.batchimport.EntityImporter;
import org.neo4j.internal.batchimport.SchemaMonitor;
import org.neo4j.internal.batchimport.cache.idmapping.IdMapper;
import org.neo4j.internal.batchimport.input.MissingRelationshipDataException;
import org.neo4j.internal.batchimport.input.csv.Type;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.batchimport.store.PrepareIdSequence;
import org.neo4j.internal.id.IdSequence;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.Record;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.util.IdUpdateListener;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.values.storable.Value;

public class RelationshipImporter
extends EntityImporter {
    private final TokenHolder relationshipTypeTokenRepository;
    private final IdMapper.Getter idMapper;
    private final RelationshipStore relationshipStore;
    private final RelationshipRecord relationshipRecord;
    private final BatchingIdGetter relationshipIds;
    private final DataStatistics.Client typeCounts;
    private final Collector badCollector;
    private final boolean validateRelationshipData;
    private final boolean doubleRecordUnits;
    private final LongFunction<IdSequence> prepareIdSequence;
    private final PageCursor relationshipUpdateCursor;
    private long relationshipCount;
    private Object startId;
    private Group startIdGroup;
    private Object endId;
    private Group endIdGroup;
    private String type;

    protected RelationshipImporter(BatchingNeoStores stores, IdMapper idMapper, DataStatistics typeDistribution, DataImporter.Monitor monitor, Collector badCollector, boolean validateRelationshipData, boolean doubleRecordUnits, CursorContextFactory contextFactory, MemoryTracker memoryTracker, SchemaMonitor schemaMonitor) {
        super(stores, monitor, contextFactory, memoryTracker, schemaMonitor);
        this.doubleRecordUnits = doubleRecordUnits;
        this.relationshipTypeTokenRepository = stores.getTokenHolders().relationshipTypeTokens();
        this.idMapper = idMapper.newGetter();
        this.badCollector = badCollector;
        this.validateRelationshipData = validateRelationshipData;
        this.relationshipStore = stores.getRelationshipStore();
        this.relationshipRecord = (RelationshipRecord)this.relationshipStore.newRecord();
        this.relationshipIds = RelationshipImporter.batchingIdGetter(this.relationshipStore);
        this.typeCounts = typeDistribution.newClient();
        this.prepareIdSequence = (LongFunction)PrepareIdSequence.of(doubleRecordUnits).apply(stores.getRelationshipStore().getIdGenerator());
        this.relationshipUpdateCursor = this.relationshipStore.openPageCursorForWriting(0L, this.cursorContext);
        this.relationshipRecord.setInUse(true);
    }

    @Override
    protected PrimitiveRecord primitiveRecord() {
        return this.relationshipRecord;
    }

    public boolean id(long id) {
        return true;
    }

    public boolean startId(long id) {
        this.relationshipRecord.setFirstNode(id);
        return true;
    }

    public boolean startId(Object id, Group group) {
        this.startId = id;
        this.startIdGroup = group;
        long nodeId = this.nodeId(id, group);
        this.relationshipRecord.setFirstNode(nodeId);
        return true;
    }

    public boolean endId(long id) {
        this.relationshipRecord.setSecondNode(id);
        return true;
    }

    public boolean endId(Object id, Group group) {
        this.endId = id;
        this.endIdGroup = group;
        long nodeId = this.nodeId(id, group);
        this.relationshipRecord.setSecondNode(nodeId);
        return true;
    }

    private long nodeId(Object id, Group group) {
        long nodeId = this.idMapper.get(id, group);
        if (nodeId == -1L) {
            this.relationshipRecord.setInUse(false);
            return -1L;
        }
        return nodeId;
    }

    public boolean type(int typeId) {
        this.relationshipRecord.setType(typeId);
        return true;
    }

    public boolean type(String type) {
        this.type = type;
        try {
            return this.type(this.relationshipTypeTokenRepository.getOrCreateId(type));
        }
        catch (KernelException e) {
            throw new RuntimeException(e);
        }
    }

    public void endOfEntity() {
        if (this.relationshipRecord.inUse() && this.relationshipRecord.getFirstNode() != -1L && this.relationshipRecord.getSecondNode() != -1L && this.relationshipRecord.getType() != -1) {
            this.relationshipRecord.setId(this.relationshipIds.nextId(this.cursorContext));
            SchemaMonitor.Entity entity = new SchemaMonitor.Entity(null, this.relationshipRecord.getId(), (List)this.properties, Collections.emptyList(), null, false, (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.empty(), (IntSet)IntSets.immutable.of(this.relationshipRecord.getType()), (IntSet)IntSets.immutable.empty(), ApplicationMode.CREATE);
            if (this.schemaMonitor.handle(entity, SchemaMonitor.NO_EXISTING_PROPERTY_KEYS_LOOKUP, (e, constraintDescription) -> this.badCollector.collectRelationshipViolatingConstraint(this.namedProperties((IntObjectMap<Value>)e.propertiesMap()), constraintDescription, this.startId, this.startIdGroup, this.type, this.endId, this.endIdGroup), SchemaMonitor.EMPTY_UNIQUENESS_UPDATES_LISTENER)) {
                if (this.doubleRecordUnits) {
                    this.relationshipIds.nextId(this.cursorContext);
                }
                this.relationshipRecord.setNextProp(this.createAndWritePropertyChain(this.cursorContext));
                this.relationshipRecord.setFirstInFirstChain(false);
                this.relationshipRecord.setFirstInSecondChain(false);
                this.relationshipRecord.setFirstPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                this.relationshipRecord.setSecondPrevRel(Record.NO_NEXT_RELATIONSHIP.intValue());
                this.relationshipStore.prepareForCommit(this.relationshipRecord, this.prepareIdSequence.apply(this.relationshipRecord.getId()), this.cursorContext);
                this.relationshipStore.updateRecord(this.relationshipRecord, IdUpdateListener.IGNORE, this.relationshipUpdateCursor, this.cursorContext, this.storeCursors);
                ++this.relationshipCount;
                this.typeCounts.increment(this.relationshipRecord.getType());
            } else {
                RelationshipImporter.freeUnusedId(this.relationshipStore, this.relationshipRecord.getId(), this.cursorContext);
            }
        } else {
            if (this.validateRelationshipData) {
                this.validateNode(this.startId, Type.START_ID);
                this.validateNode(this.endId, Type.END_ID);
                if (this.relationshipRecord.getType() == -1) {
                    throw new MissingRelationshipDataException(Type.TYPE, this.relationshipDataString() + " is missing " + String.valueOf(Type.TYPE) + " field");
                }
            }
            this.badCollector.collectBadRelationship(this.idToReport(this.startId, this.relationshipRecord.getFirstNode()), this.startIdGroup, this.idToReport(this.type, this.relationshipRecord.getType()), this.idToReport(this.endId, this.relationshipRecord.getSecondNode()), this.endIdGroup, this.relationshipRecord.getFirstNode() == -1L ? this.startId : this.endId);
            this.entityPropertyCount = 0;
        }
        this.reset();
    }

    private Object idToReport(Object inputId, long recordFieldId) {
        return inputId != null ? inputId : (recordFieldId != -1L ? Long.valueOf(recordFieldId) : null);
    }

    @Override
    public void reset() {
        super.reset();
        this.relationshipRecord.clear();
        this.relationshipRecord.setInUse(true);
        this.startId = null;
        this.startIdGroup = null;
        this.endId = null;
        this.endIdGroup = null;
        this.type = null;
    }

    private void validateNode(Object id, Type fieldType) {
        if (id == null) {
            throw new MissingRelationshipDataException(fieldType, this.relationshipDataString() + " is missing " + String.valueOf(fieldType) + " field");
        }
    }

    private String relationshipDataString() {
        return String.format("start:%s (%s) type:%s end:%s (%s)", this.startId, this.startIdGroup, this.type, this.endId, this.endIdGroup);
    }

    @Override
    public void close() {
        super.close();
        this.typeCounts.close();
        this.monitor.relationshipsImported(this.relationshipCount);
        this.relationshipUpdateCursor.close();
        this.cursorContext.close();
        this.idMapper.close();
    }

    @Override
    void freeUnusedIds() {
        super.freeUnusedIds();
        this.relationshipIds.markUnusedIdsAsDeleted(this.cursorContext);
    }
}

