/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport;

import java.util.function.Function;
import java.util.function.Predicate;
import org.neo4j.batchimport.api.Configuration;
import org.neo4j.internal.batchimport.RecordIdIterator;
import org.neo4j.internal.batchimport.RelationshipLinkforwardStep;
import org.neo4j.internal.batchimport.UpdateRecordsStep;
import org.neo4j.internal.batchimport.cache.legacy.NodeRelationshipCache;
import org.neo4j.internal.batchimport.staging.BatchFeedStep;
import org.neo4j.internal.batchimport.staging.ReadRecordsStep;
import org.neo4j.internal.batchimport.staging.RecordDataAssembler;
import org.neo4j.internal.batchimport.staging.Stage;
import org.neo4j.internal.batchimport.staging.Step;
import org.neo4j.internal.batchimport.stats.StatsProvider;
import org.neo4j.internal.batchimport.store.BatchingNeoStores;
import org.neo4j.internal.batchimport.store.PrepareIdSequence;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class RelationshipLinkforwardStage
extends Stage {
    public static final String NAME = "Relationship --> Relationship";

    public RelationshipLinkforwardStage(String topic, Configuration config, BatchingNeoStores stores, NodeRelationshipCache cache, Predicate<RelationshipRecord> readFilter, Function<CursorContext, StoreCursors> storeCursorsCreator, Predicate<RelationshipRecord> denseChangeFilter, int nodeTypes, CursorContextFactory contextFactory, StatsProvider ... additionalStatsProvider) {
        super(NAME, topic, config, 3);
        RelationshipStore store = stores.getRelationshipStore();
        this.add((Step)new BatchFeedStep(this.control(), config, RecordIdIterator.forwards((long)0L, (long)store.getIdGenerator().getHighId(), (Configuration)config), store.getRecordSize()));
        this.add((Step)new ReadRecordsStep<RelationshipRecord>(this.control(), config, true, store, contextFactory, new RecordDataAssembler<RelationshipRecord>(store::newRecord, readFilter, true), ReadRecordsStep.NO_MONITOR));
        this.add((Step)new RelationshipLinkforwardStep(this.control(), config, cache, denseChangeFilter, nodeTypes, additionalStatsProvider));
        this.add((Step)new UpdateRecordsStep<RelationshipRecord>(this.control(), config, store, PrepareIdSequence.of(stores.usesDoubleRelationshipRecordUnits()), contextFactory, storeCursorsCreator, RecordCursorTypes.RELATIONSHIP_CURSOR));
    }
}

