/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.util.function.BiConsumer;
import org.neo4j.batchimport.api.Monitor;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.kernel.impl.store.format.RecordFormats;

public class EstimationSanityChecker {
    private final RecordFormats formats;
    private final Monitor monitor;

    public EstimationSanityChecker(RecordFormats formats, Monitor monitor) {
        this.formats = formats;
        this.monitor = monitor;
    }

    public void sanityCheck(Input.Estimates estimates) {
        EstimationSanityChecker.sanityCheckEstimateWithMaxId(estimates.numberOfNodes(), this.formats.node().getMaxId(), (arg_0, arg_1) -> ((Monitor)this.monitor).mayExceedNodeIdCapacity(arg_0, arg_1));
        EstimationSanityChecker.sanityCheckEstimateWithMaxId(estimates.numberOfRelationships(), this.formats.relationship().getMaxId(), (arg_0, arg_1) -> ((Monitor)this.monitor).mayExceedRelationshipIdCapacity(arg_0, arg_1));
    }

    private static void sanityCheckEstimateWithMaxId(long estimate, long max, BiConsumer<Long, Long> reporter) {
        if ((double)estimate > (double)max * 0.8) {
            reporter.accept(max, estimate);
        }
    }
}

