/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import org.neo4j.batchimport.api.ReadBehaviour;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.InputEntityVisitor;
import org.neo4j.common.EntityType;
import org.neo4j.internal.batchimport.input.LenientStoreInput;
import org.neo4j.internal.batchimport.input.LenientStoreInputChunk;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.NodeLabelsField;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.TokenHolder;

class LenientNodeReader
extends LenientStoreInputChunk {
    private final NodeStore nodeStore;
    private final NodeRecord record;
    private final boolean compactNodeStore;

    LenientNodeReader(ReadBehaviour readBehaviour, NodeStore nodeStore, PropertyStore propertyStore, TokenHolders tokenHolders, CursorContextFactory cursorFactory, StoreCursors storeCursors, boolean compactNodeStore, Group group, MemoryTracker memoryTracker) {
        super(readBehaviour, propertyStore, tokenHolders, cursorFactory, storeCursors, storeCursors.readCursor((CursorType)RecordCursorTypes.NODE_CURSOR), group, memoryTracker);
        this.nodeStore = nodeStore;
        this.record = (NodeRecord)nodeStore.newRecord();
        this.compactNodeStore = compactNodeStore;
    }

    @Override
    void readAndVisit(long id, InputEntityVisitor visitor, StoreCursors storeCursors, MemoryTracker memoryTracker) throws IOException {
        this.nodeStore.getRecordByCursor(id, this.record, RecordLoad.LENIENT_CHECK, this.cursor, memoryTracker);
        if (this.record.inUse()) {
            this.nodeStore.ensureHeavy(this.record, storeCursors, memoryTracker);
            int[] labelIds = NodeLabelsField.parseLabelsField(this.record).get(this.nodeStore, storeCursors);
            String[] labels = this.toNames(this.tokenHolders.labelTokens(), labelIds);
            if (this.readBehaviour.shouldIncludeNode(id, labels)) {
                labels = this.readBehaviour.filterLabels(labels);
                if (this.compactNodeStore) {
                    visitor.id((Object)id, this.group);
                } else {
                    visitor.id((Object)id, this.group, cursorContext -> id);
                }
                visitor.labels(labels);
                this.visitPropertyChainNoThrow(visitor, this.record, EntityType.NODE, labels, memoryTracker);
                visitor.endOfEntity();
            }
        } else {
            this.readBehaviour.unused();
        }
    }

    private String[] toNames(TokenHolder labelTokens, int[] labelIds) {
        String[] names = new String[labelIds.length];
        for (int i = 0; i < labelIds.length; ++i) {
            names[i] = LenientStoreInput.getTokenByIdSafe(labelTokens, labelIds[i]).name();
        }
        return names;
    }

    @Override
    String recordType() {
        return "Node";
    }

    @Override
    boolean shouldIncludeProperty(ReadBehaviour readBehaviour, String key, String[] owningEntityTokens) {
        return readBehaviour.shouldIncludeNodeProperty(key, owningEntityTokens, true);
    }
}

