/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.input;

import java.io.IOException;
import java.io.UncheckedIOException;
import org.neo4j.batchimport.api.InputIterable;
import org.neo4j.batchimport.api.ReadBehaviour;
import org.neo4j.batchimport.api.input.Collector;
import org.neo4j.batchimport.api.input.Group;
import org.neo4j.batchimport.api.input.IdType;
import org.neo4j.batchimport.api.input.Input;
import org.neo4j.batchimport.api.input.InputChunk;
import org.neo4j.batchimport.api.input.PropertySizeCalculator;
import org.neo4j.batchimport.api.input.ReadableGroups;
import org.neo4j.internal.batchimport.input.Groups;
import org.neo4j.internal.batchimport.input.LenientInputChunkIterator;
import org.neo4j.internal.batchimport.input.LenientNodeReader;
import org.neo4j.internal.batchimport.input.LenientRelationshipReader;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.io.pagecache.context.CursorContextFactory;
import org.neo4j.kernel.impl.store.CommonAbstractStore;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.NodeStore;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreHeader;
import org.neo4j.kernel.impl.store.cursor.CachedStoreCursors;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.StoreCursors;
import org.neo4j.token.TokenHolders;
import org.neo4j.token.api.NamedToken;
import org.neo4j.token.api.TokenHolder;
import org.neo4j.token.api.TokenNotFoundException;

public class LenientStoreInput
implements Input {
    private final PropertyStore propertyStore;
    private final NodeStore nodeStore;
    private final RelationshipStore relationshipStore;
    private final NeoStores neoStores;
    private final TokenHolders tokenHolders;
    private final boolean compactNodeIdSpace;
    private final CursorContextFactory contextFactory;
    private final ReadBehaviour readBehaviour;
    private final Groups groups = new Groups();
    private final Group inputGroup = this.groups.getOrCreate(null);
    private final MemoryTracker memoryTracker;

    public LenientStoreInput(NeoStores neoStores, TokenHolders tokenHolders, boolean compactNodeIdSpace, CursorContextFactory contextFactory, ReadBehaviour readBehaviour, MemoryTracker memoryTracker) {
        this.propertyStore = neoStores.getPropertyStore();
        this.nodeStore = neoStores.getNodeStore();
        this.relationshipStore = neoStores.getRelationshipStore();
        this.neoStores = neoStores;
        this.tokenHolders = tokenHolders;
        this.compactNodeIdSpace = compactNodeIdSpace;
        this.contextFactory = contextFactory;
        this.readBehaviour = readBehaviour;
        this.memoryTracker = memoryTracker;
    }

    public InputIterable nodes(Collector badCollector) {
        return () -> new LenientInputChunkIterator(this.nodeStore){

            public InputChunk newChunk() {
                return new LenientNodeReader(LenientStoreInput.this.readBehaviour, LenientStoreInput.this.nodeStore, LenientStoreInput.this.propertyStore, LenientStoreInput.this.tokenHolders, LenientStoreInput.this.contextFactory, (StoreCursors)new CachedStoreCursors(LenientStoreInput.this.neoStores, CursorContext.NULL_CONTEXT), LenientStoreInput.this.compactNodeIdSpace, LenientStoreInput.this.inputGroup, LenientStoreInput.this.memoryTracker);
            }
        };
    }

    public InputIterable relationships(Collector badCollector) {
        return () -> new LenientInputChunkIterator(this.relationshipStore){

            public InputChunk newChunk() {
                return new LenientRelationshipReader(LenientStoreInput.this.readBehaviour, LenientStoreInput.this.relationshipStore, LenientStoreInput.this.propertyStore, LenientStoreInput.this.tokenHolders, LenientStoreInput.this.contextFactory, (StoreCursors)new CachedStoreCursors(LenientStoreInput.this.neoStores, CursorContext.NULL_CONTEXT), LenientStoreInput.this.inputGroup, LenientStoreInput.this.memoryTracker);
            }
        };
    }

    public IdType idType() {
        return IdType.INTEGER;
    }

    public ReadableGroups groups() {
        return this.groups;
    }

    public Input.Estimates validateAndEstimate(PropertySizeCalculator valueSizeCalculator) {
        long propertyStoreSize = LenientStoreInput.storeSize(this.propertyStore) / 2L + LenientStoreInput.storeSize(this.propertyStore.getStringStore()) / 2L + LenientStoreInput.storeSize(this.propertyStore.getArrayStore()) / 2L;
        return Input.knownEstimates((long)this.nodeStore.getIdGenerator().getHighId(), (long)this.relationshipStore.getIdGenerator().getHighId(), (long)this.propertyStore.getIdGenerator().getHighId(), (long)this.propertyStore.getIdGenerator().getHighId(), (long)(propertyStoreSize / 2L), (long)(propertyStoreSize / 2L), (long)this.tokenHolders.labelTokens().size());
    }

    public boolean containsVectorData() {
        return false;
    }

    public void close() {
        this.neoStores.close();
    }

    private static long storeSize(CommonAbstractStore<? extends AbstractBaseRecord, ? extends StoreHeader> store) {
        try {
            return store.getStoreSize();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    static NamedToken getTokenByIdSafe(TokenHolder tokenHolder, int id) {
        try {
            return tokenHolder.getTokenById(id);
        }
        catch (TokenNotFoundException e) {
            throw new RuntimeException(e);
        }
    }
}

