/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.batchimport.staging;

import org.neo4j.batchimport.api.Monitor;
import org.neo4j.internal.helpers.progress.ProgressMonitorFactory;

class WeightedExternalProgressReporter
implements AutoCloseable {
    private final Monitor monitor;
    private int overallPercentage;
    private double weight;

    WeightedExternalProgressReporter(Monitor monitor) {
        this.monitor = monitor;
    }

    ProgressMonitorFactory.IndicatorListener next(final double weight) {
        this.overallPercentage = (int)((double)this.overallPercentage + 100.0 * this.weight);
        this.weight = weight;
        return new ProgressMonitorFactory.PercentageIndicatorListener(1){
            private int lastLocalPercentage;

            public void percentage(int percentage) {
                int localWeightedPercentage = (int)((double)percentage * weight);
                if (localWeightedPercentage > this.lastLocalPercentage) {
                    WeightedExternalProgressReporter.this.monitor.percentageCompleted(WeightedExternalProgressReporter.this.overallPercentage + localWeightedPercentage);
                    this.lastLocalPercentage = localWeightedPercentage;
                }
            }
        };
    }

    @Override
    public void close() {
        if (this.overallPercentage < 100) {
            this.monitor.percentageCompleted(100);
            this.overallPercentage = 100;
        }
    }
}

