/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.concurrent.atomic.AtomicLong;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;

abstract class BaseRecordScan<C extends PrimitiveRecord> {
    private final AtomicLong nextStart = new AtomicLong(0L);

    BaseRecordScan() {
    }

    boolean scanBatch(long sizeHint, C cursor) {
        if (sizeHint > 0L) {
            long start = this.nextStart.getAndUpdate(operand -> this.overflowSafeAdd(operand, sizeHint));
            long stopInclusive = this.overflowSafeAdd(start, sizeHint - 1L);
            return this.scanRange(cursor, start, stopInclusive);
        }
        long start = this.nextStart.get();
        return this.scanRange(cursor, start, start - 1L);
    }

    abstract boolean scanRange(C var1, long var2, long var4);

    private long overflowSafeAdd(long a, long b) {
        long result = a + b;
        return result >= 0L ? result : Long.MAX_VALUE;
    }
}

