/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import org.neo4j.collection.diffset.MutableLongDiffSets;
import org.neo4j.collection.diffset.TrackableDiffSets;
import org.neo4j.collection.factory.CollectionsFactory;
import org.neo4j.collection.factory.OnHeapCollectionsFactory;
import org.neo4j.internal.id.IdGenerator;
import org.neo4j.internal.id.IdGeneratorFactory;
import org.neo4j.internal.id.IdType;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.RecordIdType;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.DynamicRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PropertyBlock;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.memory.EmptyMemoryTracker;
import org.neo4j.memory.MemoryTracker;

public class IdRollbackTransactionApplier
extends TransactionApplier.Adapter {
    private final IdGeneratorFactory idGeneratorFactory;
    private final CursorContext cursorContext;
    private final Map<RecordIdType, MutableLongDiffSets> idMaps = new EnumMap<RecordIdType, MutableLongDiffSets>(RecordIdType.class);

    public IdRollbackTransactionApplier(IdGeneratorFactory idGeneratorFactory, CursorContext cursorContext) {
        this.idGeneratorFactory = idGeneratorFactory;
        this.cursorContext = cursorContext;
    }

    @Override
    public boolean visitNodeCommand(Command.NodeCommand command) {
        this.checkId(command, RecordIdType.NODE);
        this.checkDynamicLabels(command);
        return false;
    }

    private void checkDynamicLabels(Command.NodeCommand command) {
        List<DynamicRecord> dynamicRecordsBefore = ((NodeRecord)command.getBefore()).getDynamicLabelRecords();
        List<DynamicRecord> dynamicRecordsAfter = ((NodeRecord)command.getAfter()).getDynamicLabelRecords();
        if (!dynamicRecordsAfter.isEmpty() || !dynamicRecordsBefore.isEmpty()) {
            MutableLongDiffSets diffSet = this.idMaps.computeIfAbsent(RecordIdType.NODE_LABELS, type -> IdRollbackTransactionApplier.getLongDiffSets());
            IdRollbackTransactionApplier.markIds(dynamicRecordsAfter, diffSet);
            IdRollbackTransactionApplier.markIdsUsed(dynamicRecordsBefore, diffSet);
        }
    }

    @Override
    public boolean visitRelationshipCommand(Command.RelationshipCommand command) {
        this.checkId(command, RecordIdType.RELATIONSHIP);
        return false;
    }

    @Override
    public boolean visitPropertyCommand(Command.PropertyCommand command) {
        this.checkId(command, RecordIdType.PROPERTY);
        MutableLongDiffSets stringBlockDiffs = this.idMaps.computeIfAbsent(RecordIdType.STRING_BLOCK, type -> IdRollbackTransactionApplier.getLongDiffSets());
        MutableLongDiffSets arrayBlockDiffs = this.idMaps.computeIfAbsent(RecordIdType.ARRAY_BLOCK, type -> IdRollbackTransactionApplier.getLongDiffSets());
        for (PropertyBlock block : ((PropertyRecord)command.getAfter()).propertyBlocks()) {
            switch (block.getType()) {
                case STRING: {
                    IdRollbackTransactionApplier.markIds(block.getValueRecords(), stringBlockDiffs);
                    break;
                }
                case ARRAY: {
                    IdRollbackTransactionApplier.markIds(block.getValueRecords(), arrayBlockDiffs);
                    break;
                }
            }
        }
        for (PropertyBlock block : ((PropertyRecord)command.getBefore()).propertyBlocks()) {
            switch (block.getType()) {
                case STRING: {
                    IdRollbackTransactionApplier.markIdsUsed(block.getValueRecords(), stringBlockDiffs);
                    break;
                }
                case ARRAY: {
                    IdRollbackTransactionApplier.markIdsUsed(block.getValueRecords(), arrayBlockDiffs);
                    break;
                }
            }
        }
        return false;
    }

    @Override
    public boolean visitRelationshipGroupCommand(Command.RelationshipGroupCommand command) {
        this.checkId(command, RecordIdType.RELATIONSHIP_GROUP);
        return false;
    }

    private <T extends AbstractBaseRecord> void checkId(Command.BaseCommand<T> command, RecordIdType idType) {
        T commandAfter = command.getAfter();
        if (((AbstractBaseRecord)commandAfter).isCreated()) {
            this.idMaps.computeIfAbsent(idType, type -> IdRollbackTransactionApplier.getLongDiffSets()).remove(((AbstractBaseRecord)commandAfter).getId());
        } else if (!((AbstractBaseRecord)commandAfter).inUse()) {
            this.idMaps.computeIfAbsent(idType, type -> IdRollbackTransactionApplier.getLongDiffSets()).add(((AbstractBaseRecord)commandAfter).getId());
        }
    }

    @Override
    public void close() throws Exception {
        this.idGeneratorFactory.notifyTransactionRollback(this.cursorContext.getVersionContext().committingTransactionId());
        this.idMaps.forEach((type, longDiffSets) -> {
            IdGenerator idGenerator = this.idGeneratorFactory.get((IdType)type);
            try (IdGenerator.TransactionalMarker marker = idGenerator.transactionalMarker(this.cursorContext);){
                longDiffSets.getAdded().forEach(arg_0 -> ((IdGenerator.TransactionalMarker)marker).markUsed(arg_0));
                longDiffSets.getRemoved().forEach(arg_0 -> ((IdGenerator.TransactionalMarker)marker).markDeletedAndFree(arg_0));
            }
        });
    }

    private static MutableLongDiffSets getLongDiffSets() {
        return TrackableDiffSets.newMutableLongDiffSets((CollectionsFactory)OnHeapCollectionsFactory.INSTANCE, (MemoryTracker)EmptyMemoryTracker.INSTANCE);
    }

    private static void markIdsUsed(List<DynamicRecord> block, MutableLongDiffSets diffs) {
        for (DynamicRecord valueRecord : block) {
            diffs.add(valueRecord.getId());
        }
    }

    private static void markIds(List<DynamicRecord> dynamicRecordsAfter, MutableLongDiffSets diffSet) {
        for (DynamicRecord dynamicRecord : dynamicRecordsAfter) {
            if (dynamicRecord.inUse()) {
                diffSet.remove(dynamicRecord.getId());
                continue;
            }
            diffSet.add(dynamicRecord.getId());
        }
    }
}

