/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.neo4j.common.Subject;
import org.neo4j.internal.indexcommand.IndexCommandConversion;
import org.neo4j.internal.indexcommand.IndexCommandSelector;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.recordstorage.BatchContext;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.IndexActivator;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.internal.recordstorage.TransactionApplierFactory;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.SchemaCache;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.context.CursorContext;
import org.neo4j.storageengine.api.IndexEntryUpdate;
import org.neo4j.storageengine.api.IndexUpdateListener;
import org.neo4j.storageengine.api.StorageEngineTransaction;
import org.neo4j.storageengine.api.TransactionApplicationMode;
import org.neo4j.storageengine.util.IndexUpdatesWorkSync;

public class IndexCommandTransactionApplierFactory
implements TransactionApplierFactory {
    private final IndexUpdateListener indexUpdateListener;
    private final SchemaCache schemaCache;
    private final TransactionApplicationMode mode;
    private final IndexUpdatesWorkSync indexUpdatesSync;

    public IndexCommandTransactionApplierFactory(IndexUpdateListener indexUpdateListener, IndexUpdatesWorkSync indexUpdatesSync, SchemaCache schemaCache, TransactionApplicationMode mode) {
        this.indexUpdateListener = indexUpdateListener;
        this.indexUpdatesSync = indexUpdatesSync;
        this.schemaCache = schemaCache;
        this.mode = mode;
    }

    @Override
    public TransactionApplier startTx(StorageEngineTransaction transaction, BatchContext batchContext) {
        IndexCommandSelector commandSelector = this.mode.isReverseStep() ? IndexCommandSelector.REVERSE : IndexCommandSelector.NORMAL;
        return new SingleTransactionApplier(transaction, batchContext, transaction.cursorContext(), commandSelector);
    }

    private class SingleTransactionApplier
    extends TransactionApplier.Adapter {
        private final Subject subject;
        private List<IndexDescriptor> createdIndexes;
        private final IndexActivator indexActivator;
        private final CursorContext cursorContext;
        private final IndexCommandSelector commandSelector;
        private final List<IndexEntryUpdate> indexUpdates = new ArrayList<IndexEntryUpdate>();

        SingleTransactionApplier(StorageEngineTransaction transaction, BatchContext batchContext, CursorContext cursorContext, IndexCommandSelector commandSelector) {
            this.subject = transaction.subject();
            this.indexActivator = batchContext.getIndexActivator();
            this.cursorContext = cursorContext;
            this.commandSelector = commandSelector;
        }

        @Override
        public void close() throws IOException {
            if (!this.indexUpdates.isEmpty()) {
                try (IndexUpdatesWorkSync.Batch indexUpdatesBatch = IndexCommandTransactionApplierFactory.this.indexUpdatesSync.newBatch(this.cursorContext);){
                    indexUpdatesBatch.indexUpdates(this.indexUpdates);
                    indexUpdatesBatch.applyAsync();
                }
            }
            if (this.createdIndexes != null) {
                IndexCommandTransactionApplierFactory.this.indexUpdateListener.createIndexes(this.subject, this.cursorContext, this.createdIndexes.toArray(new IndexDescriptor[0]));
                this.createdIndexes = null;
            }
        }

        @Override
        public boolean visitIndexUpdateCommand(IndexUpdateCommand<?> command) {
            IndexCommandConversion.convertCommandToIndexEntryUpdate(command, arg_0 -> ((SchemaCache)IndexCommandTransactionApplierFactory.this.schemaCache).getIndex(arg_0), (IndexCommandSelector)this.commandSelector).ifPresent(this.indexUpdates::add);
            return false;
        }

        @Override
        public boolean visitSchemaRuleCommand(Command.SchemaRuleCommand command) {
            SchemaRule schemaRule = command.getSchemaRule();
            this.processSchemaCommand(command.getMode(), schemaRule);
            return false;
        }

        private void processSchemaCommand(Command.Mode commandMode, SchemaRule schemaRule) {
            if (schemaRule instanceof IndexDescriptor) {
                IndexDescriptor indexRule = (IndexDescriptor)schemaRule;
                switch (commandMode) {
                    case UPDATE: {
                        if (!indexRule.isUnique()) break;
                        this.indexActivator.activateIndex(indexRule);
                        break;
                    }
                    case CREATE: {
                        this.createdIndexes = this.createdIndexes == null ? new ArrayList() : this.createdIndexes;
                        this.createdIndexes.add(indexRule);
                        break;
                    }
                    case DELETE: {
                        IndexCommandTransactionApplierFactory.this.indexUpdateListener.dropIndex(indexRule);
                        this.indexActivator.indexDropped(indexRule);
                    }
                }
            }
        }
    }
}

