/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.kernel.api.exceptions.DeletedNodeStillHasRelationshipsException;
import org.neo4j.internal.kernel.api.exceptions.TransactionFailureException;
import org.neo4j.internal.schema.ConstraintDescriptor;
import org.neo4j.internal.schema.IndexDescriptor;
import org.neo4j.internal.schema.IndexType;
import org.neo4j.internal.schema.SchemaDescriptor;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.internal.schema.constraints.PropertyTypeSet;
import org.neo4j.internal.schema.constraints.TypeRepresentation;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.api.exceptions.Status;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.Record;

class IntegrityValidator {
    IntegrityValidator() {
    }

    static void validateNodeRecord(NodeRecord record) throws TransactionFailureException {
        if (!record.inUse() && record.getNextRel() != (long)Record.NO_NEXT_RELATIONSHIP.intValue()) {
            throw DeletedNodeStillHasRelationshipsException.nodeStillHasRelationships((long)record.getId());
        }
    }

    static void validateSchemaRule(SchemaRule schemaRule, KernelVersion kernelVersion) throws TransactionFailureException {
        if (kernelVersion.isAtLeast(KernelVersion.LATEST_SCHEMA_CHANGE)) {
            return;
        }
        if (schemaRule instanceof IndexDescriptor) {
            IndexDescriptor index = (IndexDescriptor)schemaRule;
            String schemaType = "index";
            SchemaDescriptor schema = index.schema();
            if (index.getIndexType() == IndexType.VECTOR) {
                switch (schema.entityType()) {
                    case NODE: {
                        if (!kernelVersion.isLessThan(KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED)) break;
                        throw IntegrityValidator.upgradeNeededForSchemaRule("index", (SchemaRule)index, kernelVersion, KernelVersion.VERSION_NODE_VECTOR_INDEX_INTRODUCED);
                    }
                    case RELATIONSHIP: {
                        if (!kernelVersion.isLessThan(KernelVersion.VERSION_VECTOR_2_INTRODUCED)) break;
                        throw IntegrityValidator.upgradeNeededForSchemaRule("index", (SchemaRule)index, kernelVersion, KernelVersion.VERSION_VECTOR_2_INTRODUCED);
                    }
                }
                if ((schema.getEntityTokenIds().length > 1 || schema.getPropertyIds().length > 1) && kernelVersion.isLessThan(KernelVersion.VERSION_VECTOR_INDEX_SINGLE_STAGE_FILTERING)) {
                    throw IntegrityValidator.upgradeNeededForSchemaRule("index", (SchemaRule)index, kernelVersion, KernelVersion.VERSION_VECTOR_INDEX_SINGLE_STAGE_FILTERING);
                }
            }
        } else if (schemaRule instanceof ConstraintDescriptor) {
            ConstraintDescriptor constraint = (ConstraintDescriptor)schemaRule;
            String schemaType = "constraint";
            if ((constraint.isRelationshipUniquenessConstraint() || constraint.isRelationshipKeyConstraint()) && kernelVersion.isLessThan(KernelVersion.VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED)) {
                throw IntegrityValidator.upgradeNeededForSchemaRule("constraint", (SchemaRule)constraint, kernelVersion, KernelVersion.VERSION_REL_UNIQUE_CONSTRAINTS_INTRODUCED);
            }
            if (constraint.isPropertyTypeConstraint()) {
                if (kernelVersion.isLessThan(KernelVersion.VERSION_TYPE_CONSTRAINTS_INTRODUCED)) {
                    throw IntegrityValidator.upgradeNeededForSchemaRule("constraint", (SchemaRule)constraint, kernelVersion, KernelVersion.VERSION_TYPE_CONSTRAINTS_INTRODUCED);
                }
                PropertyTypeSet propertyType = constraint.asPropertyTypeConstraint().propertyType();
                if ((TypeRepresentation.isUnion((PropertyTypeSet)propertyType) || TypeRepresentation.hasListTypes((PropertyTypeSet)propertyType)) && kernelVersion.isLessThan(KernelVersion.VERSION_UNIONS_AND_LIST_TYPE_CONSTRAINTS_INTRODUCED)) {
                    throw IntegrityValidator.upgradeNeededForSchemaRule("constraint", (SchemaRule)constraint, kernelVersion, KernelVersion.VERSION_UNIONS_AND_LIST_TYPE_CONSTRAINTS_INTRODUCED);
                }
                if (TypeRepresentation.hasVectorTypes((PropertyTypeSet)propertyType) && kernelVersion.isLessThan(KernelVersion.VERSION_VECTOR_TYPE_INTRODUCED)) {
                    throw IntegrityValidator.upgradeNeededForSchemaRule("constraint", (SchemaRule)constraint, kernelVersion, KernelVersion.VERSION_VECTOR_TYPE_INTRODUCED);
                }
            }
            if (constraint.isNodeLabelExistenceConstraint() && kernelVersion.isLessThan(KernelVersion.VERSION_RELATIONSHIP_ENDPOINT_LABEL_AND_LABEL_EXISTENCE_CONSTRAINTS_INTRODUCED)) {
                throw IntegrityValidator.upgradeNeededForSchemaRule("constraint", (SchemaRule)constraint, kernelVersion, KernelVersion.VERSION_RELATIONSHIP_ENDPOINT_LABEL_AND_LABEL_EXISTENCE_CONSTRAINTS_INTRODUCED);
            }
        } else {
            throw new IllegalArgumentException("Unknown %s. Provided: %s".formatted(SchemaRule.class.getSimpleName(), schemaRule));
        }
    }

    private static TransactionFailureException upgradeNeededForSchemaRule(String schemaType, SchemaRule schemaRule, KernelVersion actualVersion, KernelVersion requiredVersion) {
        return TransactionFailureException.internalError((Status)Status.General.UpgradeRequired, (String)IntegrityValidator.class.getSimpleName(), (String)"Operations on %s '%s' not allowed. Required kernel version for this transaction is %s, but actual version was %s.", (Object[])new Object[]{schemaType, schemaRule, requiredVersion.name(), actualVersion.name()});
    }
}

