/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.helpers.Numbers;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.internal.recordstorage.TransactionApplier;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.database.MetadataCache;
import org.neo4j.kernel.impl.store.record.MetaDataRecord;
import org.neo4j.kernel.impl.transaction.log.entry.LogFormat;
import org.neo4j.logging.InternalLog;
import org.neo4j.logging.InternalLogProvider;

public class KernelVersionTransactionApplier
extends TransactionApplier.Adapter {
    private final MetadataCache metadataCache;
    private final InternalLog log;

    public KernelVersionTransactionApplier(MetadataCache metadataCache, InternalLogProvider userLogProvider) {
        this.metadataCache = metadataCache;
        this.log = userLogProvider.getLog(this.getClass());
    }

    @Override
    public boolean visitMetaDataCommand(Command.MetaDataCommand command) {
        int value = Numbers.safeCastLongToInt((long)((MetaDataRecord)command.getAfter()).getValue());
        KernelVersion kernelVersion = KernelVersion.getForVersion((byte)((byte)(value & 0xFF)));
        byte logFormatVersion = (byte)(value >> 8 & 0xFF);
        this.log.info("Applying metadata upgrade command: " + String.valueOf(command) + " previous KernelVersion " + String.valueOf(this.metadataCache.kernelVersion()) + " previous LogFormat " + String.valueOf(this.metadataCache.getCurrentLogFormat()));
        this.metadataCache.setKernelVersion(kernelVersion);
        this.metadataCache.setCurrentLogFormat(logFormatVersion == 0 ? LogFormat.fromKernelVersion((KernelVersion)kernelVersion) : LogFormat.fromByteVersion((byte)logFormatVersion));
        return false;
    }
}

