/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import org.neo4j.internal.recordstorage.RecordAccess;
import org.neo4j.internal.recordstorage.RecordCursorTypes;
import org.neo4j.internal.schema.SchemaRule;
import org.neo4j.io.pagecache.PageCursor;
import org.neo4j.kernel.impl.store.NeoStores;
import org.neo4j.kernel.impl.store.PropertyStore;
import org.neo4j.kernel.impl.store.RecordStore;
import org.neo4j.kernel.impl.store.SchemaStore;
import org.neo4j.kernel.impl.store.record.AbstractBaseRecord;
import org.neo4j.kernel.impl.store.record.LabelTokenRecord;
import org.neo4j.kernel.impl.store.record.NodeRecord;
import org.neo4j.kernel.impl.store.record.PrimitiveRecord;
import org.neo4j.kernel.impl.store.record.PropertyKeyTokenRecord;
import org.neo4j.kernel.impl.store.record.PropertyRecord;
import org.neo4j.kernel.impl.store.record.RecordLoad;
import org.neo4j.kernel.impl.store.record.RelationshipGroupRecord;
import org.neo4j.kernel.impl.store.record.RelationshipRecord;
import org.neo4j.kernel.impl.store.record.RelationshipTypeTokenRecord;
import org.neo4j.kernel.impl.store.record.SchemaRecord;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.cursor.CursorType;
import org.neo4j.storageengine.api.cursor.StoreCursors;

public class Loaders {
    private final RecordStore<NodeRecord> nodeStore;
    private final PropertyStore propertyStore;
    private final RecordStore<RelationshipRecord> relationshipStore;
    private final RecordStore<RelationshipGroupRecord> relationshipGroupStore;
    private final RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore;
    private final RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore;
    private final RecordStore<LabelTokenRecord> labelTokenStore;
    private final SchemaStore schemaStore;
    private final StoreCursors storeCursors;
    private RecordLoader<NodeRecord, Void> nodeLoader;
    private RecordLoader<PropertyRecord, PrimitiveRecord> propertyLoader;
    private RecordLoader<RelationshipRecord, Void> relationshipLoader;
    private RecordLoader<RelationshipGroupRecord, Integer> relationshipGroupLoader;
    private RecordLoader<SchemaRecord, SchemaRule> schemaRuleLoader;
    private RecordLoader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader;
    private RecordLoader<LabelTokenRecord, Void> labelTokenLoader;
    private RecordLoader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader;

    public Loaders(NeoStores neoStores, StoreCursors storeCursors) {
        this(neoStores.getNodeStore(), neoStores.getPropertyStore(), neoStores.getRelationshipStore(), neoStores.getRelationshipGroupStore(), neoStores.getPropertyKeyTokenStore(), neoStores.getRelationshipTypeTokenStore(), neoStores.getLabelTokenStore(), neoStores.getSchemaStore(), storeCursors);
    }

    public Loaders(RecordStore<NodeRecord> nodeStore, PropertyStore propertyStore, RecordStore<RelationshipRecord> relationshipStore, RecordStore<RelationshipGroupRecord> relationshipGroupStore, RecordStore<PropertyKeyTokenRecord> propertyKeyTokenStore, RecordStore<RelationshipTypeTokenRecord> relationshipTypeTokenStore, RecordStore<LabelTokenRecord> labelTokenStore, SchemaStore schemaStore, StoreCursors storeCursors) {
        this.nodeStore = nodeStore;
        this.propertyStore = propertyStore;
        this.relationshipStore = relationshipStore;
        this.relationshipGroupStore = relationshipGroupStore;
        this.propertyKeyTokenStore = propertyKeyTokenStore;
        this.relationshipTypeTokenStore = relationshipTypeTokenStore;
        this.labelTokenStore = labelTokenStore;
        this.schemaStore = schemaStore;
        this.storeCursors = storeCursors;
    }

    public RecordAccess.Loader<NodeRecord, Void> nodeLoader() {
        if (this.nodeLoader == null) {
            this.nodeLoader = Loaders.nodeLoader(this.nodeStore, this.storeCursors);
        }
        return this.nodeLoader;
    }

    public RecordAccess.Loader<PropertyRecord, PrimitiveRecord> propertyLoader() {
        if (this.propertyLoader == null) {
            this.propertyLoader = Loaders.propertyLoader(this.propertyStore, this.storeCursors);
        }
        return this.propertyLoader;
    }

    public RecordAccess.Loader<RelationshipRecord, Void> relationshipLoader() {
        if (this.relationshipLoader == null) {
            this.relationshipLoader = Loaders.relationshipLoader(this.relationshipStore, this.storeCursors);
        }
        return this.relationshipLoader;
    }

    public RecordAccess.Loader<RelationshipGroupRecord, Integer> relationshipGroupLoader() {
        if (this.relationshipGroupLoader == null) {
            this.relationshipGroupLoader = Loaders.relationshipGroupLoader(this.relationshipGroupStore, this.storeCursors);
        }
        return this.relationshipGroupLoader;
    }

    public RecordAccess.Loader<SchemaRecord, SchemaRule> schemaRuleLoader() {
        if (this.schemaRuleLoader == null) {
            this.schemaRuleLoader = Loaders.schemaRuleLoader(this.schemaStore, this.storeCursors);
        }
        return this.schemaRuleLoader;
    }

    public RecordAccess.Loader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader() {
        if (this.propertyKeyTokenLoader == null) {
            this.propertyKeyTokenLoader = Loaders.propertyKeyTokenLoader(this.propertyKeyTokenStore, this.storeCursors);
        }
        return this.propertyKeyTokenLoader;
    }

    public RecordAccess.Loader<LabelTokenRecord, Void> labelTokenLoader() {
        if (this.labelTokenLoader == null) {
            this.labelTokenLoader = Loaders.labelTokenLoader(this.labelTokenStore, this.storeCursors);
        }
        return this.labelTokenLoader;
    }

    public RecordAccess.Loader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader() {
        if (this.relationshipTypeTokenLoader == null) {
            this.relationshipTypeTokenLoader = Loaders.relationshipTypeTokenLoader(this.relationshipTypeTokenStore, this.storeCursors);
        }
        return this.relationshipTypeTokenLoader;
    }

    public static RecordLoader<NodeRecord, Void> nodeLoader(RecordStore<NodeRecord> store, StoreCursors storeCursors) {
        return new RecordLoader<NodeRecord, Void>(store, storeCursors, (CursorType)RecordCursorTypes.NODE_CURSOR, NodeRecord.SHALLOW_SIZE){

            @Override
            public NodeRecord newUnused(long key, Void additionalData, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(NodeRecord.SHALLOW_SIZE);
                return Loaders.andMarkAsCreated(new NodeRecord(key));
            }

            @Override
            public NodeRecord copy(NodeRecord nodeRecord, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(NodeRecord.SHALLOW_SIZE);
                return new NodeRecord(nodeRecord);
            }
        };
    }

    public static RecordLoader<PropertyRecord, PrimitiveRecord> propertyLoader(PropertyStore store, StoreCursors storeCursors) {
        return new RecordLoader<PropertyRecord, PrimitiveRecord>((RecordStore)store, storeCursors, (CursorType)RecordCursorTypes.PROPERTY_CURSOR, PropertyRecord.INITIAL_SIZE){

            @Override
            public PropertyRecord newUnused(long key, PrimitiveRecord additionalData, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(PropertyRecord.INITIAL_SIZE);
                PropertyRecord record = new PropertyRecord(key);
                this.setOwner(record, additionalData);
                return Loaders.andMarkAsCreated(record);
            }

            private void setOwner(PropertyRecord record, PrimitiveRecord owner) {
                if (owner != null) {
                    owner.setIdTo(record);
                }
            }

            @Override
            public PropertyRecord load(long key, PrimitiveRecord additionalData, RecordLoad load, MemoryTracker memoryTracker) {
                PropertyRecord record = (PropertyRecord)super.load(key, additionalData, load, memoryTracker);
                this.setOwner(record, additionalData);
                return record;
            }

            @Override
            public PropertyRecord copy(PropertyRecord propertyRecord, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(PropertyRecord.INITIAL_SIZE + propertyRecord.heavyHeapSize);
                return new PropertyRecord(propertyRecord);
            }
        };
    }

    public static RecordLoader<RelationshipRecord, Void> relationshipLoader(RecordStore<RelationshipRecord> store, StoreCursors storeCursors) {
        return new RecordLoader<RelationshipRecord, Void>(store, storeCursors, (CursorType)RecordCursorTypes.RELATIONSHIP_CURSOR, RelationshipRecord.SHALLOW_SIZE){

            @Override
            public RelationshipRecord newUnused(long key, Void additionalData, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(RelationshipRecord.SHALLOW_SIZE);
                return Loaders.andMarkAsCreated(new RelationshipRecord(key));
            }

            @Override
            public RelationshipRecord copy(RelationshipRecord relationshipRecord, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(RelationshipRecord.SHALLOW_SIZE);
                return new RelationshipRecord(relationshipRecord);
            }
        };
    }

    public static RecordLoader<RelationshipGroupRecord, Integer> relationshipGroupLoader(RecordStore<RelationshipGroupRecord> store, StoreCursors storeCursors) {
        return new RecordLoader<RelationshipGroupRecord, Integer>(store, storeCursors, (CursorType)RecordCursorTypes.GROUP_CURSOR, RelationshipGroupRecord.SHALLOW_SIZE){

            @Override
            public RelationshipGroupRecord newUnused(long key, Integer type, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(RelationshipGroupRecord.SHALLOW_SIZE);
                RelationshipGroupRecord record = new RelationshipGroupRecord(key);
                record.setType(type);
                return Loaders.andMarkAsCreated(record);
            }

            @Override
            public RelationshipGroupRecord copy(RelationshipGroupRecord record, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(RelationshipGroupRecord.SHALLOW_SIZE);
                return new RelationshipGroupRecord(record);
            }
        };
    }

    private static RecordLoader<SchemaRecord, SchemaRule> schemaRuleLoader(SchemaStore store, StoreCursors storeCursors) {
        return new RecordLoader<SchemaRecord, SchemaRule>((RecordStore)store, storeCursors, (CursorType)RecordCursorTypes.SCHEMA_CURSOR, SchemaRecord.SHALLOW_SIZE){

            @Override
            public SchemaRecord newUnused(long key, SchemaRule additionalData, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(SchemaRecord.SHALLOW_SIZE);
                return Loaders.andMarkAsCreated(new SchemaRecord(key));
            }

            @Override
            public SchemaRecord copy(SchemaRecord record, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(SchemaRecord.SHALLOW_SIZE);
                return new SchemaRecord(record);
            }
        };
    }

    public static RecordLoader<PropertyKeyTokenRecord, Void> propertyKeyTokenLoader(RecordStore<PropertyKeyTokenRecord> store, StoreCursors storeCursors) {
        return new RecordLoader<PropertyKeyTokenRecord, Void>(store, storeCursors, (CursorType)RecordCursorTypes.PROPERTY_KEY_TOKEN_CURSOR, PropertyKeyTokenRecord.SHALLOW_SIZE){

            @Override
            public PropertyKeyTokenRecord newUnused(long key, Void additionalData, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(PropertyKeyTokenRecord.SHALLOW_SIZE);
                return Loaders.andMarkAsCreated(new PropertyKeyTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public PropertyKeyTokenRecord copy(PropertyKeyTokenRecord record, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(PropertyKeyTokenRecord.SHALLOW_SIZE);
                return new PropertyKeyTokenRecord(record);
            }
        };
    }

    public static RecordLoader<LabelTokenRecord, Void> labelTokenLoader(RecordStore<LabelTokenRecord> store, StoreCursors storeCursors) {
        return new RecordLoader<LabelTokenRecord, Void>(store, storeCursors, (CursorType)RecordCursorTypes.LABEL_TOKEN_CURSOR, LabelTokenRecord.SHALLOW_SIZE){

            @Override
            public LabelTokenRecord newUnused(long key, Void additionalData, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(LabelTokenRecord.SHALLOW_SIZE);
                return Loaders.andMarkAsCreated(new LabelTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public LabelTokenRecord copy(LabelTokenRecord record, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(LabelTokenRecord.SHALLOW_SIZE);
                return new LabelTokenRecord(record);
            }
        };
    }

    public static RecordLoader<RelationshipTypeTokenRecord, Void> relationshipTypeTokenLoader(RecordStore<RelationshipTypeTokenRecord> store, StoreCursors storeCursors) {
        return new RecordLoader<RelationshipTypeTokenRecord, Void>(store, storeCursors, (CursorType)RecordCursorTypes.REL_TYPE_TOKEN_CURSOR, RelationshipTypeTokenRecord.SHALLOW_SIZE){

            @Override
            public RelationshipTypeTokenRecord newUnused(long key, Void additionalData, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(RelationshipTypeTokenRecord.SHALLOW_SIZE);
                return Loaders.andMarkAsCreated(new RelationshipTypeTokenRecord(Math.toIntExact(key)));
            }

            @Override
            public RelationshipTypeTokenRecord copy(RelationshipTypeTokenRecord record, MemoryTracker memoryTracker) {
                memoryTracker.allocateHeap(RelationshipTypeTokenRecord.SHALLOW_SIZE);
                return new RelationshipTypeTokenRecord(record);
            }
        };
    }

    protected static <RECORD extends AbstractBaseRecord> RECORD andMarkAsCreated(RECORD record) {
        record.setCreated();
        return record;
    }

    private static abstract class RecordLoader<R extends AbstractBaseRecord, A>
    implements RecordAccess.Loader<R, A> {
        private final RecordStore<R> store;
        private PageCursor pageCursor;
        private final StoreCursors storeCursors;
        private final CursorType cursorType;
        private final long recordHeapSize;

        RecordLoader(RecordStore<R> store, StoreCursors storeCursors, CursorType cursorType, long recordHeapSize) {
            this.store = store;
            this.storeCursors = storeCursors;
            this.cursorType = cursorType;
            this.recordHeapSize = recordHeapSize;
        }

        @Override
        public void ensureHeavy(R record, StoreCursors storeCursors, MemoryTracker memoryTracker) {
            this.store.ensureHeavy(record, storeCursors, memoryTracker);
        }

        @Override
        public R load(long key, A additionalData, RecordLoad load, MemoryTracker memoryTracker) {
            memoryTracker.allocateHeap(this.recordHeapSize);
            R record = this.store.newRecord();
            this.store.getRecordByCursor(key, record, load, this.getPageCursor(), memoryTracker);
            return record;
        }

        private PageCursor getPageCursor() {
            if (this.pageCursor == null) {
                this.pageCursor = this.storeCursors.readCursor(this.cursorType);
            }
            return this.pageCursor;
        }
    }
}

