/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.io.IOException;
import org.neo4j.internal.indexcommand.IndexCommandSerialization;
import org.neo4j.internal.indexcommand.IndexUpdateCommand;
import org.neo4j.internal.recordstorage.Command;
import org.neo4j.io.fs.ReadableChannel;
import org.neo4j.io.fs.WritableChannel;
import org.neo4j.kernel.KernelVersion;
import org.neo4j.kernel.impl.transaction.log.LogPositionAwareChannel;
import org.neo4j.memory.MemoryTracker;
import org.neo4j.storageengine.api.BaseCommandReader;
import org.neo4j.storageengine.api.StorageCommand;

public abstract class LogCommandSerialization
extends BaseCommandReader
implements IndexCommandSerialization {
    private final KernelVersion kernelVersion;

    LogCommandSerialization(KernelVersion kernelVersion) {
        this.kernelVersion = kernelVersion;
    }

    public KernelVersion kernelVersion() {
        return this.kernelVersion;
    }

    public final StorageCommand read(byte commandType, ReadableChannel channel, MemoryTracker memoryTracker) throws IOException {
        return switch (commandType) {
            case 1 -> this.readNodeCommand(channel);
            case 22 -> this.readCreatedNodeCommand(channel);
            case 23 -> this.readDeletedNodeCommand(channel);
            case 2 -> this.readPropertyCommand(channel);
            case 24 -> this.readCreatedPropertyCommand(channel);
            case 25 -> this.readDeletedPropertyCommand(channel);
            case 5 -> this.readPropertyKeyTokenCommand(channel);
            case 3 -> this.readRelationshipCommand(channel);
            case 26 -> this.readCreatedRelationshipCommand(channel);
            case 27 -> this.readDeletedRelationshipCommand(channel);
            case 4 -> this.readRelationshipTypeTokenCommand(channel);
            case 8 -> this.readLabelTokenCommand(channel);
            case 9 -> this.readRelationshipGroupCommand(channel);
            case 21 -> this.readRelationshipGroupExtendedCommand(channel);
            case 16 -> this.readRelationshipCountsCommand(channel);
            case 17 -> this.readNodeCountsCommand(channel);
            case 18 -> this.readSchemaRuleCommand(channel);
            case 7 -> this.readLegacySchemaRuleCommand(channel);
            case 6 -> this.readNeoStoreCommand(channel);
            case 19 -> this.readMetaDataCommand(channel);
            case 20 -> this.readGroupDegreeCommand(channel);
            case 30 -> this.readEnrichmentCommand(channel);
            case 28 -> this.readIndexUpdateCommand(channel);
            case 10 -> this.readIndexDefineCommand(channel);
            case 11 -> this.readIndexAddNodeCommand(channel);
            case 12 -> this.readIndexAddRelationshipCommand(channel);
            case 13 -> this.readIndexRemoveCommand(channel);
            case 14 -> this.readIndexDeleteCommand(channel);
            case 15 -> this.readIndexCreateCommand(channel);
            default -> throw LogCommandSerialization.unknownCommandType(commandType, channel);
        };
    }

    protected Command readNeoStoreCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readMetaDataCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readGroupDegreeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readSchemaRuleCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readLegacySchemaRuleCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readNodeCountsCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipCountsCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipGroupCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipGroupExtendedCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readLabelTokenCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipTypeTokenCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readCreatedRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readDeletedRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readPropertyKeyTokenCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readPropertyCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readDeletedPropertyCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readCreatedPropertyCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public IndexUpdateCommand<?> readIndexUpdateCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readDeletedNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readCreatedNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexDefineCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexAddNodeCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexAddRelationshipCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexCreateCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexDeleteCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readIndexRemoveCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected Command readEnrichmentCommand(ReadableChannel channel) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeDeletedNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeCreatedNodeCommand(WritableChannel channel, Command.NodeCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeCreatedRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeDeletedRelationshipCommand(WritableChannel channel, Command.RelationshipCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writePropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeDeletedPropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeCreatedPropertyCommand(WritableChannel channel, Command.PropertyCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipGroupCommand(WritableChannel channel, Command.RelationshipGroupCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipTypeTokenCommand(WritableChannel channel, Command.RelationshipTypeTokenCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeLabelTokenCommand(WritableChannel channel, Command.LabelTokenCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writePropertyKeyTokenCommand(WritableChannel channel, Command.PropertyKeyTokenCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeSchemaRuleCommand(WritableChannel channel, Command.SchemaRuleCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeNodeCountsCommand(WritableChannel channel, Command.NodeCountsCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeRelationshipCountsCommand(WritableChannel channel, Command.RelationshipCountsCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeMetaDataCommand(WritableChannel channel, Command.MetaDataCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeIndexUpdateCommand(WritableChannel channel, IndexUpdateCommand<?> command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeGroupDegreeCommand(WritableChannel channel, Command.GroupDegreeCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    public void writeEnrichmentCommand(WritableChannel channel, Command.RecordEnrichmentCommand command) throws IOException {
        throw this.unsupportedInThisVersionException();
    }

    protected static IOException unknownCommandType(byte commandType, ReadableChannel channel) throws IOException {
        String message = "Unknown command type[" + commandType + "]";
        if (channel instanceof LogPositionAwareChannel) {
            LogPositionAwareChannel logChannel = (LogPositionAwareChannel)channel;
            message = message + " near " + String.valueOf(logChannel.getCurrentLogPosition());
        }
        return new IOException(message);
    }

    protected IOException unsupportedInThisVersionException() {
        return new IOException("Unsupported in this version: " + ((Object)((Object)this)).getClass().getSimpleName());
    }
}

