/*
 * Decompiled with CFR 0.152.
 */
package org.neo4j.internal.recordstorage;

import java.util.Collection;
import org.neo4j.kernel.impl.store.RecordPageLocationCalculator;
import org.neo4j.kernel.impl.store.RelationshipStore;
import org.neo4j.kernel.impl.store.StoreType;
import org.neo4j.lock.ActiveLock;
import org.neo4j.lock.LockTracer;
import org.neo4j.lock.LockType;
import org.neo4j.lock.ResourceLocker;
import org.neo4j.lock.ResourceType;

public class MultiversionResourceLocker
implements ResourceLocker {
    private final ResourceLocker locks;
    private final int recordsPerPage;
    private long lastCheckedResourceId;

    public MultiversionResourceLocker(ResourceLocker locks, RelationshipStore relationshipStore) {
        this.locks = locks;
        this.recordsPerPage = relationshipStore.getRecordsPerPage();
    }

    public boolean tryExclusiveLock(ResourceType resourceType, long resourceId) {
        if (resourceType != ResourceType.RELATIONSHIP) {
            return this.locks.tryExclusiveLock(resourceType, resourceId);
        }
        long newResourceId = this.getResourceId(resourceId);
        if (this.lastCheckedResourceId == newResourceId) {
            return false;
        }
        boolean result = this.locks.tryExclusiveLock(ResourceType.PAGE, newResourceId);
        this.lastCheckedResourceId = !result ? newResourceId : Long.MIN_VALUE;
        return result;
    }

    public void releaseExclusive(ResourceType resourceType, long ... resourceIds) {
        if (resourceType != ResourceType.RELATIONSHIP) {
            this.locks.releaseExclusive(resourceType, resourceIds);
        } else if (resourceIds.length == 1) {
            long resourceId = this.getResourceId(resourceIds[0]);
            this.locks.releaseExclusive(ResourceType.PAGE, new long[]{resourceId});
        } else {
            this.locks.releaseExclusive(resourceType, resourceIds);
        }
    }

    public void acquireExclusive(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.locks.acquireExclusive(tracer, resourceType, resourceIds);
    }

    public boolean trySharedLock(ResourceType resourceType, long resourceId) {
        return this.locks.trySharedLock(resourceType, resourceId);
    }

    public void acquireShared(LockTracer tracer, ResourceType resourceType, long ... resourceIds) {
        this.locks.releaseShared(resourceType, resourceIds);
    }

    public void releaseShared(ResourceType resourceType, long ... resourceIds) {
        this.locks.releaseShared(resourceType, resourceIds);
    }

    public Collection<ActiveLock> activeLocks() {
        return this.locks.activeLocks();
    }

    public boolean holdsLock(long id, ResourceType resource, LockType lockType) {
        return this.locks.holdsLock(id, resource, lockType);
    }

    private long getResourceId(long resourceId) {
        return RecordPageLocationCalculator.pageIdForRecord(resourceId, this.recordsPerPage) | (long)StoreType.RELATIONSHIP.ordinal() << 49;
    }
}

